/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.actions.IndentationSupport;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractIndentAction
extends AbstractHandler
implements IEditorActionDelegate {
    private IEditorPart targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();
    private MultiTextEdit multiEdit;
    private final List<String> indentArray = new ArrayList<String>();

    public final void run(IAction action) {
        this.doIndent();
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public final void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    protected abstract int lineIndentationLevel(IDocument var1, int var2, int var3, Interval var4) throws BadLocationException;

    protected abstract IDocument getDocument();

    protected abstract ISelection getSelection();

    protected final IEditorPart getTargetEditor() {
        return this.targetEditor;
    }

    private void setIndentLevel(IDocument document, int lineStart, int indentationLevel) throws BadLocationException {
        char c;
        int lastWhiteSpace;
        for (lastWhiteSpace = lineStart; lastWhiteSpace < document.getLength() && ((c = document.getChar(lastWhiteSpace)) == ' ' || c == '\t'); ++lastWhiteSpace) {
        }
        for (int i = this.indentArray.size() - 1; i < indentationLevel; ++i) {
            this.indentArray.add(this.indentArray.get(i) + IndentationSupport.getIndentString());
        }
        if (!document.get(lineStart, lastWhiteSpace - lineStart).equals(this.indentArray.get(indentationLevel))) {
            this.multiEdit.addChild((TextEdit)new ReplaceEdit(lineStart, lastWhiteSpace - lineStart, this.indentArray.get(indentationLevel)));
        }
    }

    protected final boolean containsNonWhiteSpace(String text) {
        block3: for (int i = text.length() - 1; i >= 0; --i) {
            switch (text.charAt(i)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    private int getRealLineStart(IDocument document, int startOffset, int lineLength) throws BadLocationException {
        for (int j = startOffset; j < startOffset + lineLength; ++j) {
            char c = document.getChar(j);
            if (c == ' ' || c == '\t') continue;
            return j;
        }
        return startOffset;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.doIndent();
        return null;
    }

    private void doIndent() {
        TextSelection tSelection;
        if (this.targetEditor == null) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        Interval rootInterval = GlobalIntervalHandler.getInterval(document);
        if (rootInterval == null) {
            rootInterval = new HeuristicalIntervalDetector().buildIntervals(document);
            GlobalIntervalHandler.putInterval(document, rootInterval);
        }
        if (rootInterval == null) {
            return;
        }
        int startLine = -1;
        int endLine = -1;
        this.selection = this.getSelection();
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && (tSelection = (TextSelection)this.selection).getLength() != 0) {
            startLine = tSelection.getStartLine();
            endLine = tSelection.getEndLine();
        }
        if (startLine == -1 || endLine == -1) {
            startLine = 0;
            endLine = document.getNumberOfLines() - 1;
        }
        this.indentArray.clear();
        this.indentArray.add("");
        int nofLines = endLine - startLine;
        try {
            int regionStartOffset = document.getLineOffset(startLine);
            int regionLength = document.getLineOffset(endLine) + document.getLineLength(endLine) - regionStartOffset;
            this.multiEdit = new MultiTextEdit(regionStartOffset, regionLength);
            RewriteSessionEditProcessor processor = new RewriteSessionEditProcessor(document, (TextEdit)this.multiEdit, 3);
            for (int i = nofLines; i >= 0; --i) {
                int lineLength = document.getLineLength(startLine + i);
                int offset = document.getLineOffset(startLine + i);
                int realOffset = this.getRealLineStart(document, offset, lineLength);
                Interval interval = rootInterval.getSmallestEnclosingInterval(realOffset);
                int indentLevel = this.lineIndentationLevel(document, realOffset, offset + lineLength, interval);
                this.setIndentLevel(document, document.getLineOffset(startLine + i), indentLevel);
            }
            this.performEdits(processor);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    protected abstract void performEdits(RewriteSessionEditProcessor var1) throws BadLocationException;
}

