/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class ClassCastingExpression
extends Expression_Value {
    private static final String UNNECESSARYCAST = "Unnecessary cast: class is cast to itself";
    private static final String CLASSREFERENCEEXPECTED = "Reference to a class object was expected";
    private static final String CLASSTYPEEXPECTED = "Class type was expected";
    private static final String CANNOTCAST = "Cannot cast an object of class type `{0}'' to class type `{1}''";
    private final Reference rightReference;
    private Type type;
    private Reference leftReference;

    public ClassCastingExpression(Type type, Reference reference) {
        this.type = type;
        this.rightReference = reference;
        this.leftReference = null;
        if (this.type != null) {
            this.type.setFullNameParent(this);
        }
        if (this.rightReference != null) {
            this.rightReference.setFullNameParent(this);
        }
    }

    public ClassCastingExpression(Reference leftReference, Reference reference) {
        this.leftReference = leftReference;
        this.rightReference = reference;
        this.type = null;
        if (this.leftReference != null) {
            this.leftReference.setFullNameParent(this);
        }
        if (this.rightReference != null) {
            this.rightReference.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.CLASS_CASTING_OPERATION;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_CLASS;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IType governor = super.getMyGovernor();
        if (governor != null) {
            return governor;
        }
        return new Class_Type();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.leftReference != null) {
            this.leftReference.setMyScope(scope);
        }
        if (this.rightReference != null) {
            this.rightReference.setMyScope(scope);
        }
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.leftReference == null && this.rightReference == null || this.type == null && this.rightReference == null) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (!this.isUnfoldable(timestamp)) {
            IType leftRefType;
            if (this.type != null) {
                this.setMyGovernor(this.type.getTypeRefdLast(timestamp));
            }
            if (this.leftReference != null && (leftRefType = this.leftReference.checkVariableReference(timestamp)) != null) {
                this.setMyGovernor(leftRefType.getTypeRefdLast(timestamp));
            }
        }
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.leftReference != null) {
            this.leftReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.leftReference.getLocation());
        }
        if (this.rightReference != null) {
            this.rightReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.rightReference.getLocation());
        }
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType leftRefType;
        if (this.type != null) {
            return this.type.isIdentical(timestamp, this.rightReference.checkVariableReference(timestamp));
        }
        if (this.leftReference != null && (leftRefType = this.leftReference.checkVariableReference(timestamp)) != null) {
            return leftRefType.isIdentical(timestamp, this.rightReference.checkVariableReference(timestamp));
        }
        return false;
    }

    @Override
    public String createStringRepresentation() {
        return null;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.leftReference != null && !this.leftReference.accept(v)) {
            return false;
        }
        return this.rightReference == null || this.rightReference.accept(v);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType typeRefdLast = null;
        IType refType = this.rightReference.checkVariableReference(timestamp);
        if (refType != null) {
            typeRefdLast = refType.getTypeRefdLast(timestamp);
            if (typeRefdLast.getTypetype() != IType.Type_type.TYPE_CLASS) {
                this.rightReference.getLocation().reportSemanticError(CLASSREFERENCEEXPECTED);
                this.setIsErroneous(true);
            }
        } else {
            this.setIsErroneous(true);
        }
        if (this.type != null) {
            Class_Type oldClass;
            Class_Type newClass;
            this.type.check(timestamp);
            IType typeLast = this.type.getTypeRefdLast(timestamp);
            if (typeLast.getTypetype() != IType.Type_type.TYPE_CLASS) {
                this.type.getLocation().reportSemanticError(CLASSTYPEEXPECTED);
                this.setIsErroneous(true);
            } else if (!(this.getIsErroneous(timestamp) || (newClass = typeLast.getClassType()).isParentClass(timestamp, oldClass = typeRefdLast.getClassType()) || oldClass.isParentClass(timestamp, newClass))) {
                this.getLocation().reportSemanticError(MessageFormat.format(CANNOTCAST, typeRefdLast.getTypename(), this.type.getTypename()));
            }
        }
        if (this.leftReference != null && this.leftReference.checkVariableReference(timestamp) == null) {
            this.setIsErroneous(true);
        }
    }
}

