/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PropertyBody;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PropertyFunctionContainer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Property_Function
extends Scope
implements ILocateableNode {
    private static final String CANNOTHAVEABSTRACT = "Concrete class type `{0}'' cannot have abstract {1}";
    private static final String CANNOTINHERITFINAL = "Cannot inherit {0} with the @final modifier";
    private Location location;
    private Location modifierLocation;
    private Location visibilityLocation;
    protected CompilationTimeStamp lastTimeChecked;
    protected boolean isAbstract;
    protected boolean isFinal;
    protected boolean isDeterministic;
    private VisibilityModifier visibility;
    protected Definition myDef;

    public Property_Function(boolean isAbstract, boolean isFinal, boolean isDeterministic) {
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.isDeterministic = isDeterministic;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.parentScope.getAssBySRef(timestamp, reference);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain referenceChain) {
        return this.parentScope.getAssBySRef(timestamp, reference, referenceChain);
    }

    public void check(CompilationTimeStamp timestamp, Definition definition) {
        this.myDef = definition;
        this.parentScope = this.myDef.getMyScope();
        if (this.visibility == VisibilityModifier.Friend) {
            this.visibility = this.myDef.getVisibility();
        }
        String functionName = this.isInGetterScope() ? "getter" : "setter";
        Class_Type parentClass = this.parentScope.getScopeClass();
        if (parentClass == null) {
            ErrorReporter.INTERNAL_ERROR((String)"Property_Function::check()");
        }
        if (this.isAbstract && !parentClass.isAbstract() && !parentClass.isTrait()) {
            this.location.reportSemanticError(MessageFormat.format(CANNOTHAVEABSTRACT, parentClass.getTypename(), functionName));
        }
        PropertyFunctionContainer container = PropertyBody.getInheritedPropertyFunction(timestamp, this.myDef, this.isInGetterScope());
        if (container.isAutomatic && container.function != null && container.function.isFinal) {
            this.location.reportSemanticError(MessageFormat.format(CANNOTINHERITFINAL, functionName));
        } else if (container.isAutomatic && container.definition.isFinal()) {
            this.location.reportSemanticError(MessageFormat.format(CANNOTINHERITFINAL, functionName));
        }
    }

    public Definition getMyDefinition() {
        return this.myDef;
    }

    public void setModifierLocation(Location location) {
        this.modifierLocation = location;
    }

    public Location getModifierLocation() {
        return this.modifierLocation;
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public VisibilityModifier getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityModifier visibility) {
        this.visibility = visibility;
    }

    public Location getVisibilityLocation() {
        return this.visibilityLocation;
    }

    public void setVisibilityLocation(Location visibilityLocation) {
        this.visibilityLocation = visibilityLocation;
    }

    public Scope getFinalScope(CompilationTimeStamp timestamp) {
        Component_Type component;
        Class_Type classType = this.getScopeClass();
        Scope currentScope = this;
        Module currentMod = this.getModuleScope();
        if (currentMod == null) {
            ErrorReporter.INTERNAL_ERROR((String)"PropertyFunction::getFinalScope()");
        }
        if (classType.getSystemType(timestamp) != null && (component = currentMod.getMtcSystemComponentType(timestamp, true)) != null) {
            Scope systemScope = component.getMyScope();
            systemScope.setParentScope(currentScope);
            currentScope = systemScope;
        }
        if (classType.getMtcType(timestamp) != null && (component = currentMod.getMtcSystemComponentType(timestamp, false)) != null) {
            Scope mtcScope = component.getMyScope();
            mtcScope.setParentScope(currentScope);
            currentScope = mtcScope;
        }
        if (classType.getRunsOnType(timestamp) != null) {
            RunsOnScope runsOnScope = currentMod.getScopeRunsOn();
            runsOnScope.setParentScope(currentScope);
            currentScope = runsOnScope;
        }
        return currentScope;
    }
}

