/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.pages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.preferences.pages.LogViewerPreferenceRootPage;
import org.eclipse.titan.log.viewer.utils.ImportExportUtils;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IWorkbench;

public class FilteredPortsPreferencePage
extends LogViewerPreferenceRootPage {
    private BooleanFieldEditor connectingPortsEditor;
    private BooleanFieldEditor mappingPortsEditor;

    public FilteredPortsPreferencePage() {
        super(1, false);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("FilteredPortsPreferencePage.0"));
    }

    @Override
    public void createFieldEditors() {
        this.connectingPortsEditor = new BooleanFieldEditor("org.eclipse.titan.log.connecting_ports_id", Messages.getString("FilteredPortsPreferencePage.1"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.connectingPortsEditor);
        this.mappingPortsEditor = new BooleanFieldEditor("org.eclipse.titan.log.mapping_ports_id", Messages.getString("FilteredPortsPreferencePage.2"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.mappingPortsEditor);
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.log.viewer.properties.FilteredPortsPreferencePage";
    }

    private Map<String, String> getCurrentPreferences() {
        HashMap<String, String> currentPrefs = new HashMap<String, String>();
        String connectingPorts = String.valueOf(this.connectingPortsEditor.getBooleanValue());
        String mappingPorts = String.valueOf(this.mappingPortsEditor.getBooleanValue());
        currentPrefs.put("org.eclipse.titan.log.connecting_ports_id", connectingPorts);
        currentPrefs.put("org.eclipse.titan.log.mapping_ports_id", mappingPorts);
        return currentPrefs;
    }

    private Map<String, String[]> getCurrentPreferencesSeparated() {
        HashMap<String, String[]> currentPrefs = new HashMap<String, String[]>();
        String[] connectingPorts = new String[]{String.valueOf(this.connectingPortsEditor.getBooleanValue())};
        currentPrefs.put("org.eclipse.titan.log.connecting_ports_id", connectingPorts);
        String[] mappingPorts = new String[]{String.valueOf(this.mappingPortsEditor.getBooleanValue())};
        currentPrefs.put("org.eclipse.titan.log.mapping_ports_id", mappingPorts);
        return currentPrefs;
    }

    @Override
    protected void exportPreferences() {
        ImportExportUtils.exportSettings(this.getPageId(), this.getCurrentPreferencesSeparated(), true);
    }

    @Override
    protected void importPreferences() {
        Map<String, String> prop = ImportExportUtils.importSettings("org.eclipse.titan.log.viewer.properties.FilteredPortsPreferencePage");
        if (prop == null) {
            return;
        }
        this.setOldPreferences(this.getCurrentPreferences());
        this.setProperties(prop);
        this.getApplyButton().setEnabled(true);
    }

    @Override
    protected void updatePage() {
        this.connectingPortsEditor.load();
        this.mappingPortsEditor.load();
    }
}

