/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TTCN3PreprocessorOptionsData {
    public static final String TTCN3_PREPROCESSOR_PROPERTY = "TTCN3preprocessor";
    public static final String TTCN3_PREPROCESSOR_TAG = "TTCN3preprocessor";
    public static final String DEFAULT_PREPROCESSOR = "cpp";

    public static String getPreprocessorName(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"));
            if (temp == null || temp.length() == 0) {
                temp = DEFAULT_PREPROCESSOR;
            }
            return temp;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While reading the preprecessor name of `" + project.getName() + "'"), (Throwable)e);
            return DEFAULT_PREPROCESSOR;
        }
    }

    private TTCN3PreprocessorOptionsData() {
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing attributes from project `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        NodeList resourceList = root.getChildNodes();
        String newValue = DEFAULT_PREPROCESSOR;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            if (!"TTCN3preprocessor".equals(name)) continue;
            newValue = node.getTextContent();
        }
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor");
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While loading makefile settings of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"));
            if (temp != null && !DEFAULT_PREPROCESSOR.equals(temp)) {
                Element node = document.createElement("TTCN3preprocessor");
                node.appendChild(document.createTextNode(temp));
                makefileSettings.appendChild(node);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving makefile settings of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        NodeList resourceList = source.getChildNodes();
        String newValue = DEFAULT_PREPROCESSOR;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            if (!"TTCN3preprocessor".equals(name)) continue;
            newValue = node.getTextContent();
        }
        if (saveDefaultValues || newValue != null && !DEFAULT_PREPROCESSOR.equals(newValue)) {
            Element node = document.createElement("TTCN3preprocessor");
            node.appendChild(document.createTextNode(newValue));
            makefileSettings.appendChild(node);
        }
    }
}

