/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.HashMap;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;

public class CallHierarchyNode {
    private Module nodeModule;
    private Definition nodeDefinition;
    private HashMap<Definition, CallHierarchyNode> nodeChildren;
    private HashMap<Reference, Module> nodeReferences;

    public CallHierarchyNode() {
        this(null, null);
    }

    public CallHierarchyNode(Module nodeModule, Definition nodeDefinition) {
        this.nodeModule = nodeModule;
        this.nodeDefinition = nodeDefinition;
        this.nodeChildren = new HashMap();
        this.nodeReferences = new HashMap();
    }

    public String getName() {
        return this.nodeDefinition.getFullName();
    }

    public Definition getNodeDefinition() {
        return this.nodeDefinition;
    }

    public String getModuleName() {
        return this.nodeModule.getFullName();
    }

    public Module getNodeModule() {
        return this.nodeModule;
    }

    public Object[] getReferences() {
        return this.nodeReferences.keySet().toArray();
    }

    public int getReferencesNumber() {
        return this.nodeReferences.size();
    }

    public Object[] getChildren() {
        return this.nodeChildren.values().toArray();
    }

    public boolean hasChildren() {
        return this.nodeChildren.size() > 0;
    }

    public void addChild(CallHierarchyNode node) {
        this.nodeChildren.put(node.getNodeDefinition(), node);
    }

    public void addChild(Module referenceModule, Reference reference) {
        Definition parentDefinition = this.getReferenceParent(reference);
        if (parentDefinition == null) {
            return;
        }
        CallHierarchyNode node = this.addNode(referenceModule, parentDefinition);
        node.addReference(referenceModule, reference);
    }

    public void addReference(Module referenceModule, Reference reference) {
        this.nodeReferences.put(reference, referenceModule);
    }

    private CallHierarchyNode addNode(Module definitionModule, Definition definition) {
        if (this.nodeChildren.containsKey(definition)) {
            return this.nodeChildren.get(definition);
        }
        CallHierarchyNode newNode = new CallHierarchyNode(definitionModule, definition);
        this.nodeChildren.put(definition, newNode);
        return newNode;
    }

    private Definition getReferenceParent(Reference reference) {
        INamedNode referenceParentNode;
        for (referenceParentNode = reference.getNameParent().getNameParent().getNameParent().getNameParent(); !(referenceParentNode instanceof Definition) && referenceParentNode != null; referenceParentNode = referenceParentNode.getNameParent()) {
        }
        if (!(referenceParentNode instanceof Definition)) {
            return null;
        }
        return (Definition)referenceParentNode;
    }

    public void clearNode() {
        this.nodeChildren.clear();
        this.nodeReferences.clear();
    }
}

