/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.makefile;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.ResourceUtils;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.makefile.BaseDirectoryStruct;
import org.eclipse.titan.designer.core.makefile.InternalMakefileGenerator;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;

public final class MakefileGeneratorVisitor
implements IResourceVisitor {
    private final InternalMakefileGenerator makefileGenerator;
    private final IProject projectVisited;
    private final IContainer[] workingDirectories;
    private final String actualWorkingDirectory;
    private final List<URI> centralStorages = new ArrayList<URI>();
    private final ResourceExclusionHelper helper;

    public MakefileGeneratorVisitor(InternalMakefileGenerator makefileGenerator, IProject project) {
        this.makefileGenerator = makefileGenerator;
        this.projectVisited = project;
        this.helper = new ResourceExclusionHelper();
        this.workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(false);
        IPath path = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(false);
        this.actualWorkingDirectory = path != null ? path.toOSString() : null;
        if (this.workingDirectories.length > 0) {
            this.makefileGenerator.addBaseDirectory(this.workingDirectories[0].getLocation());
        } else if (path != null) {
            this.makefileGenerator.addBaseDirectory(path.toOSString());
        }
        this.makefileGenerator.setAllProjectsUseSymbolicLinks(this.makefileGenerator.isAllProjectsUseSymbolicLinks() && ProjectBuildPropertyData.useSymbolicLinks(project));
    }

    public boolean visit(IResource resource) throws CoreException {
        if (!resource.isAccessible()) {
            return false;
        }
        URI resourceURI = resource.getLocationURI();
        String resourceName = new Path(resourceURI.getPath()).lastSegment();
        if (resourceName.startsWith(".")) {
            return false;
        }
        try {
            URI resolved = resource.getWorkspace().getPathVariableManager().resolveURI(resource.getLocationURI());
            IFileStore store = EFS.getStore((URI)resolved);
            IFileInfo fileInfo = store.fetchInfo();
            if (!fileInfo.exists()) {
                return false;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        switch (resource.getType()) {
            case 1: {
                IFile file;
                String extension;
                if (ResourceExclusionHelper.isDirectlyExcluded((IFile)resource) || this.helper.isExcludedByRegexp(resourceName)) {
                    return false;
                }
                String folder = this.projectVisited == this.makefileGenerator.getProject() ? null : this.actualWorkingDirectory;
                block6: for (URI centralStorage : this.getCentralStorages()) {
                    if (resourceURI.getHost() != centralStorage.getHost() || !resourceURI.getPath().startsWith(centralStorage.getPath())) continue;
                    folder = centralStorage.getPath();
                    for (BaseDirectoryStruct dir : this.makefileGenerator.getBaseDirectories()) {
                        if (dir.getDirectory() == null || !dir.getDirectory().isPrefixOf(resource.getFullPath())) continue;
                        dir.setHasModules(true);
                        break block6;
                    }
                }
                if (resource.getLocation() == null && folder == null) {
                    folder = this.actualWorkingDirectory;
                }
                if ("ttcn3".equals(extension = (file = (IFile)resource).getFileExtension()) || "ttcn".equals(extension)) {
                    this.makefileGenerator.addTTCN3Module(file, folder);
                } else if ("asn".equals(extension) || "asn1".equals(extension)) {
                    this.makefileGenerator.addASN1Module(file, folder);
                } else if ("ttcnpp".equals(extension)) {
                    this.makefileGenerator.addPreprocessingModule(file, folder);
                } else if ("ttcnin".equals(extension)) {
                    this.makefileGenerator.addIncludeModule(file, folder);
                } else if ("c".equals(extension) || "cc".equals(extension)) {
                    this.makefileGenerator.addUserSourceFile(file, folder);
                } else if ("h".equals(extension) || "hh".equals(extension)) {
                    this.makefileGenerator.addUserHeaderFile(file, folder);
                } else {
                    this.makefileGenerator.addOtherFiles(file, folder);
                }
                return false;
            }
            case 2: {
                for (IContainer workingDirectory : this.workingDirectories) {
                    if (!workingDirectory.equals(resource)) continue;
                    if (this.projectVisited != this.makefileGenerator.getProject()) {
                        this.makefileGenerator.addBaseDirectory(resource.getLocation());
                    }
                    return false;
                }
                if (ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource) || this.helper.isExcludedByRegexp(resourceName)) {
                    return false;
                }
                if (!ResourceUtils.getBooleanPersistentProperty((IResource)resource, (String)"org.eclipse.titan.designer.Properties.Folder", (String)"centralStorage")) break;
                this.makefileGenerator.addBaseDirectory(resource.getLocation());
                this.getCentralStorages().add(resourceURI);
                break;
            }
        }
        return true;
    }

    public List<URI> getCentralStorages() {
        return this.centralStorages;
    }
}

