/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Referenced_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Template_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Value_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReparseUtilities;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class FormalParameter
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<default_value>";
    public static final String PORTTYPENOTALLOWEDAS = "Port type can not be used as {0}";
    public static final String SIGNATURENOTALLOWEDAS = "Signature types can not be used as {1}";
    private static final String SPECIFICVALUEXPECTED = "A specific value without matching symbols was expected for a {0}";
    private static final String EXPLICITESPECIFICATIONFORTIMER = "Explicit type specification cannot be used for a timer parameter";
    private static final String INLINETEMPLATEFORTIMER = "An in-line modified template cannot be used as timer parameter";
    private static final String SUBREFERENCEERROR1 = "Reference to single {0} cannot have field or array sub-references";
    private static final String SUBREFERENCEERROR2 = "Reference to {0} cannot have sub-references";
    private static final String SUBREFERENCEERROR3 = "Reference to {0} cannot have field or array sub-references";
    private static final String TIMEREXPECTED1 = "Reference to a timer or timer parameter was expected for a timer parameter instead of {0}";
    private static final String TIMEREXPECTED2 = "Reference to a timer or timer parameter was expected for a time parameter";
    private static final String PORTEXPECTED = "Reference to a port or port parameter was expected for a port parameter instead of {0}";
    private static final String TYPEMISMATCH = "Type mismatch: Reference to a port or port parameter of type `{0}'' was expected instead of `{1}''";
    private static final String EXPLICITESPECIFICATIONFORREFERENCE = "Explicit type specification is useless for an {0}";
    private static final String INLINETEMPLATEFORREFERENCE = "An in-line modified template cannot be used as {0}";
    private static final String TYPEMISMATCH2 = "Type mismatch: Reference to a {0} of type `{1}'' was expected instead of `{2}''";
    private static final String SUBTYPEMISMATCH = "Subtype mismatch: subtype {0} has no common value with subtype {1}";
    private static final String REFERENCEEXPECTED1 = "Reference to a {0} was expected for an {1} instead of {2}";
    private static final String REFERENCEEXPECTED2 = "Reference to a {0} was expected for an {1}";
    private static final String REFERENCEEXPECTED3 = "Reference to a string element of type `{0}'' cannot be used in this context";
    private static final String KIND = "formal parameter";
    private final Assignment.Assignment_type assignmentType;
    private final Type type;
    private TemplateInstance defaultValue;
    private ActualParameter actualDefaultParameter;
    private Assignment.Assignment_type realAssignmentType;
    private boolean usedAsLValue;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private FormalParameterList myParameterList;
    private final parameterEvaluationType evaluationType;
    private boolean wasAssigned;

    public FormalParameter(TemplateRestriction.Restriction_type templateRestriction, Assignment.Assignment_type assignmentType, Type type, Identifier identifier, TemplateInstance defaultValue, parameterEvaluationType evaluationType) {
        super(identifier);
        this.assignmentType = assignmentType;
        this.realAssignmentType = assignmentType;
        this.type = type;
        this.defaultValue = defaultValue;
        this.usedAsLValue = false;
        this.templateRestriction = templateRestriction;
        this.evaluationType = evaluationType;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_FORMAL_PAR, this);
            type.setFullNameParent(this);
        }
        if (defaultValue != null) {
            defaultValue.setFullNameParent(this);
        }
    }

    private FormalParameter(Assignment.Assignment_type assignmentType, FormalParameter other) {
        super(other.identifier);
        super.setFullNameParent(other.getNameParent());
        this.assignmentType = assignmentType;
        this.realAssignmentType = assignmentType;
        this.type = other.type;
        this.defaultValue = other.defaultValue;
        this.usedAsLValue = false;
        this.templateRestriction = other.templateRestriction;
        this.evaluationType = other.evaluationType;
        this.myScope = other.myScope;
        this.lastTimeChecked = other.lastTimeChecked;
        this.location = other.location;
        this.parentGroup = other.parentGroup;
        if (this.type != null) {
            this.type.setOwnertype(IType.TypeOwner_type.OT_FORMAL_PAR, this);
            this.type.setFullNameParent(this);
        }
        if (this.defaultValue != null) {
            this.defaultValue.setFullNameParent(this);
        }
    }

    public parameterEvaluationType getEvaluationType() {
        return this.evaluationType;
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return this.realAssignmentType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.defaultValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.actualDefaultParameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public FormalParameterList getMyParameterList() {
        return this.myParameterList;
    }

    public void setFormalParamaterList(FormalParameterList list) {
        this.myParameterList = list;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public void setDefaultValue(TemplateInstance otherValue) {
        this.defaultValue = new TemplateInstance(otherValue.getType(), otherValue.getDerivedReference(), otherValue.getTemplateBody());
    }

    public TemplateInstance getDefaultParameter() {
        return this.defaultValue;
    }

    public ActualParameter getDefaultValue() {
        return this.actualDefaultParameter;
    }

    public boolean hasNotusedDefaultValue() {
        if (this.defaultValue == null || this.defaultValue.getTemplateBody() == null) {
            return false;
        }
        return ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)this.defaultValue.getTemplateBody().getTemplatetype());
    }

    public Assignment.Assignment_type getRealAssignmentType() {
        return this.realAssignmentType;
    }

    @Override
    public String getAssignmentName() {
        switch (this.realAssignmentType) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: {
                return "value parameter";
            }
            case A_PAR_VAL_OUT: {
                return "`out' value parameter";
            }
            case A_PAR_VAL_INOUT: {
                return "`inout' value parameter";
            }
            case A_PAR_TEMP_IN: {
                return "template parameter";
            }
            case A_PAR_TEMP_OUT: {
                return "`out' template parameter";
            }
            case A_PAR_TEMP_INOUT: {
                return "`inout' template parameter";
            }
            case A_PAR_TIMER: {
                return "timer parameter";
            }
            case A_PAR_PORT: {
                return "port parameter";
            }
        }
        return "<unknown formal parameter>";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder(this.getAssignmentName());
        return builder.append(" `").append(this.identifier.getDisplayName()).append('\'').toString();
    }

    @Override
    public String getOutlineIcon() {
        return "titan.gif";
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.defaultValue != null) {
            this.defaultValue.setMyScope(scope);
        }
        if (this.actualDefaultParameter != null) {
            this.actualDefaultParameter.setMyScope(scope);
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public FormalParameter setParameterType(Assignment.Assignment_type newType) {
        return new FormalParameter(newType, this);
    }

    public boolean getUsedAsLvalue() {
        return this.usedAsLValue;
    }

    public void useAsLValue(Reference reference) {
        switch (this.getRealAssignmentType()) {
            case A_PAR_VAL_IN: 
            case A_PAR_TEMP_IN: {
                break;
            }
            default: {
                return;
            }
        }
        if (!this.usedAsLValue) {
            Definition definition = this.myParameterList.getMyDefinition();
            if (definition == null) {
                return;
            }
            if (Assignment.Assignment_type.A_TEMPLATE.semanticallyEquals(definition.getAssignmentType())) {
                reference.getLocation().reportSemanticError(MessageFormat.format("Parameter `{0}'' of the template cannot be passed further as `out'' or `inout'' parameter", this.identifier.getDisplayName()));
            } else {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    this.setGenName(this.identifier.getName() + "_shadow");
                }
                this.usedAsLValue = true;
            }
        }
    }

    public void reset() {
        this.isUsed = false;
        this.wasAssigned = false;
        this.usedAsLValue = false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.evaluationType != parameterEvaluationType.NORMAL_EVAL && (this.assignmentType == Assignment.Assignment_type.A_PAR_TEMP_OUT || this.assignmentType == Assignment.Assignment_type.A_PAR_TEMP_INOUT)) {
            this.getLocation().reportSemanticError(MessageFormat.format("Only `in'' formal template parameters can have @{0} evaluation", this.evaluationType == parameterEvaluationType.LAZY_EVAL ? "lazy" : "fuzzy"));
        }
        if (this.type != null) {
            this.type.check(timestamp);
            IType lastType = this.type.getTypeRefdLast(timestamp);
            if (lastType == null) {
                NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionFormalParameter", this.identifier, this);
                return;
            }
            if (IType.Type_type.TYPE_PORT.equals((Object)lastType.getTypetype())) {
                switch (this.realAssignmentType) {
                    case A_PAR_PORT: {
                        break;
                    }
                    case A_PAR_VAL: 
                    case A_PAR_VAL_INOUT: {
                        this.realAssignmentType = Assignment.Assignment_type.A_PAR_PORT;
                        break;
                    }
                    default: {
                        this.location.reportSemanticError(MessageFormat.format(PORTTYPENOTALLOWEDAS, this.getAssignmentName()));
                        break;
                    }
                }
            } else if (IType.Type_type.TYPE_SIGNATURE.equals((Object)lastType.getTypetype())) {
                switch (this.realAssignmentType) {
                    case A_PAR_TEMP_IN: 
                    case A_PAR_TEMP_OUT: 
                    case A_PAR_TEMP_INOUT: {
                        break;
                    }
                    default: {
                        this.location.reportSemanticError(MessageFormat.format(SIGNATURENOTALLOWEDAS, this.getAssignmentName()));
                    }
                }
            }
        }
        if (this.defaultValue != null) {
            this.actualDefaultParameter = this.checkActualParameter(timestamp, this.defaultValue, Expected_Value_type.EXPECTED_STATIC_VALUE);
            if (this.actualDefaultParameter != null) {
                this.actualDefaultParameter.setFullNameParent(this);
                this.actualDefaultParameter.setLocation(this.defaultValue.getLocation());
            }
            this.defaultValue.setCodeSection(GovernedSimple.CodeSectionType.CS_POST_INIT);
            this.actualDefaultParameter.setCodeSection(GovernedSimple.CodeSectionType.CS_POST_INIT);
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionFormalParameter", this.identifier, this);
    }

    @Override
    public void postCheck() {
        int refcount = this.getReferenceCount();
        if (refcount == 0) {
            AstSyntaxHighlightTokens.addSyntaxDecoration(this.getIdentifier().getLocation(), AstSyntaxHighlightTokens.SyntaxDecoration.Unused);
        }
    }

    public boolean getWritten() {
        return this.wasAssigned;
    }

    public void setWritten() {
        this.wasAssigned = true;
    }

    public ActualParameter checkActualParameter(CompilationTimeStamp timestamp, TemplateInstance parameter, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Checking an actual parameter against a not yet checked formal parameter: " + this.getFullName()));
        }
        switch (this.realAssignmentType) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: {
                return this.checkActualParameterValue(timestamp, parameter, expectedValue);
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                return this.checkActualParameterByReference(timestamp, parameter, false, expectedValue);
            }
            case A_PAR_TEMP_IN: {
                return this.checkActualParameterTemplate(timestamp, parameter);
            }
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                return this.checkActualParameterByReference(timestamp, parameter, true, expectedValue);
            }
            case A_PAR_TIMER: {
                return this.checkActualParameterTimer(timestamp, parameter, expectedValue);
            }
            case A_PAR_PORT: {
                return this.checkActualParameterPort(timestamp, parameter, expectedValue);
            }
        }
        Value_ActualParameter temp = new Value_ActualParameter(null);
        temp.setIsErroneous();
        return temp;
    }

    private ActualParameter checkActualParameterValue(CompilationTimeStamp timestamp, TemplateInstance actualParameter, Expected_Value_type expectedValue) {
        IValue value;
        actualParameter.checkType(timestamp, this.type);
        Reference derivedReference = actualParameter.getDerivedReference();
        if (derivedReference != null) {
            actualParameter.checkDerivedReference(timestamp, this.type);
        }
        TTCN3Template template = actualParameter.getTemplateBody();
        if (this.type != null && (value = template.getValue()) != null) {
            value.setMyGovernor(this.type);
            IValue temp = this.type.checkThisValueRef(timestamp, value);
            if (!IValue.Value_type.NOTUSED_VALUE.equals((Object)temp.getValuetype())) {
                Reference reference;
                this.type.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(expectedValue, false, false, true, false, false));
                if (IValue.Value_type.REFERENCED_VALUE.equals((Object)temp.getValuetype()) && (reference = ((Referenced_Value)temp).getReference()).refersToStringElement()) {
                    value.set_needs_conversion();
                }
            }
            return new Value_ActualParameter(temp);
        }
        actualParameter.getLocation().reportSemanticError(MessageFormat.format(SPECIFICVALUEXPECTED, this.getAssignmentName()));
        Value_ActualParameter temp = new Value_ActualParameter(null);
        temp.setIsErroneous();
        return temp;
    }

    private ActualParameter checkActualParameterTemplate(CompilationTimeStamp timestamp, TemplateInstance actualParameter) {
        actualParameter.check(timestamp, this.type);
        TemplateInstance instance = new TemplateInstance(actualParameter.getType(), actualParameter.getDerivedReference(), actualParameter.getTemplateBody());
        Template_ActualParameter returnValue = new Template_ActualParameter(instance);
        if (!TemplateRestriction.Restriction_type.TR_NONE.equals((Object)this.templateRestriction)) {
            instance.checkRestriction(timestamp, this);
        }
        return returnValue;
    }

    private ActualParameter checkActualParameterTimer(CompilationTimeStamp timestamp, TemplateInstance actualParameter, Expected_Value_type expectedValue) {
        TTCN3Template template;
        Reference derivedReference;
        Type parameterType = actualParameter.getType();
        if (parameterType != null) {
            actualParameter.getLocation().reportSemanticError(EXPLICITESPECIFICATIONFORTIMER);
            actualParameter.checkType(timestamp, null);
        }
        if ((derivedReference = actualParameter.getDerivedReference()) != null) {
            derivedReference.getLocation().reportSemanticError(INLINETEMPLATEFORTIMER);
            actualParameter.checkDerivedReference(timestamp, null);
        }
        if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)(template = actualParameter.getTemplateBody()).getTemplatetype()) && ((SpecificValue_Template)template).isReference()) {
            Reference reference = ((SpecificValue_Template)template).getReference();
            Assignment assignment = reference.getRefdAssignment(timestamp, true, null);
            if (assignment == null) {
                Value_ActualParameter temp = new Value_ActualParameter(null);
                temp.setIsErroneous();
                return temp;
            }
            switch (assignment.getAssignmentType()) {
                case A_TIMER: {
                    ArrayDimensions dimensions = ((Def_Timer)assignment).getDimensions();
                    if (dimensions != null) {
                        dimensions.checkIndices(timestamp, reference, "timer", false, expectedValue, false);
                        break;
                    }
                    if (reference.getSubreferences().size() <= 1) break;
                    reference.getLocation().reportSemanticError(MessageFormat.format(SUBREFERENCEERROR1, assignment.getDescription()));
                    break;
                }
                case A_PAR_TIMER: {
                    if (reference.getSubreferences().size() <= 1) break;
                    reference.getLocation().reportSemanticError(MessageFormat.format(SUBREFERENCEERROR2, assignment.getDescription()));
                    break;
                }
                default: {
                    reference.getLocation().reportSemanticError(MessageFormat.format(TIMEREXPECTED1, assignment.getAssignmentName()));
                }
            }
            return new Referenced_ActualParameter(reference);
        }
        actualParameter.getLocation().reportSemanticError(TIMEREXPECTED2);
        Value_ActualParameter temp = new Value_ActualParameter(null);
        temp.setIsErroneous();
        return temp;
    }

    private ActualParameter checkActualParameterPort(CompilationTimeStamp timestamp, TemplateInstance actualParameter, Expected_Value_type expectedValue) {
        IValue value;
        TTCN3Template parameterTemplate;
        Reference derivedReference;
        Type parameterType = actualParameter.getType();
        if (parameterType != null) {
            parameterType.getLocation().reportSemanticWarning("Explicit type specification is useless for a port parameter");
            actualParameter.checkType(timestamp, this.type);
        }
        if ((derivedReference = actualParameter.getDerivedReference()) != null) {
            derivedReference.getLocation().reportSemanticError("An in-line modified temlate cannot be used as port parameter");
            actualParameter.checkDerivedReference(timestamp, this.type);
        }
        if (((SpecificValue_Template)(parameterTemplate = actualParameter.getTemplateBody())).isReference()) {
            Type referredType;
            Reference reference = ((SpecificValue_Template)parameterTemplate).getReference();
            Assignment assignment = reference.getRefdAssignment(timestamp, true);
            if (assignment == null) {
                Value_ActualParameter temp = new Value_ActualParameter(null);
                temp.setIsErroneous();
                return temp;
            }
            switch (assignment.getAssignmentType()) {
                case A_PORT: {
                    ArrayDimensions dimensions = ((Def_Port)assignment).getDimensions();
                    if (dimensions != null) {
                        dimensions.checkIndices(timestamp, reference, "port", false, expectedValue, false);
                    } else if (reference.getSubreferences().size() > 1) {
                        reference.getLocation().reportSemanticError(MessageFormat.format(SUBREFERENCEERROR1, assignment.getDescription()));
                    }
                    referredType = ((Def_Port)assignment).getType(timestamp);
                    break;
                }
                case A_PAR_PORT: {
                    if (reference.getSubreferences().size() > 1) {
                        reference.getLocation().reportSemanticError(MessageFormat.format(SUBREFERENCEERROR3, assignment.getDescription()));
                    }
                    referredType = ((FormalParameter)assignment).getType(timestamp);
                    break;
                }
                default: {
                    reference.getLocation().reportSemanticError(MessageFormat.format(PORTEXPECTED, assignment.getDescription()));
                    Value_ActualParameter temp = new Value_ActualParameter(null);
                    temp.setIsErroneous();
                    return temp;
                }
            }
            if (referredType != null && this.type != null && !this.type.isIdentical(timestamp, referredType)) {
                reference.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH, this.type.getTypename(), referredType.getTypename()));
            }
            return new Referenced_ActualParameter(reference);
        }
        if (parameterTemplate instanceof SpecificValue_Template && (value = ((SpecificValue_Template)parameterTemplate).getValue()).getValuetype().equals((Object)IValue.Value_type.EXPRESSION_VALUE) && ((Expression_Value)value).getOperationType().equals((Object)Expression_Value.Operation_type.GETPORTREFERENCE_OPERATION)) {
            value.setMyGovernor(this.type);
            IValue temp = this.type.checkThisValueRef(timestamp, value);
            this.type.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(expectedValue, false, false, true, false, false));
            return new Value_ActualParameter(temp);
        }
        actualParameter.getLocation().reportSemanticError("Reference to a port or port parameter was expected for a port parameter");
        Value_ActualParameter temp = new Value_ActualParameter(null);
        temp.setIsErroneous();
        return temp;
    }

    private ActualParameter checkActualParameterByReference(CompilationTimeStamp timestamp, TemplateInstance parameter, boolean isTemplate, Expected_Value_type expectedValue) {
        Reference derivedReference;
        Type parameterType = parameter.getType();
        if (parameterType != null) {
            parameterType.getLocation().reportSemanticWarning(MessageFormat.format(EXPLICITESPECIFICATIONFORREFERENCE, this.getAssignmentName()));
            parameter.checkType(timestamp, this.type);
        }
        if ((derivedReference = parameter.getDerivedReference()) != null) {
            derivedReference.getLocation().reportSemanticError(MessageFormat.format(INLINETEMPLATEFORREFERENCE, this.getAssignmentName()));
            parameter.checkDerivedReference(timestamp, this.type);
        }
        String expectedString = isTemplate ? "template variable or template parameter" : "variable or value parameter";
        TTCN3Template template = parameter.getTemplateBody();
        if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype()) && ((SpecificValue_Template)template).isReference()) {
            boolean assignmentTypeIsCorrect;
            Reference reference = ((SpecificValue_Template)template).getReference();
            reference.setUsedOnLeftHandSide();
            Assignment assignment = reference.getRefdAssignment(timestamp, true);
            if (assignment == null) {
                Value_ActualParameter temp = new Value_ActualParameter(null);
                temp.setIsErroneous();
                return temp;
            }
            switch (assignment.getAssignmentType()) {
                case A_PAR_VAL_IN: {
                    ((FormalParameter)assignment).useAsLValue(reference);
                    assignmentTypeIsCorrect = !isTemplate;
                    break;
                }
                case A_PAR_VAL: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    assignmentTypeIsCorrect = !isTemplate;
                    break;
                }
                case A_VAR: {
                    ((Def_Var)assignment).setWritten();
                    assignmentTypeIsCorrect = !isTemplate;
                    break;
                }
                case A_PAR_TEMP_IN: {
                    assignmentTypeIsCorrect = isTemplate;
                    ((FormalParameter)assignment).useAsLValue(reference);
                    break;
                }
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    assignmentTypeIsCorrect = isTemplate;
                    break;
                }
                case A_VAR_TEMPLATE: {
                    ((Def_Var_Template)assignment).setWritten();
                    assignmentTypeIsCorrect = isTemplate;
                    break;
                }
                default: {
                    assignmentTypeIsCorrect = false;
                }
            }
            if (assignmentTypeIsCorrect) {
                IType fieldType = assignment.getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                if (fieldType != null && this.type != null) {
                    TypeCompatibilityInfo info = new TypeCompatibilityInfo(this.type, fieldType, true);
                    if (!this.type.isCompatible(timestamp, fieldType, info, null, null)) {
                        if (info.getSubtypeError() == null) {
                            if (info.getErrorStr() == null) {
                                reference.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH2, expectedString, this.type.getTypename(), fieldType.getTypename()));
                            } else {
                                this.getLocation().reportSemanticError(info.getErrorStr());
                            }
                        } else {
                            this.getLocation().reportSemanticError(info.getSubtypeError());
                        }
                    } else if (this.type.getSubtype() != null && fieldType.getSubtype() != null && !this.type.getSubtype().isCompatible(timestamp, fieldType.getSubtype())) {
                        reference.getLocation().reportSemanticError(MessageFormat.format(SUBTYPEMISMATCH, this.type.getSubtype().toString(), fieldType.getSubtype().toString()));
                    }
                    if (!reference.getSubreferences().isEmpty() && reference.refersToStringElement()) {
                        reference.getLocation().reportSemanticError(MessageFormat.format(REFERENCEEXPECTED3, fieldType.getTypename()));
                    }
                }
            } else {
                reference.getLocation().reportSemanticError(MessageFormat.format(REFERENCEEXPECTED1, expectedString, this.getAssignmentName(), assignment.getDescription()));
            }
            Referenced_ActualParameter returnActualParameter = new Referenced_ActualParameter(reference);
            if (isTemplate && assignmentTypeIsCorrect) {
                TemplateRestriction.Restriction_type refdRestriction;
                switch (assignment.getAssignmentType()) {
                    case A_VAR_TEMPLATE: {
                        Def_Var_Template temp = (Def_Var_Template)assignment;
                        refdRestriction = temp.getTemplateRestriction();
                        break;
                    }
                    case A_PAR_TEMP_IN: 
                    case A_PAR_TEMP_OUT: 
                    case A_PAR_TEMP_INOUT: {
                        FormalParameter par = (FormalParameter)assignment;
                        refdRestriction = par.getTemplateRestriction();
                        break;
                    }
                    default: {
                        return returnActualParameter;
                    }
                }
                TemplateRestriction.getSubRestriction(refdRestriction, timestamp, reference);
                if (this.templateRestriction != refdRestriction) {
                    boolean preCallCheck = TemplateRestriction.isLessRestrictive(this.templateRestriction, refdRestriction);
                    boolean postCallCheck = TemplateRestriction.isLessRestrictive(refdRestriction, this.templateRestriction);
                    if (preCallCheck || postCallCheck) {
                        String message = MessageFormat.format("Inadequate restriction on the referenced {0} `{1}'' this may cause a dynamic test case error at runtime", assignment.getAssignmentName(), reference.getDisplayName());
                        reference.getLocation().reportSemanticWarning(message);
                    }
                }
                if (!TemplateRestriction.Restriction_type.TR_NONE.equals((Object)refdRestriction)) {
                    switch (this.myParameterList.getMyDefinition().getAssignmentType()) {
                        case A_EXT_FUNCTION: 
                        case A_EXT_FUNCTION_RVAL: 
                        case A_EXT_FUNCTION_RTEMP: {
                            break;
                        }
                    }
                }
            }
            return returnActualParameter;
        }
        parameter.getLocation().reportSemanticError(MessageFormat.format(REFERENCEEXPECTED2, expectedString, this.getAssignmentName()));
        Value_ActualParameter temp = new Value_ActualParameter(null);
        temp.setIsErroneous();
        return temp;
    }

    public StringBuilder getAsProposalDesriptionPart(StringBuilder builder) {
        switch (this.realAssignmentType) {
            case A_PAR_VAL_IN: 
            case A_PAR_TEMP_IN: {
                builder.append("in ");
                break;
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_TEMP_OUT: {
                builder.append("out ");
                break;
            }
            case A_PAR_VAL_INOUT: 
            case A_PAR_TEMP_INOUT: {
                builder.append("inout ");
                break;
            }
            case A_PAR_TIMER: {
                builder.append("timer");
                break;
            }
        }
        return builder.append(this.identifier.getDisplayName());
    }

    public StringBuilder getAsProposalPart(StringBuilder builder) {
        return builder.append("${").append(this.identifier.getDisplayName()).append('}');
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.defaultValue == null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            result.add(252);
            return result;
        }
        return ReparseUtilities.getAllValidTokenTypes();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.defaultValue != null) {
            this.defaultValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.defaultValue.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.defaultValue != null) {
            this.defaultValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.defaultValue == null || this.defaultValue.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
        aData.getSrc().append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        source.append("final ");
        switch (this.realAssignmentType) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    source.append(this.type.getGenNameValue(aData, source));
                    break;
                }
                aData.addBuiltinTypeImport("Lazy_Fuzzy_ValueExpr");
                source.append(MessageFormat.format("Lazy_Fuzzy_ValueExpr<{0}>", this.type.getGenNameValue(aData, aData.getSrc())));
                break;
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_PAR_PORT: {
                source.append(this.type.getGenNameValue(aData, source));
                break;
            }
            case A_PAR_TEMP_IN: {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    source.append(this.type.getGenNameTemplate(aData, source));
                    break;
                }
                aData.addBuiltinTypeImport("Lazy_Fuzzy_TemplateExpr");
                source.append(MessageFormat.format("Lazy_Fuzzy_TemplateExpr<{0}>", this.type.getGenNameTemplate(aData, aData.getSrc())));
                break;
            }
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                source.append(this.type.getGenNameTemplate(aData, source));
                break;
            }
            case A_PAR_TIMER: {
                aData.addBuiltinTypeImport("TitanTimer");
                source.append("TitanTimer");
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            }
        }
        source.append(' ');
        source.append(this.identifier.getName());
    }

    public void generateCodeObject(JavaGenData aData, StringBuilder source, String prefix, boolean referenced, boolean generateInitialized) {
        switch (this.realAssignmentType) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    source.append(MessageFormat.format("final {0} {1}{2} = new {0}();\n", this.type.getGenNameValue(aData, source), prefix, this.getIdentifier().getName()));
                    break;
                }
                aData.addBuiltinTypeImport("Lazy_Fuzzy_ValueExpr");
                if (generateInitialized) {
                    source.append(MessageFormat.format("final Lazy_Fuzzy_ValueExpr<{0}> {1}{2} = new Lazy_Fuzzy_ValueExpr<{0}>({3});\n", this.type.getGenNameValue(aData, aData.getSrc()), prefix, this.getIdentifier().getName(), this.evaluationType == parameterEvaluationType.LAZY_EVAL ? "false" : "true"));
                    break;
                }
                source.append(MessageFormat.format("final Lazy_Fuzzy_ValueExpr<{0}> {1}{2};\n", this.type.getGenNameValue(aData, aData.getSrc()), prefix, this.getIdentifier().getName()));
                break;
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_PAR_PORT: {
                if (referenced) {
                    source.append(MessageFormat.format("final {0} {1}{2};\n", this.type.getGenNameValue(aData, source), prefix, this.getIdentifier().getName()));
                    break;
                }
                source.append(MessageFormat.format("final {0} {1}{2} = new {0}();\n", this.type.getGenNameValue(aData, source), prefix, this.getIdentifier().getName()));
                break;
            }
            case A_PAR_TEMP_IN: {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    source.append(MessageFormat.format("final {0} {1}{2} = new {0}();\n", this.type.getGenNameTemplate(aData, source), prefix, this.getIdentifier().getName()));
                    break;
                }
                aData.addBuiltinTypeImport("Lazy_Fuzzy_TemplateExpr");
                if (generateInitialized) {
                    source.append(MessageFormat.format("final Lazy_Fuzzy_TemplateExpr<{0}> {1}{2} = new Lazy_Fuzzy_TemplateExpr<{0}>({3});\n", this.type.getGenNameTemplate(aData, source), prefix, this.getIdentifier().getName(), this.evaluationType == parameterEvaluationType.LAZY_EVAL ? "false" : "true"));
                    break;
                }
                source.append(MessageFormat.format("final Lazy_Fuzzy_TemplateExpr<{0}> {1}{2};\n", this.type.getGenNameTemplate(aData, source), prefix, this.getIdentifier().getName()));
                break;
            }
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                if (referenced) {
                    source.append(MessageFormat.format("final {0} {1}{2};\n", this.type.getGenNameTemplate(aData, source), prefix, this.getIdentifier().getName()));
                    break;
                }
                source.append(MessageFormat.format("final {0} {1}{2} = new {0}();\n", this.type.getGenNameTemplate(aData, source), prefix, this.getIdentifier().getName()));
                break;
            }
            case A_PAR_TIMER: {
                aData.addBuiltinTypeImport("TitanTimer");
                source.append(MessageFormat.format("TitanTimer {0}{1} = new TitanTimer(\"{1}\");\n", prefix, this.identifier.getName()));
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            }
        }
    }

    public void generateCodeShadowObject(JavaGenData aData, StringBuilder source) {
        if (this.usedAsLValue) {
            switch (this.assignmentType) {
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: {
                    source.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", this.type.getGenNameValue(aData, source), this.getGenName(), this.identifier.getName()));
                    break;
                }
                case A_PAR_TEMP_IN: {
                    source.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", this.type.getGenNameTemplate(aData, source), this.getGenName(), this.identifier.getName()));
                    break;
                }
            }
        }
    }

    public void generateCodeSetUnbound(JavaGenData aData, StringBuilder source) {
        switch (this.assignmentType) {
            case A_PAR_VAL_OUT: 
            case A_PAR_TEMP_OUT: {
                source.append(MessageFormat.format("{0}.clean_up();\n", this.identifier.getName()));
                break;
            }
        }
    }

    public void generateCodeDefaultValue(JavaGenData aData, StringBuilder source) {
        if (this.actualDefaultParameter == null) {
            return;
        }
        this.actualDefaultParameter.generateCodeDefaultValue(aData, source);
    }

    public StringBuilder generateCodeFpar(JavaGenData aData) {
        StringBuilder result = new StringBuilder();
        switch (this.assignmentType) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    result.append(MessageFormat.format("final {0} {1}", this.type.getGenNameValue(aData, aData.getSrc()), this.identifier.getName()));
                    break;
                }
                aData.addBuiltinTypeImport("Lazy_Fuzzy_ValueExpr");
                result.append(MessageFormat.format("final Lazy_Fuzzy_ValueExpr<{0}> {1}", this.type.getGenNameValue(aData, aData.getSrc()), this.identifier.getName()));
                break;
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: 
            case A_PAR_PORT: {
                result.append(MessageFormat.format("final {0} {1}", this.type.getGenNameValue(aData, aData.getSrc()), this.identifier.getName()));
                break;
            }
            case A_PAR_TEMP_IN: {
                if (this.evaluationType == parameterEvaluationType.NORMAL_EVAL) {
                    result.append(MessageFormat.format("final {0} {1}", this.type.getGenNameTemplate(aData, aData.getSrc()), this.identifier.getName()));
                    break;
                }
                aData.addBuiltinTypeImport("Lazy_Fuzzy_TemplateExpr");
                result.append(MessageFormat.format("final Lazy_Fuzzy_TemplateExpr<{0}> {1}", this.type.getGenNameTemplate(aData, aData.getSrc()), this.identifier.getName()));
                break;
            }
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                result.append(MessageFormat.format("final {0} {1}", this.type.getGenNameTemplate(aData, aData.getSrc()), this.identifier.getName()));
                break;
            }
            case A_PAR_TIMER: {
                aData.addBuiltinTypeImport("TitanTimer");
                result.append(MessageFormat.format("final TitanTimer {0}", this.identifier.getName()));
                break;
            }
        }
        return result;
    }

    public String getGeneratedReferenceName() {
        StringBuilder builder = new StringBuilder(this.getIdentifier().getName());
        if (this.evaluationType != parameterEvaluationType.NORMAL_EVAL) {
            builder.append(".evaluate()");
        }
        return builder.toString();
    }

    public String getFormalParamType() {
        switch (this.getAssignmentType()) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_TEMP_IN: {
                return "in";
            }
            case A_PAR_VAL_INOUT: 
            case A_PAR_TEMP_INOUT: {
                return "inout";
            }
            case A_PAR_VAL_OUT: 
            case A_PAR_TEMP_OUT: {
                return "out";
            }
        }
        return "";
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        Map<String, String> params;
        String paramDesc;
        super.getHoverContent(editor);
        Type assType = this.getType(this.getLastTimeChecked());
        this.hoverContent.addText(KIND).addText(" ");
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.identifier.getDisplayName(), 1);
        if (this.hasDocumentComment() && (paramDesc = (params = this.getDocumentComment().getParams()).get(this.identifier.getDisplayName())) != null) {
            this.hoverContent.addText("<br><br>");
            this.hoverContent.addText(paramDesc);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    public static enum parameterEvaluationType {
        NORMAL_EVAL,
        LAZY_EVAL,
        FUZZY_EVAL;

    }
}

