/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import org.eclipse.iot.tiaki.domain.DiscoveryRecord;
import org.eclipse.iot.tiaki.utils.RDataUtil;
import org.xbill.DNS.PTRRecord;

public class PointerRecord
extends DiscoveryRecord {
    public static final PointerRecord build(PTRRecord ptrRecord) {
        return new PointerRecord(ptrRecord);
    }

    public String getDnsLabel() {
        return RDataUtil.getDnsLabelFromRData(this.rData);
    }

    @Override
    public String getServiceType() {
        return this.rData.contains(".") ? this.rData.substring(1, this.rData.indexOf(".")) : null;
    }

    @Override
    public String getServiceZone(String dnsLabel) {
        return this.rData.contains(dnsLabel) ? this.rData.substring(dnsLabel.length() + 1) : null;
    }

    @Override
    public String getServiceName(String dnsLabel) {
        return this.rData.contains(dnsLabel) ? this.rData : null;
    }

    private PointerRecord(PTRRecord ptrRecord) {
        super(ptrRecord.getName().toString(), ptrRecord.rdataToString(), ptrRecord.getTTL());
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String toDisplay() {
        return String.format("%d PTR %s", this.ttl, this.rData);
    }
}

