/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.commons;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.iot.tiaki.domain.DiscoveryRecord;
import org.eclipse.iot.tiaki.utils.FormattingUtil;
import org.xbill.DNS.Record;

public class StatusChangeEvent
implements Serializable {
    private static final long serialVersionUID = -5316142743420677708L;
    private final String HEADER_FORMAT = " %-64s %-6s  %-64s\n";
    private final String BODY_FORMAT = "%-64s %-6s %-64s\n";
    private final String ROW_FORMAT = "%-3s %-128s\n";
    private final String ROW_FORMAT_NO_TYPE = "%-128s\n";
    private final String ROW_FORMAT_SIMPLE = "%s %s\n";
    private final String ROW_FORMAT_NO_TYPE_SIMPLE = "%s\n";
    private final String query;
    private final String type;
    private final List<String> results;

    public static StatusChangeEvent build(String query, String type, List<String> results) {
        return new StatusChangeEvent(query, type, results);
    }

    public static List<String> castedList(Collection<? extends Object> src) {
        LinkedList<String> dst = new LinkedList<String>();
        for (Object object : src) {
            if (object instanceof DiscoveryRecord) {
                dst.add(((DiscoveryRecord)object).toDisplay());
                continue;
            }
            dst.add(object.toString());
        }
        return dst;
    }

    public static List<String> castedArray(Object[] src) {
        LinkedList<String> dst = new LinkedList<String>();
        for (Object obj : src) {
            if (obj instanceof Record) {
                dst.add(((Record)obj).rdataToString());
                continue;
            }
            dst.add(obj.toString());
        }
        return dst;
    }

    public static List<String> castedValue(Object src) {
        LinkedList<String> dst = new LinkedList<String>();
        if (src instanceof DiscoveryRecord) {
            dst.add(((DiscoveryRecord)src).toDisplay());
        } else {
            dst.add(src.toString());
        }
        return dst;
    }

    public String columnFormatted() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(" %-64s %-6s  %-64s\n", "Query", "Type", "Result(s)"));
        for (int i = 0; i < this.results.size(); ++i) {
            if (i > 0) {
                builder.append(String.format("%-64s %-6s %-64s\n", "", this.type, this.results.get(i)));
                continue;
            }
            builder.append(String.format("%-64s %-6s %-64s\n", this.query, this.type, this.results.get(i)));
        }
        return builder.toString();
    }

    public String rowFormatted() {
        StringBuilder builder = new StringBuilder();
        if (this.results.size() > 0) {
            for (String result : this.results) {
                builder.append(this.type.isEmpty() ? String.format("%s\n", result) : String.format("%s %s\n", this.type, result));
            }
        } else {
            builder.append(String.format("No Record for [%s]\n", this.query));
        }
        return FormattingUtil.response(builder.toString());
    }

    public String getQuery() {
        return this.query;
    }

    public List<String> getResults() {
        return this.results;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.query);
        hash = 83 * hash + Objects.hashCode(this.results);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusChangeEvent other = (StatusChangeEvent)obj;
        if (!Objects.equals(this.query, other.query)) {
            return false;
        }
        return Objects.equals(this.results, other.results);
    }

    public String toString() {
        return this.rowFormatted();
    }

    private StatusChangeEvent(String query, String type, List<String> results) {
        this.query = query;
        this.type = type;
        this.results = results;
    }
}

