/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoriteListCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.mpc.core.model.IFavoriteList;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class FavoritesDiscoveryStrategy
extends MarketplaceDiscoveryStrategy {
    private String favoritesReference;

    public FavoritesDiscoveryStrategy(CatalogDescriptor catalogDescriptor) {
        super(catalogDescriptor);
    }

    public FavoritesDiscoveryStrategy(MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy) {
        super(marketplaceDiscoveryStrategy.catalogDescriptor);
    }

    public void setFavoritesReference(String favoritesReference) {
        this.favoritesReference = favoritesReference;
    }

    public String getFavoritesReference() {
        return this.favoritesReference;
    }

    @Override
    public void maybeAddCatalogItem(MarketplaceCategory catalogCategory) {
    }

    @Override
    protected Map<String, IInstallableUnit> computeInstalledIUs(IProgressMonitor monitor) {
        return Collections.emptyMap();
    }

    @Override
    protected void handleDiscoveryCategory(MarketplaceCategory catalogCategory) {
        catalogCategory.setContents(MarketplaceCategory.Contents.USER_FAVORITES);
    }

    @Override
    protected ISearchResult doPerformDiscovery(IProgressMonitor monitor) throws CoreException {
        this.preDiscovery();
        if (this.favoritesReference == null) {
            return null;
        }
        try {
            URI uri = URLUtil.toURI((String)this.favoritesReference);
            ISearchResult iSearchResult = this.marketplaceService.userFavorites(uri, monitor);
            return iSearchResult;
        }
        catch (CoreException ex) {
            this.handleDiscoveryError(ex);
            return null;
        }
        catch (URISyntaxException e) {
            Status error = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.FavoritesDiscoveryStrategy_invalidUrl, (Object)this.favoritesReference, (Object)e), (Throwable)e);
            this.handleDiscoveryError(new CoreException((IStatus)error));
            return null;
        }
        finally {
            this.postDiscovery();
        }
    }

    protected void postDiscovery() {
    }

    protected void preDiscovery() {
    }

    protected void handleDiscoveryError(CoreException ex) throws CoreException {
        throw ex;
    }

    @Override
    protected void handleSearchResult(MarketplaceCategory catalogCategory, ISearchResult result, IProgressMonitor monitor) {
        if (result == null) {
            this.addInstructionInfoItem(catalogCategory);
            this.addFavoriteListEntries(catalogCategory, monitor);
        } else if (result.getNodes().isEmpty()) {
            this.addEmptyInfoItem(catalogCategory);
            this.addFavoriteListEntries(catalogCategory, monitor);
        } else {
            super.handleSearchResult(catalogCategory, result, monitor);
            for (CatalogItem catalogItem : this.items) {
                if (!(catalogItem instanceof MarketplaceNodeCatalogItem)) continue;
                catalogItem.setSelected(true);
            }
        }
    }

    private void addFavoriteListEntries(MarketplaceCategory catalogCategory, IProgressMonitor monitor) {
        try {
            List userFavoriteLists = this.marketplaceService.userFavoriteLists(monitor);
            this.addFavoriteListEntries(catalogCategory, userFavoriteLists);
        }
        catch (CoreException ex) {
            try {
                this.handleDiscoveryError(ex);
            }
            catch (CoreException ex1) {
                MarketplaceClientUi.error(ex1);
            }
        }
    }

    private void addFavoriteListEntries(MarketplaceCategory catalogCategory, List<IFavoriteList> userFavoriteLists) {
        if (userFavoriteLists == null || userFavoriteLists.isEmpty()) {
            return;
        }
        catalogCategory.setContents(MarketplaceCategory.Contents.FAVORITE_LISTS);
        catalogCategory.setName(Messages.FavoritesDiscoveryStrategy_favoritesCategoryTitle);
        MarketplaceCatalogSource source = this.getCatalogSource();
        int maxCount = Math.min(userFavoriteLists.size(), 5);
        int i = 0;
        while (i < maxCount) {
            IFavoriteList favoriteList = userFavoriteLists.get(i);
            FavoriteListCatalogItem item = new FavoriteListCatalogItem();
            item.setFavoriteList(favoriteList);
            item.setId(favoriteList.getId());
            item.setName(favoriteList.getName());
            item.setProvider(favoriteList.getOwner());
            String iconUrl = favoriteList.getIcon();
            if (iconUrl != null) {
                if (!source.getResourceProvider().containsResource(iconUrl)) {
                    FavoritesDiscoveryStrategy.cacheResource(source.getResourceProvider(), item, iconUrl);
                }
                FavoritesDiscoveryStrategy.createIcon(item, favoriteList);
            }
            this.addItem(catalogCategory, item);
            ++i;
        }
    }

    private static void createIcon(CatalogItem catalogItem, IFavoriteList list) {
        Icon icon = new Icon();
        icon.setImage32(list.getIcon());
        icon.setImage48(list.getIcon());
        icon.setImage64(list.getIcon());
        icon.setImage128(list.getIcon());
        catalogItem.setIcon(icon);
    }

    private void addEmptyInfoItem(CatalogCategory catalogCategory) {
        this.addInfoItem(catalogCategory, Messages.FavoritesDiscoveryStrategy_noFavoritesTitle, Messages.FavoritesDiscoveryStrategy_noFavoritesMessage);
    }

    private void addInstructionInfoItem(CatalogCategory catalogCategory) {
        this.addInfoItem(catalogCategory, Messages.FavoritesDiscoveryStrategy_enterFavoritesUrlTitle, Messages.FavoritesDiscoveryStrategy_enterFavoritesUrlMessage);
    }

    private void addInfoItem(CatalogCategory catalogCategory, String title, String description) {
        MarketplaceCatalogSource source = this.getCatalogSource();
        String id = this.catalogDescriptor.getUrl().toString() + "#info:" + title;
        ListIterator i = this.items.listIterator(this.items.size());
        while (i.hasPrevious()) {
            UserActionCatalogItem actionItem;
            CatalogItem item = (CatalogItem)i.previous();
            if (item.getSource() != source || item.getCategory() != catalogCategory && !catalogCategory.getId().equals(item.getCategoryId()) || !(item instanceof UserActionCatalogItem) || (actionItem = (UserActionCatalogItem)item).getUserAction() != UserActionCatalogItem.UserAction.INFO || !id.equals(actionItem.getId())) continue;
            return;
        }
        UserActionCatalogItem infoItem = new UserActionCatalogItem();
        infoItem.setUserAction(UserActionCatalogItem.UserAction.INFO);
        infoItem.setDescription(description);
        infoItem.setName(title);
        infoItem.setId(id);
        this.addItem(catalogCategory, infoItem);
    }

    private void addItem(CatalogCategory catalogCategory, CatalogItem item) {
        MarketplaceCatalogSource catalogSource = this.getCatalogSource();
        item.setSource((AbstractCatalogSource)catalogSource);
        item.setCategoryId(catalogCategory.getId());
        this.items.add(item);
    }
}

