/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.components;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class WorkingSetGroup {
    static final List<String> WORKING_SET_IDS = Arrays.asList("org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage");
    ComboViewer workingsetComboViewer;
    Button addToWorkingSetButton;
    final List<IWorkingSet> workingSets;
    final Shell shell;

    public WorkingSetGroup(Composite container, List<IWorkingSet> workingSets, Shell shell) {
        this.workingSets = workingSets;
        this.shell = shell;
        this.createControl(container);
    }

    private void createControl(Composite container) {
        this.addToWorkingSetButton = new Button(container, 32);
        GridData gd_addToWorkingSetButton = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_addToWorkingSetButton.verticalIndent = 12;
        this.addToWorkingSetButton.setLayoutData((Object)gd_addToWorkingSetButton);
        this.addToWorkingSetButton.setSelection(true);
        this.addToWorkingSetButton.setData("name", (Object)"addToWorkingSetButton");
        this.addToWorkingSetButton.setText(Messages.WorkingSetGroup_btnAddSet);
        this.addToWorkingSetButton.setSelection(false);
        Label workingsetLabel = new Label(container, 0);
        GridData gd_workingsetLabel = new GridData();
        gd_workingsetLabel.horizontalIndent = 10;
        workingsetLabel.setLayoutData((Object)gd_workingsetLabel);
        workingsetLabel.setEnabled(false);
        workingsetLabel.setData("name", (Object)"workingsetLabel");
        workingsetLabel.setText(Messages.WorkingSetGroup_lblSet);
        Combo workingsetCombo = new Combo(container, 8);
        workingsetCombo.setEnabled(false);
        workingsetCombo.setData("name", (Object)"workingsetCombo");
        workingsetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.workingsetComboViewer = new ComboViewer(workingsetCombo);
        this.workingsetComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            /*
             * WARNING - void declaration
             */
            public Object[] getElements(Object input) {
                Object object = input;
                if (object instanceof IWorkingSet[]) {
                    void workingSets;
                    IWorkingSet[] iWorkingSetArray = (IWorkingSet[])object;
                    IWorkingSet[] cfr_ignored_0 = (IWorkingSet[])object;
                    return workingSets;
                }
                if (input instanceof List) {
                    return new Object[]{input};
                }
                Object object2 = input;
                if (object2 instanceof Set) {
                    void set;
                    Set set2 = (Set)object2;
                    Set cfr_ignored_1 = (Set)object2;
                    return set.toArray();
                }
                return new IWorkingSet[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.workingsetComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final ResourceManager images = new LocalResourceManager(JFaceResources.getResources());

            /*
             * WARNING - void declaration
             */
            public Image getImage(Object element) {
                Object object = element;
                if (object instanceof IWorkingSet) {
                    void workingSet;
                    IWorkingSet iWorkingSet = (IWorkingSet)object;
                    IWorkingSet cfr_ignored_0 = (IWorkingSet)object;
                    ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
                    if (imageDescriptor != null) {
                        try {
                            return (Image)this.images.create((DeviceResourceDescriptor)imageDescriptor);
                        }
                        catch (DeviceResourceException ex) {
                            return null;
                        }
                    }
                }
                return super.getImage(element);
            }

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof IWorkingSet) {
                    void workingSet;
                    IWorkingSet iWorkingSet = (IWorkingSet)object;
                    IWorkingSet cfr_ignored_0 = (IWorkingSet)object;
                    return workingSet.getLabel();
                }
                Object object2 = element;
                if (object2 instanceof List) {
                    void list;
                    List list2 = (List)object2;
                    List cfr_ignored_1 = (List)object2;
                    StringBuilder sb = new StringBuilder();
                    for (Object o : list) {
                        void workingSet;
                        Object e = o;
                        if (!(e instanceof IWorkingSet)) continue;
                        IWorkingSet cfr_ignored_2 = (IWorkingSet)e;
                        IWorkingSet cfr_ignored_3 = (IWorkingSet)e;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(workingSet.getLabel());
                    }
                    return sb.toString();
                }
                return super.getText(element);
            }

            public void dispose() {
                this.images.dispose();
                super.dispose();
            }
        });
        this.workingsetComboViewer.setComparator(new ViewerComparator());
        Button newWorkingSetButton = new Button(container, 0);
        newWorkingSetButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        newWorkingSetButton.setData("name", (Object)"configureButton");
        newWorkingSetButton.setText(Messages.WorkingSetGroup_btnMore);
        newWorkingSetButton.setEnabled(false);
        newWorkingSetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(this.shell, true, WORKING_SET_IDS.toArray(new String[0]));
            if (dialog.open() == 0) {
                IWorkingSet[] workingSets = dialog.getSelection();
                this.selectWorkingSets(Arrays.asList(workingSets));
            }
        }));
        if (this.selectWorkingSets(this.workingSets)) {
            this.addToWorkingSetButton.setSelection(true);
            workingsetLabel.setEnabled(true);
            this.workingsetComboViewer.getCombo().setEnabled(true);
            newWorkingSetButton.setEnabled(true);
        }
        this.addToWorkingSetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean addToWorkingingSet = this.addToWorkingSetButton.getSelection();
            workingsetLabel.setEnabled(addToWorkingingSet);
            this.workingsetComboViewer.getCombo().setEnabled(addToWorkingingSet);
            newWorkingSetButton.setEnabled(addToWorkingingSet);
            if (addToWorkingingSet) {
                this.updateConfiguration();
            } else {
                this.workingSets.clear();
            }
        }));
        this.workingsetComboViewer.addSelectionChangedListener(event -> this.updateConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    protected void updateConfiguration() {
        IStructuredSelection selection;
        Object o;
        if (this.addToWorkingSetButton.getSelection() && (o = (selection = (IStructuredSelection)this.workingsetComboViewer.getSelection()).getFirstElement()) != null) {
            this.workingSets.clear();
            Object object = o;
            if (object instanceof IWorkingSet) {
                void workingSet;
                IWorkingSet iWorkingSet = (IWorkingSet)object;
                IWorkingSet cfr_ignored_0 = (IWorkingSet)object;
                this.workingSets.add((IWorkingSet)workingSet);
            } else if (o instanceof List) {
                List l = (List)o;
                this.workingSets.addAll(l);
            }
        }
    }

    Set<IWorkingSet> getWorkingSets() {
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (!workingSet.isEmpty()) {
                IAdaptable[] elements = workingSet.getElements();
                IResource resource = (IResource)elements[0].getAdapter(IResource.class);
                if (resource != null) {
                    workingSets.add(workingSet);
                }
            } else if (WORKING_SET_IDS.contains(workingSet.getId())) {
                workingSets.add(workingSet);
            }
            ++n2;
        }
        return workingSets;
    }

    public void dispose() {
        this.workingsetComboViewer.getLabelProvider().dispose();
    }

    public boolean selectWorkingSets(List<IWorkingSet> workingSets) {
        Set<IWorkingSet> defaultSets = this.getWorkingSets();
        this.workingsetComboViewer.setInput(defaultSets);
        if (workingSets != null && workingSets.size() > 0) {
            if (workingSets.size() == 1) {
                IWorkingSet workingSet = workingSets.get(0);
                if (defaultSets.contains(workingSet)) {
                    this.workingsetComboViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet));
                }
            } else {
                this.workingsetComboViewer.add(workingSets);
                this.workingsetComboViewer.setSelection((ISelection)new StructuredSelection(workingSets));
            }
            return true;
        }
        return false;
    }
}

