/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.UseAllowedColorRecommendation;

public class ProhibitedBothColorsProblem
extends LowVisionProblem {
    private int foregroundColor = -1;
    private int backgroundColor = -1;

    public ProhibitedBothColorsProblem(PageComponent pageComponent, LowVisionType lowVisionType, double d) throws LowVisionProblemException {
        super(7, lowVisionType, Messages.ProhibitedBothColorsProblem_Both_of_the_foreground_and_background_colors_are_not_allowed_by_the_design_guideline__1, pageComponent, d);
        this.setRecommendations();
    }

    public ProhibitedBothColorsProblem(PageElement pageElement, LowVisionType lowVisionType, double d) throws LowVisionProblemException {
        super(7, lowVisionType, Messages.ProhibitedBothColorsProblem_Both_of_the_foreground_and_background_colors_are_not_allowed_by_the_design_guideline__1, pageElement, d);
        this.foregroundColor = pageElement.getForegroundColor();
        this.backgroundColor = pageElement.getBackgroundColor();
        this.setRecommendations();
    }

    protected void setRecommendations() throws LowVisionProblemException {
        this.numRecommendations = 1;
        this.recommendations = new LowVisionRecommendation[this.numRecommendations];
        this.recommendations[0] = new UseAllowedColorRecommendation(this);
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }
}

