/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.BufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseMessage;

public class HTTPResponseStreamMessage
extends HTTPResponseMessage {
    private IBufferRange fHTTPVersion = new BufferRange();
    private IBufferRange fStatusCode = new BufferRange();
    private IBufferRange fReasonPhrase = new BufferRange();

    public HTTPResponseStreamMessage(long l) {
        super(l);
    }

    public IBufferRange getHTTPVersion() {
        return this.fHTTPVersion;
    }

    public String getHTTPVersionAsString() {
        return this.getBuffer().getAsString(this.fHTTPVersion);
    }

    public byte[] getHTTPVersionAsBytes() {
        return this.getBuffer().getAsBytes(this.fHTTPVersion);
    }

    public IBufferRange getStatusCode() {
        return this.fStatusCode;
    }

    public String getStatusCodeAsString() {
        return this.getBuffer().getAsString(this.fStatusCode);
    }

    public byte[] getStatusCodeAsBytes() {
        return this.getBuffer().getAsBytes(this.fStatusCode);
    }

    public IBufferRange getReasonPhrase() {
        return this.fReasonPhrase;
    }

    public String getReasonPhraseAsString() {
        return this.getBuffer().getAsString(this.fReasonPhrase);
    }

    public byte[] getReasonPhraseAsBytes() {
        return this.getBuffer().getAsBytes(this.fReasonPhrase);
    }

    protected void writeFirstLine(OutputStream outputStream) throws IOException {
        HTTPMessageBuffer hTTPMessageBuffer = this.getBuffer();
        hTTPMessageBuffer.writeTo(outputStream, this.fHTTPVersion);
        outputStream.write(32);
        hTTPMessageBuffer.writeTo(outputStream, this.fStatusCode);
        outputStream.write(32);
        hTTPMessageBuffer.writeTo(outputStream, this.fReasonPhrase);
        outputStream.write(13);
        outputStream.write(10);
    }
}

