/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.util;

import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlErrorLogListener
implements IErrorLogListener {
    private boolean isNoDoctype = false;
    private boolean isNonPublic = false;
    private boolean isInvalidDoctype = false;
    private Vector<IProblemItem> problemV = new Vector();
    private String orgDoctype = "";
    private boolean flag = true;

    public void errorLog(int n, String string) {
        if (n != 4 || string.indexOf("eclipse-actf-id") < 0) {
            switch (n) {
                case 1: {
                    this.isNoDoctype = true;
                    break;
                }
                case 2: {
                    if (string.indexOf("Invalid DOCTYPE declaration.") > -1) {
                        this.isNonPublic = true;
                        break;
                    }
                    if (!string.matches(".*Instead of \".*\" use \".*\" as a DTD.")) break;
                    this.orgDoctype = string.substring(string.indexOf("\"") + 1);
                    this.orgDoctype = this.orgDoctype.substring(0, this.orgDoctype.indexOf("\""));
                    if (this.orgDoctype.matches("-//W3C//DTD XHTML ((1.0 (Strict|Transitional|Frameset))|1.1|Basic 1.0|Basic 1.1)//EN")) {
                        this.orgDoctype = "";
                        break;
                    }
                    this.isInvalidDoctype = true;
                    break;
                }
                case 7: {
                    if (string.matches(".*<head.*> must be before <body.*")) {
                        this.addHtmlProblem("C_1000.1", string);
                        break;
                    }
                    if (string.matches(".*<html.*> is not allowed as a child of <.*")) {
                        this.addHtmlProblem("C_1000.2", string);
                        break;
                    }
                    if (string.matches(".*<body.*> is not allowed as a child of <.*")) {
                        this.addHtmlProblem("C_1000.3", string);
                        break;
                    }
                    if (!string.matches(".*Order of <html.*>'s children is wrong.*")) break;
                    this.addHtmlProblem("C_1000.5", string);
                }
            }
        }
    }

    private void addHtmlProblem(String string, String string2) {
        ProblemItemImpl problemItemImpl = new ProblemItemImpl(string);
        int n = -1;
        String[] stringArray = string2.split(":");
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0].trim());
            }
            catch (Exception exception) {}
        }
        if (n > -1) {
            problemItemImpl.setLine(n);
        }
        this.problemV.add((IProblemItem)problemItemImpl);
    }

    public boolean isNoDoctypeDeclaration() {
        return this.isNoDoctype || this.isNonPublic || this.isInvalidDoctype;
    }

    public boolean isNonPublicDoctype() {
        return this.isNonPublic;
    }

    public boolean isInvalidDoctype() {
        return this.isInvalidDoctype;
    }

    public String getDeclaratedDoctype() {
        return this.orgDoctype;
    }

    public Vector<IProblemItem> getHtmlProblemVector() {
        if (this.flag) {
            if (EvaluationUtil.isOriginalDOM() && this.isNoDoctypeDeclaration()) {
                if (this.isInvalidDoctype() || this.isNonPublicDoctype()) {
                    this.problemV.add((IProblemItem)new ProblemItemImpl("C_1000.6"));
                } else {
                    this.problemV.add((IProblemItem)new ProblemItemImpl("C_1000.7"));
                }
            }
            this.flag = false;
        }
        return this.problemV;
    }
}

