/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.ease.internal;

import java.lang.reflect.Method;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.tea.core.internal.model.TaskingModel;

public final class EaseTaskWrapper {
    private final String name;
    private final Object task;
    private final boolean isTea;
    private final IScriptEngine scriptEngine;

    public EaseTaskWrapper(String name, Object o, IScriptEngine scriptEngine) {
        this.name = name;
        this.task = o;
        this.scriptEngine = scriptEngine;
        this.isTea = EaseTaskWrapper.isTeaTask(o);
    }

    private static boolean isTeaTask(Object o) {
        if (o instanceof Class) {
            return true;
        }
        Method[] methodArray = o.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Execute e = m.getAnnotation(Execute.class);
            if (e != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Execute
    public void runThisTask(IEclipseContext ctx) throws Exception {
        if (this.isTea) {
            Object inst = this.task;
            if (inst instanceof Class) {
                inst = ContextInjectionFactory.make((Class)((Class)inst), (IEclipseContext)ctx);
            }
            ContextInjectionFactory.invoke((Object)inst, Execute.class, (IEclipseContext)ctx);
            return;
        }
        this.scriptEngine.inject(this.task);
    }

    public String toString() {
        if (this.isTea) {
            return TaskingModel.getTaskName((Object)this.task);
        }
        return "Script: " + this.name;
    }
}

