/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stem.geography.names.GeographicNames;
import org.eclipse.stem.ui.widgets.ISOKeyPickedEvent;
import org.eclipse.stem.ui.widgets.ISOKeyPickedEventListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class ISOKeyPicker
extends Composite {
    private final List<ISOKeyPickedEventListener> listeners = new CopyOnWriteArrayList<ISOKeyPickedEventListener>();
    private final Label isoKeyLevelDescription;
    private final FilteredList filteredList;
    final Text text;
    private int isoKeyLevel;

    public ISOKeyPicker(Composite parent, int style, final int isoKeyLevel) {
        super(parent, style);
        this.isoKeyLevel = isoKeyLevel;
        this.setLayout((Layout)new FormLayout());
        this.text = new Text((Composite)this, 2048);
        FormData fd_text = new FormData();
        fd_text.top = new FormAttachment(0, 0);
        fd_text.left = new FormAttachment(25, 0);
        fd_text.right = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)fd_text);
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ISOKeyPicker.this.filteredList.setFilter(ISOKeyPicker.this.text.getText());
            }
        });
        this.isoKeyLevelDescription = new Label((Composite)this, 0);
        this.isoKeyLevelDescription.setText("Label");
        FormData fd_isoKeyLevelDescription = new FormData();
        fd_isoKeyLevelDescription.top = new FormAttachment((Control)this.text, 2, 128);
        fd_isoKeyLevelDescription.right = new FormAttachment(25, 0);
        fd_isoKeyLevelDescription.left = new FormAttachment(0, 0);
        this.isoKeyLevelDescription.setLayoutData((Object)fd_isoKeyLevelDescription);
        this.filteredList = new FilteredList((Composite)this, 2048, null, false, false, true);
        FormData fd_filteredList = new FormData();
        fd_filteredList.top = new FormAttachment((Control)this.text, 5, -1);
        fd_filteredList.bottom = new FormAttachment(100, 0);
        fd_filteredList.left = new FormAttachment((Control)this.text, 0, 16384);
        fd_filteredList.right = new FormAttachment((Control)this.text, 0, 131072);
        this.filteredList.setLayoutData((Object)fd_filteredList);
        this.filteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selected = ISOKeyPicker.this.filteredList.getSelection();
                if (selected.length == 1) {
                    String isoKey = (String)selected[0];
                    ISOKeyPicker.this.fireISOKeyPicked(isoKey);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.filteredList.setIgnoreCase(true);
        this.filteredList.setFilter("");
        this.filteredList.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ISOKeyPicker.this.getName((String)element, isoKeyLevel);
            }
        });
        this.filteredList.setElements(new Object[0]);
        this.pack();
    }

    public void setISOKeys(Object[] isoKeys) {
        this.filteredList.setElements(isoKeys);
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ISOKeyPicker.this.text.setText("");
            }
        });
    }

    public void setISOKeyLevelDescription(String isoKeyLevelDescription) {
        this.isoKeyLevelDescription.setText(isoKeyLevelDescription);
    }

    public int getISOKeyLevel() {
        return this.isoKeyLevel;
    }

    public void setISOKeyLevel(int isoKeyLevel) {
        this.isoKeyLevel = isoKeyLevel;
    }

    private String getName(String isoKey, int level) {
        return GeographicNames.getName((String)isoKey, (int)level);
    }

    public void addISOKeyPickedListener(ISOKeyPickedEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeISOKeyPickedListener(ISOKeyPickedEventListener listener) {
        this.listeners.remove(listener);
    }

    private void fireISOKeyPicked(String isoKey) {
        ISOKeyPickedEvent isoKeyPickedEvent = new ISOKeyPickedEvent((Object)this, isoKey);
        for (ISOKeyPickedEventListener listener : this.listeners) {
            listener.isoKeyPicked(isoKeyPickedEvent);
        }
    }

    public Point getRegionListSize() {
        return this.filteredList.getSize();
    }

    public Rectangle getRegionListBounds() {
        return this.filteredList.getBounds();
    }

    public void setRegionListSize(int width, int height) {
        this.filteredList.setSize(width, height);
    }

    public void setRegionListBounds(int x0, int y0, int width, int height) {
        this.filteredList.setBounds(x0, y0, width, height);
    }
}

