/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.SeasonalMigratoryPopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.Messages;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelImpl;

public class SeasonalMigratoryPopulationModelImpl
extends StandardPopulationModelImpl
implements SeasonalMigratoryPopulationModel {
    protected static final double PHASE_EDEFAULT = 0.0;
    protected double phase = 0.0;
    protected static final double PERIOD_EDEFAULT = 365.25;
    protected double period = 365.25;

    @Override
    protected void handleMigration(IntegrationLabel label, EList<Exchange> arrivals, EList<Exchange> departures, long timeDelta, IntegrationLabelValue idelta, double timeInCycles) {
        double modulation = Math.sin(Math.PI * 2 * (timeInCycles + this.getPhase()) / this.getPeriod());
        Node n = (Node)label.getIdentifiable();
        StandardPopulationModelLabelValue delta = (StandardPopulationModelLabelValue)idelta;
        EList edges = n.getEdges();
        int i = 0;
        while (i < edges.size()) {
            MigrationEdge me;
            Edge e = (Edge)edges.get(i);
            if (e instanceof MigrationEdge && (me = (MigrationEdge)e).getPopulationIdentifier().equals(this.getPopulationIdentifier())) {
                Node source = me.getA();
                Node dest = me.getB();
                double rate = modulation * me.getLabel().getCurrentValue().getMigrationRate();
                if (modulation < 0.0) {
                    source = me.getB();
                    dest = me.getA();
                    rate *= -1.0;
                }
                boolean leaving = source.equals(n);
                long timeperiod = me.getLabel().getCurrentValue().getTimePeriod();
                if (leaving) {
                    StandardPopulationModelLabelValue val = (StandardPopulationModelLabelValue)label.getTempValue();
                    double count = val.getCount();
                    double goodbye = me.isUseAbsoluteValues() ? rate * (double)timeDelta / (double)timeperiod : count * rate * (double)timeDelta / (double)timeperiod;
                    delta.setCount(delta.getCount() - goodbye);
                    Exchange migrationExchange = (Exchange)ExchangePool.POOL.get();
                    Label otherLabel = null;
                    EList destLabels = dest.getLabels();
                    int j = 0;
                    while (j < destLabels.size()) {
                        Label lab = (Label)destLabels.get(j);
                        if (lab instanceof StandardPopulationModelLabel && ((StandardPopulationModelLabel)lab).getPopulationIdentifier().equals(((PopulationModelLabel)label).getPopulationIdentifier())) {
                            otherLabel = lab;
                            break;
                        }
                        ++j;
                    }
                    if (otherLabel == null) {
                        Activator.logError(NLS.bind((String)Messages.EDGE_POP_MODEL_MISSING, (Object[])new Object[]{dest.getURI().toString(), ((PopulationModelLabel)label).getPopulationIdentifier()}), new Exception());
                        return;
                    }
                    migrationExchange.setType(ExchangeType.MIGRATION);
                    migrationExchange.getOtherLabels().add(otherLabel);
                    migrationExchange.setCount(goodbye);
                    delta.getDepartures().add((Object)migrationExchange);
                } else {
                    StandardPopulationModelLabelValue otherVal = null;
                    NodeLabel otherLabel = null;
                    EList sourceLabels = source.getLabels();
                    int j = 0;
                    while (j < sourceLabels.size()) {
                        NodeLabel lab = (NodeLabel)sourceLabels.get(j);
                        if (lab instanceof StandardPopulationModelLabel && ((PopulationModelLabel)lab).getPopulationIdentifier().equals(((PopulationModelLabel)label).getPopulationIdentifier())) {
                            otherVal = (StandardPopulationModelLabelValue)((StandardPopulationModelLabel)lab).getTempValue();
                            otherLabel = lab;
                            break;
                        }
                        ++j;
                    }
                    if (otherVal == null) {
                        Activator.logError(NLS.bind((String)Messages.EDGE_POP_MODEL_MISSING, (Object[])new Object[]{dest.getURI().toString(), ((PopulationModelLabel)label).getPopulationIdentifier()}), new Exception());
                        return;
                    }
                    double count = otherVal.getCount();
                    double welcome = me.isUseAbsoluteValues() ? rate * (double)timeDelta / (double)timeperiod : count * rate * (double)timeDelta / (double)timeperiod;
                    delta.setCount(delta.getCount() + welcome);
                    Exchange migrationExchange = (Exchange)ExchangePool.POOL.get();
                    migrationExchange.setType(ExchangeType.MIGRATION);
                    migrationExchange.getOtherLabels().add((Object)otherLabel);
                    migrationExchange.setCount(welcome);
                    delta.getArrivals().add((Object)migrationExchange);
                }
            }
            ++i;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SEASONAL_MIGRATORY_POPULATION_MODEL;
    }

    @Override
    public double getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(double newPhase) {
        this.phase = newPhase;
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getPhase();
            }
            case 19: {
                return this.getPeriod();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setPhase((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.setPhase(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.phase != 0.0;
            }
            case 19: {
                return this.period != 365.25;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (phase: ");
        result.append(this.phase);
        result.append(", period: ");
        result.append(this.period);
        result.append(')');
        return result.toString();
    }
}

