/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.impl;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.adapters.time.TimeProviderAdapterFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.loggers.LOGGER_EVENTS;
import org.eclipse.stem.loggers.imagewriter.Activator;
import org.eclipse.stem.loggers.imagewriter.ImagewriterPackage;
import org.eclipse.stem.loggers.imagewriter.MapViewImageWriterLogger;
import org.eclipse.stem.loggers.imagewriter.impl.ImageWriterLoggerImpl;
import org.eclipse.stem.loggers.imagewriter.impl.Messages;
import org.eclipse.stem.ui.views.graphmap.GraphMapControl;
import org.eclipse.stem.ui.views.graphmap.GraphMapView;
import org.eclipse.stem.ui.views.graphmap.GraphMapViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MapViewImageWriterLoggerImpl
extends ImageWriterLoggerImpl
implements MapViewImageWriterLogger {
    protected static final boolean OPEN_MAP_VIEW_EDEFAULT = true;
    protected boolean openMapView = true;
    private static final String MAP_VIEW_ID = "org.eclipse.stem.ui.views.graphmap";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
    private File logDirectory;
    private TimeProvider timeProvider;
    private ISimulation simulation;
    boolean beforeStart = false;

    @Override
    protected EClass eStaticClass() {
        return ImagewriterPackage.Literals.MAP_VIEW_IMAGE_WRITER_LOGGER;
    }

    @Override
    public boolean isOpenMapView() {
        return this.openMapView;
    }

    @Override
    public void setOpenMapView(boolean newOpenMapView) {
        boolean oldOpenMapView = this.openMapView;
        this.openMapView = newOpenMapView;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldOpenMapView, this.openMapView));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.isOpenMapView();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setOpenMapView((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setOpenMapView(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return !this.openMapView;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (openMapView: ");
        result.append(this.openMapView);
        result.append(')');
        return result.toString();
    }

    private GraphMapView getMapViewFromWorkbench() {
        IWorkbenchPage page;
        IViewPart view = null;
        GraphMapView retValue = null;
        if (PlatformUI.isWorkbenchRunning() && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IViewReference viewRef;
            view = page.findView(MAP_VIEW_ID);
            if (!(view != null && view instanceof GraphMapView || (viewRef = page.findViewReference(MAP_VIEW_ID)) == null)) {
                view = viewRef.getView(true);
            }
            if ((view == null || !(view instanceof GraphMapView)) && this.isOpenMapView()) {
                try {
                    if (this.isOpenMapView()) {
                        view = page.showView(MAP_VIEW_ID);
                    }
                }
                catch (PartInitException e) {
                    Activator.logError("Error opening the map view for the map image logger", e);
                }
            }
        }
        if (view != null && view instanceof GraphMapView) {
            retValue = (GraphMapView)view;
        }
        return retValue;
    }

    private GraphMapControl getMapControlForSimulation() {
        GraphMapView view = this.getMapViewFromWorkbench();
        if (view != null && view.getSite().getSelectionProvider() instanceof GraphMapViewer) {
            Control[] controls;
            GraphMapViewer viewer = (GraphMapViewer)view.getSite().getSelectionProvider();
            Control[] controlArray = controls = ((Composite)viewer.getControl()).getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof GraphMapControl && this.simulation == ((GraphMapControl)control).getSimulation()) {
                    return (GraphMapControl)control;
                }
                ++n2;
            }
        }
        return null;
    }

    private STEMTime getScenarioTime() {
        STEMTime time = this.getTimeProvider().getTime();
        if (time == null) {
            time = this.simulation.getScenario().getSequencer().getStartTime();
        }
        if (!this.beforeStart) {
            time = time.addIncrement(this.simulation.getScenario().getSequencer().getTimeDelta());
        }
        return time;
    }

    private TimeProvider getTimeProvider() {
        if (this.timeProvider == null) {
            this.timeProvider = (TimeProvider)TimeProviderAdapterFactory.INSTANCE.adapt((Notifier)this.simulation.getScenario().getCanonicalGraph(), TimeProvider.class);
        }
        return this.timeProvider;
    }

    private File getImageFile() {
        if (this.logDirectory == null) {
            this.logDirectory = new File(this.getLogFileDirectory(this.simulation), "MapImages");
            this.logDirectory.mkdirs();
        }
        return new File(this.logDirectory, String.valueOf(DATE_FORMATTER.format(this.getScenarioTime().getTime())) + ".png");
    }

    private void saveSimulationImageFile(Image mapImage) {
        if (mapImage != null && !mapImage.isDisposed()) {
            try {
                File imageFile = this.getImageFile();
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{mapImage.getImageData()};
                loader.save(imageFile.getAbsolutePath(), 5);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void simulationEvent(SimulationEvent event) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (SimulationState.COMPLETED_CYCLE.equals((Object)event.getSimulationState())) {
            DisplaySafeExecutor.executeSync((Runnable)new Runnable(){

                @Override
                public void run() {
                    GraphMapControl control = MapViewImageWriterLoggerImpl.this.getMapControlForSimulation();
                    if (control != null) {
                        Image image = control.getMapCanvasImage();
                        MapViewImageWriterLoggerImpl.this.saveSimulationImageFile(image);
                    } else {
                        Activator.logWarning(Messages.MVIWL_NoCanvasError, null);
                    }
                }
            });
        }
    }

    public void loggerEvent(ISimulation simulation, LOGGER_EVENTS event) {
        if (LOGGER_EVENTS.LOGGER_STARTED.equals((Object)event)) {
            if (!PlatformUI.isWorkbenchRunning()) {
                Activator.logWarning(Messages.MVIWL_HeadlessError, null);
                return;
            }
            this.simulation = simulation;
        }
    }
}

