/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.stem.graphsynchronizer.Activator;

public class CountryGraphPartitionPlanner {
    static int NUM_COUNTRIES = -1;
    static int[][] commonBorderMatrix = null;
    static final String STATS_FILE = "worldPartioningStats.csv";
    static final String CODES_FILE = "countryCodeMap.csv";
    private static final String URI_PREFIX = "platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/";
    private static final URI CODES_FILE_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/countryCodeMap.csv");
    private static final URI STATS_FILE_URI = URI.createURI((String)"platform:/plugin/org.eclipse.stem.data.geography/resources/data/statistics/worldPartioningStats.csv");
    static Map<String, String> countryCode2to3 = new HashMap<String, String>();
    static Map<String, String> countryCode3to2 = new HashMap<String, String>();
    static final List<Country> worldCountryList = new ArrayList<Country>();
    static final Map<String, Country> worldCountryMap = new HashMap<String, Country>();

    public CountryGraphPartitionPlanner() {
        this.mapCodes();
        this.mapCountryStats();
    }

    public static void main(String[] args) {
        String[] test = new String[]{"AFG", "AGO", "AIA", "ALA", "ALB", "AND", "ANT", "ARE", "ARG", "ARM", "ASM", "ATA", "ATF", "ATG", "AUS", "AUT", "AZE", "BDI", "BEL", "BEN", "BFA", "BGD", "BGR", "BHR", "BHS", "BIH", "BLR", "BLZ", "BMU", "BOL", "BRA", "BRB", "BRN", "BTN", "BVT", "BWA", "CAF", "CAN", "CCK", "CHE", "CHL", "CHN", "CIV", "CMR", "COD", "COG", "COK", "COL", "COM", "CPV", "CRI", "CUB", "CXR", "CYM", "CYP", "CZE", "DEU", "DJI", "DMA", "DNK", "DOM", "DZA", "ECU", "EGY", "ERI", "ESH", "ESP", "EST", "ETH", "FIN", "FJI", "FLK", "FRA", "FRO", "FSM", "GAB", "GBR", "GEO", "GGY", "GHA", "GIB", "GIN", "GLP", "GMB", "GNB", "GNQ", "GRC", "GRD", "GRL", "GTM", "GUF", "GUM", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IMN", "IND", "IOT", "IRL", "IRN", "IRQ", "ISL", "ISR", "ITA", "JAM", "JEY", "JOR", "JPN", "KAZ", "KEN", "KGZ", "KHM", "KIR", "KNA", "KOR", "KWT", "LAO", "LBN", "LBR", "LBY", "LCA", "LIE", "LKA", "LSO", "LTU", "LUX", "LVA", "MAC", "MAR", "MCO", "MDA", "MDG", "MDV", "MEX", "MHL", "MKD", "MLI", "MLT", "MMR", "MNE", "MNG", "MNP", "MOZ", "MRT", "MSR", "MTQ", "MUS", "MWI", "MYS", "MYT", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NIU", "NLD", "NOR", "NPL", "NRU", "NZL", "OMN", "PAK", "PAN", "PCN", "PER", "PHL", "PLW", "PNG", "POL", "PRI", "PRK", "PRT", "PRY", "PSE", "PYF", "QAT", "REU", "ROU", "RUS", "RWA", "SAU", "SDN", "SEN", "SGP", "SGS", "SHN", "SJM", "SLB", "SLE", "SLV", "SMR", "SOM", "SPM", "SRB", "STP", "SUR", "SVK", "SVN", "SWE", "SWZ", "SYC", "SYR", "TCA", "TCD", "TGO", "THA", "TJK", "TKL", "TKM", "TLS", "TMP", "TON", "TTO", "TUN", "TUR", "TUV", "TWN", "TZA", "UGA", "UKR", "UMI", "URY", "USA", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "ZAF", "ZMB", "ZWE"};
        HashSet<String> testSet = new HashSet<String>();
        int i = 0;
        while (i < test.length) {
            testSet.add(test[i]);
            ++i;
        }
        CountryGraphPartitionPlanner cgpp = new CountryGraphPartitionPlanner();
        int numServers = 7;
        List<PartitionGroup> plan = cgpp.getPlan(numServers, testSet);
        List<Set<String>> planCodes = cgpp.planAsCodeStrings(plan);
        Activator.logInformation("planning complete.... assignments are:");
        int i2 = 0;
        while (i2 < plan.size()) {
            PartitionGroup pg = plan.get(i2);
            Set<String> countrySet = planCodes.get(i2);
            double surface = pg.countUnresolvedBorderEdges();
            double surfaceToVolume = surface / (double)pg.totalNodes;
            Activator.logInformation("server number: " + i2 + "  size is " + pg.totalNodes + " external Edges = " + (int)surface + " surfaceToVolumeRatio= " + surfaceToVolume);
            String s = "";
            for (String ctry : countrySet) {
                s = String.valueOf(s) + ctry + "  ";
            }
            Activator.logInformation("      " + s);
            ++i2;
        }
        int[][] pgMatrix = CountryGraphPartitionPlanner.getPartitionGroupBorderMatrix(plan);
        Activator.logInformation("");
        Activator.logInformation("");
        Activator.logInformation("PartitionGroup Matrix");
        Activator.logInformation("");
        int i3 = 0;
        while (i3 < plan.size()) {
            String s = "";
            int j = 0;
            while (j < plan.size()) {
                if (pgMatrix[i3][j] < 10) {
                    s = String.valueOf(s) + " ";
                }
                if (pgMatrix[i3][j] < 100) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + pgMatrix[i3][j] + "  ";
                ++j;
            }
            Activator.logInformation(s);
            ++i3;
        }
    }

    public List<PartitionGroup> getPlan(int numServers, Set<String> countries) {
        if (numServers > countries.size()) {
            numServers = countries.size();
            Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): Warning, number of servers can not exceed number of countries. Using " + numServers + " servers for now.");
        }
        ArrayList<PartitionGroup> partitionPlan = new ArrayList<PartitionGroup>();
        int i = 0;
        while (i < numServers) {
            PartitionGroup countryGroup = new PartitionGroup();
            partitionPlan.add(countryGroup);
            ++i;
        }
        HashSet<String> unassignedSet = new HashSet<String>();
        unassignedSet.addAll(countries);
        Country[] unassignedCountries = this.getSortedCountries(unassignedSet);
        int totalProblemSize = 0;
        int i2 = 0;
        while (i2 < unassignedCountries.length) {
            totalProblemSize += unassignedCountries[i2].numNodes;
            ++i2;
        }
        Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): APPROXIMATE total problem size = " + totalProblemSize);
        int targetGroupSize = totalProblemSize / numServers;
        Activator.logInformation("CountryGraphPatitionPlanner.getPlan(): APPROXIMATE target partition size = " + targetGroupSize);
        int i3 = 0;
        while (i3 < numServers) {
            PartitionGroup partitionGroup = (PartitionGroup)partitionPlan.get(i3);
            partitionGroup.add(unassignedCountries[i3]);
            Activator.logInformation(i3 + ": added " + unassignedCountries[i3].threeLetterCode);
            unassignedSet.remove(unassignedCountries[i3].threeLetterCode);
            ++i3;
        }
        int overAllMaxSurface = -1;
        int planToPick = -1;
        while (unassignedSet.size() > 0) {
            Country[] countriesToProcess = this.getSortedCountries(unassignedSet);
            overAllMaxSurface = -1;
            int i4 = 0;
            while (i4 < partitionPlan.size()) {
                int highestSurface;
                PartitionGroup pg = (PartitionGroup)partitionPlan.get(i4);
                pg.nextCandidateMember = null;
                if (pg.totalNodes < targetGroupSize && (highestSurface = pg.getLargestBorderForCountrySet(countriesToProcess)) >= overAllMaxSurface) {
                    overAllMaxSurface = highestSurface;
                    planToPick = i4;
                }
                ++i4;
            }
            if (overAllMaxSurface <= 0) {
                planToPick = this.getSmallestGroupIndex(partitionPlan);
                PartitionGroup pg = (PartitionGroup)partitionPlan.get(planToPick);
                pg.nextCandidateMember = countriesToProcess[0];
            }
            if (planToPick < 0) {
                Activator.logInformation("Houston we have a problem");
                System.exit(1);
            }
            if (planToPick >= 0) {
                PartitionGroup nextGroup = (PartitionGroup)partitionPlan.get(planToPick);
                Country selected = nextGroup.nextCandidateMember;
                if (selected == null) {
                    Activator.logInformation("Houston we have a problem");
                    System.exit(1);
                }
                nextGroup.add(selected);
                unassignedSet.remove(selected.threeLetterCode);
            }
            if (unassignedSet.size() == 0) break;
        }
        return partitionPlan;
    }

    public List<Set<String>> planAsCodeStrings(List<PartitionGroup> partitionPlan) {
        ArrayList<Set<String>> planList = new ArrayList<Set<String>>();
        int i = 0;
        while (i < partitionPlan.size()) {
            PartitionGroup pg = partitionPlan.get(i);
            planList.add(pg.getCountryCodes());
            ++i;
        }
        return planList;
    }

    public int getSmallestGroupIndex(List<PartitionGroup> partitionPlan) {
        int smallest = Integer.MAX_VALUE;
        int index = -1;
        int i = 0;
        while (i < partitionPlan.size()) {
            PartitionGroup pg = partitionPlan.get(i);
            if (pg.totalNodes < smallest) {
                smallest = pg.totalNodes;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public Country[] getSortedCountries(Set<String> countrySet) {
        Object[] sortedCountries = new Country[countrySet.size()];
        int icount = 0;
        for (String ctry : countrySet) {
            Country c = worldCountryMap.get(ctry);
            if (c == null) {
                System.err.println("Unable to find country " + ctry);
            }
            sortedCountries[icount] = c;
            ++icount;
        }
        Arrays.sort(sortedCountries);
        return sortedCountries;
    }

    private InputStream getInputStreamForURI(URI uri) throws IOException {
        return new ExtensibleURIConverterImpl().createInputStream(uri);
    }

    public void mapCodes() {
        block12: {
            BufferedReader d = null;
            try {
                try {
                    String record;
                    d = new BufferedReader(new InputStreamReader(this.getInputStreamForURI(CODES_FILE_URI)));
                    while ((record = d.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(record);
                        st.nextToken(",");
                        String twoLetter = st.nextToken(",");
                        String threeLetter = st.nextToken(",");
                        countryCode2to3.put(twoLetter, threeLetter);
                        countryCode3to2.put(threeLetter, twoLetter);
                    }
                }
                catch (IOException e) {
                    Activator.logInformation(" IOException error!" + e.getMessage());
                    try {
                        d.close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    d.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                d.close();
            }
            catch (Exception exception) {}
        }
    }

    public void mapCountryStats() {
        block15: {
            int countryCount = 0;
            BufferedReader d = null;
            try {
                try {
                    String record;
                    d = new BufferedReader(new InputStreamReader(this.getInputStreamForURI(STATS_FILE_URI)));
                    while ((record = d.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(record, ",");
                        String threeLetter = st.nextToken();
                        int numNodes = new Integer(st.nextToken().trim());
                        if (commonBorderMatrix == null) {
                            NUM_COUNTRIES = st.countTokens();
                            commonBorderMatrix = new int[NUM_COUNTRIES][NUM_COUNTRIES];
                        }
                        int i = 0;
                        while (i < NUM_COUNTRIES) {
                            int val;
                            CountryGraphPartitionPlanner.commonBorderMatrix[countryCount][i] = val = new Integer(st.nextToken().trim()).intValue();
                            ++i;
                        }
                        String twoLetter = countryCode3to2.get(threeLetter);
                        Country ctry = new Country(threeLetter, twoLetter, countryCount, numNodes);
                        worldCountryList.add(countryCount, ctry);
                        worldCountryMap.put(threeLetter, ctry);
                        ++countryCount;
                    }
                    Activator.logInformation("read matrix " + countryCount + " x " + NUM_COUNTRIES);
                    if (countryCount != NUM_COUNTRIES) {
                        Activator.logInformation("FAIL " + countryCount + " != " + NUM_COUNTRIES);
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    Activator.logInformation(" IOException error!" + e.getMessage());
                    try {
                        d.close();
                    }
                    catch (Exception exception) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    d.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                d.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int[][] getPartitionGroupBorderMatrix(List<PartitionGroup> masterList) {
        int numGroups = masterList.size();
        int[][] matrix = new int[numGroups][numGroups];
        int i = 0;
        while (i < numGroups) {
            PartitionGroup pgi = masterList.get(i);
            int j = 0;
            while (j < numGroups) {
                matrix[i][j] = 0;
                if (i != j) {
                    PartitionGroup pgj = masterList.get(j);
                    for (Country ctry : pgj.countryGroup) {
                        int[] nArray = matrix[i];
                        int n = j;
                        nArray[n] = nArray[n] + pgi.getCommonBorderArea(ctry);
                    }
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public class Country
    implements Comparable<Country> {
        String threeLetterCode;
        String twoLetterCode;
        int index;
        int numNodes;

        public Country(String threeLetterCode, String twoLetterCode, int index, int numNodes) {
            this.threeLetterCode = threeLetterCode;
            this.twoLetterCode = twoLetterCode;
            this.index = index;
            this.numNodes = numNodes;
        }

        @Override
        public int compareTo(Country other) {
            if (this.threeLetterCode.equalsIgnoreCase("PNG")) {
                return 1;
            }
            if (this.numNodes > other.numNodes) {
                return -1;
            }
            if (this.numNodes < other.numNodes) {
                return 1;
            }
            return 0;
        }
    }

    public class PartitionGroup {
        Set<Country> countryGroup = new HashSet<Country>();
        Country nextCandidateMember = null;
        int totalNodes = 0;

        Set<String> getCountryCodes() {
            HashSet<String> planSet = new HashSet<String>();
            for (Country ctry : this.countryGroup) {
                planSet.add(ctry.threeLetterCode);
            }
            return planSet;
        }

        public void add(Country country) {
            this.countryGroup.add(country);
            this.totalNodes += country.numNodes;
        }

        public int getCommonBorderArea(Country other) {
            int surfaceArea = 0;
            for (Country ctry : this.countryGroup) {
                surfaceArea += commonBorderMatrix[ctry.index][other.index];
            }
            return surfaceArea;
        }

        public int countUnresolvedBorderEdges() {
            int surfaceArea = 0;
            for (Country ctry : this.countryGroup) {
                int j = 0;
                while (j < NUM_COUNTRIES) {
                    Country target;
                    if (j != ctry.index && !this.countryGroup.contains(target = worldCountryList.get(j))) {
                        surfaceArea += commonBorderMatrix[j][ctry.index];
                    }
                    ++j;
                }
            }
            return surfaceArea;
        }

        public int getLargestBorderForCountrySet(Country[] countriesToProcess) {
            int maxArea = -1;
            int i = 0;
            while (i < countriesToProcess.length) {
                Country candidate = countriesToProcess[i];
                int surfaceArea = 0;
                for (Country ctry : this.countryGroup) {
                    surfaceArea += commonBorderMatrix[ctry.index][candidate.index];
                }
                if (surfaceArea > maxArea) {
                    maxArea = surfaceArea;
                    this.nextCandidateMember = candidate;
                }
                ++i;
            }
            return maxArea;
        }
    }
}

