/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.progress.UIJob;

public class DebugModelContextBindingManager
implements IDebugContextListener,
ILaunchesListener2,
IActivityManagerListener {
    private Map fModelToContextIds = new HashMap();
    private Map fLaunchToModelIds = new HashMap();
    private Map fLanuchToContextActivations = new HashMap();
    private List fModelPatternBindings = new ArrayList();
    private Map fModelToActivities = new HashMap();
    private Set fModelsEnabledForActivities = new HashSet();
    public static final String ID_DEBUG_MODEL_CONTEXT_BINDINGS = "debugModelContextBindings";
    public static final String ATTR_CONTEXT_ID = "contextId";
    public static final String ATTR_DEBUG_MODEL_ID = "debugModelId";
    public static final String DEBUG_CONTEXT = "org.eclipse.debug.ui.debugging";
    private static final String DEBUG_MODEL_ACTIVITY_SUFFIX = "/debugModel";
    private static DebugModelContextBindingManager fgManager;
    private static IContextService fgContextService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgContextService = (IContextService)iWorkbench.getAdapter((Class)clazz);
    }

    public static DebugModelContextBindingManager getDefault() {
        if (fgManager == null) {
            fgManager = new DebugModelContextBindingManager();
        }
        return fgManager;
    }

    private DebugModelContextBindingManager() {
        this.loadDebugModelContextBindings();
        this.loadDebugModelActivityExtensions();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugUITools.getDebugContextManager().addDebugContextListener(this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        activitySupport.getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDebugModelContextBindings() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_DEBUG_MODEL_CONTEXT_BINDINGS);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            String modelIdentifier = element.getAttribute(ATTR_DEBUG_MODEL_ID);
            String contextId = element.getAttribute(ATTR_CONTEXT_ID);
            DebugModelContextBindingManager debugModelContextBindingManager = this;
            synchronized (debugModelContextBindingManager) {
                if (modelIdentifier != null && contextId != null) {
                    ArrayList<String> contextIds = (ArrayList<String>)this.fModelToContextIds.get(modelIdentifier);
                    if (contextIds == null) {
                        contextIds = new ArrayList<String>();
                        this.fModelToContextIds.put(modelIdentifier, contextIds);
                    }
                    contextIds.add(contextId);
                }
            }
            ++i;
        }
    }

    private void loadDebugModelActivityExtensions() {
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        Set activityIds = activityManager.getDefinedActivityIds();
        Iterator activityIterator = activityIds.iterator();
        while (activityIterator.hasNext()) {
            String activityId = (String)activityIterator.next();
            IActivity activity = activityManager.getActivity(activityId);
            if (activity == null) continue;
            Set patternBindings = activity.getActivityPatternBindings();
            Iterator patternIterator = patternBindings.iterator();
            while (patternIterator.hasNext()) {
                IActivityPatternBinding patternBinding = (IActivityPatternBinding)patternIterator.next();
                String pattern = patternBinding.getPattern().pattern();
                if (!pattern.endsWith(DEBUG_MODEL_ACTIVITY_SUFFIX)) continue;
                this.fModelPatternBindings.add(patternBinding);
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection selection;
        if ((event.getFlags() & 1) > 0 && (selection = event.getContext()) instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            while (iterator.hasNext()) {
                this.activated(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activated(Object object) {
        String[] modelIds = this.getDebugModelIds(object);
        if (modelIds == null) {
            return;
        }
        ILaunch launch = DebugModelContextBindingManager.getLaunch(object);
        if (launch == null || launch.isTerminated()) {
            return;
        }
        ArrayList<String> toEnable = new ArrayList<String>(modelIds.length);
        DebugModelContextBindingManager debugModelContextBindingManager = this;
        synchronized (debugModelContextBindingManager) {
            HashSet<String> alreadyEnabled = (HashSet<String>)this.fLaunchToModelIds.get(launch);
            if (alreadyEnabled == null) {
                alreadyEnabled = new HashSet<String>();
                this.fLaunchToModelIds.put(launch, alreadyEnabled);
            }
            int i = 0;
            while (i < modelIds.length) {
                String id = modelIds[i];
                if (!alreadyEnabled.contains(id)) {
                    alreadyEnabled.add(id);
                    toEnable.add(id);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < toEnable.size()) {
            this.activateModel((String)toEnable.get(i), launch);
            ++i;
        }
        this.enableActivitiesFor(modelIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateModel(String modelId, ILaunch launch) {
        ArrayList<String> contextIds = null;
        DebugModelContextBindingManager debugModelContextBindingManager = this;
        synchronized (debugModelContextBindingManager) {
            contextIds = (ArrayList<String>)this.fModelToContextIds.get(modelId);
            if (contextIds == null) {
                contextIds = new ArrayList<String>();
                contextIds.add(DEBUG_CONTEXT);
                this.fModelToContextIds.put(modelId, contextIds);
            }
        }
        Iterator iterator = contextIds.iterator();
        while (iterator.hasNext()) {
            this.activateContext((String)iterator.next(), launch);
        }
    }

    private void activateContext(String contextId, ILaunch launch) {
        while (contextId != null) {
            Context context = fgContextService.getContext(contextId);
            IContextActivation activation = fgContextService.activateContext(contextId);
            this.addActivation(launch, activation);
            try {
                if (contextId.equals(DEBUG_CONTEXT)) break;
                contextId = context.getParentId();
            }
            catch (NotDefinedException e) {
                contextId = null;
                DebugUIPlugin.log(e);
            }
        }
    }

    private synchronized void addActivation(ILaunch launch, IContextActivation activation) {
        ArrayList<IContextActivation> activations = (ArrayList<IContextActivation>)this.fLanuchToContextActivations.get(launch);
        if (activations == null) {
            activations = new ArrayList<IContextActivation>();
            this.fLanuchToContextActivations.put(launch, activations);
        }
        activations.add(activation);
    }

    private String[] getDebugModelIds(Object object) {
        if (object instanceof IAdaptable) {
            String[] modelIds;
            IDebugModelProvider modelProvider;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugModelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelProvider = (IDebugModelProvider)iAdaptable.getAdapter((Class)clazz)) != null && (modelIds = modelProvider.getModelIdentifiers()) != null) {
                return modelIds;
            }
        }
        if (object instanceof IStackFrame) {
            return new String[]{((IStackFrame)object).getModelIdentifier()};
        }
        return null;
    }

    public static ILaunch getLaunch(Object object) {
        ILaunch launch = null;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.debug.core.ILaunch");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            launch = (ILaunch)iAdaptable.getAdapter((Class)clazz);
        }
        if (launch == null && object instanceof IDebugElement) {
            launch = ((IDebugElement)object).getLaunch();
        }
        return launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchesTerminated(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            List activations;
            ILaunch launch = launches[i];
            DebugModelContextBindingManager debugModelContextBindingManager = this;
            synchronized (debugModelContextBindingManager) {
                activations = (List)this.fLanuchToContextActivations.remove(launch);
                this.fLaunchToModelIds.remove(launch);
            }
            if (activations != null) {
                final List _activations = activations;
                UIJob job = new UIJob("Deactivate debug contexts"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Iterator iterator = _activations.iterator();
                        while (iterator.hasNext()) {
                            IContextActivation activation = (IContextActivation)iterator.next();
                            activation.getContextService().deactivateContext(activation);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            ++i;
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWorkbenchContextsForDebugContext(Object target) {
        ArrayList<String> workbenchContexts = new ArrayList<String>();
        String[] modelIds = this.getDebugModelIds(target);
        if (modelIds != null) {
            int i = 0;
            while (i < modelIds.length) {
                String modelId = modelIds[i];
                DebugModelContextBindingManager debugModelContextBindingManager = this;
                synchronized (debugModelContextBindingManager) {
                    List contextIds = (List)this.fModelToContextIds.get(modelId);
                    if (contextIds != null) {
                        Iterator contextIterator = contextIds.iterator();
                        while (contextIterator.hasNext()) {
                            String contextId = (String)contextIterator.next();
                            if (workbenchContexts.contains(contextId)) continue;
                            workbenchContexts.add(contextId);
                        }
                    }
                }
                ++i;
            }
        }
        return workbenchContexts;
    }

    private void enableActivitiesFor(String[] modelIds) {
        IWorkbenchActivitySupport activitySupport;
        HashSet enabledActivityIds;
        HashSet<String> activities = null;
        int i = 0;
        while (i < modelIds.length) {
            String id = modelIds[i];
            if (!this.fModelsEnabledForActivities.contains(id)) {
                HashSet<String> ids = (HashSet<String>)this.fModelToActivities.get(id);
                if (ids == null) {
                    ids = new HashSet<String>();
                    this.fModelToActivities.put(id, ids);
                    Iterator bindings = this.fModelPatternBindings.iterator();
                    while (bindings.hasNext()) {
                        IActivityPatternBinding binding = (IActivityPatternBinding)bindings.next();
                        String regex = binding.getPattern().pattern();
                        if (!Pattern.matches(regex = regex.substring(0, regex.length() - DEBUG_MODEL_ACTIVITY_SUFFIX.length()), id)) continue;
                        ids.add(binding.getActivityId());
                    }
                }
                if (!ids.isEmpty()) {
                    if (activities == null) {
                        activities = new HashSet<String>();
                    }
                    activities.addAll(ids);
                }
                this.fModelsEnabledForActivities.add(id);
            }
            ++i;
        }
        if (activities != null && !(enabledActivityIds = (activitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager().getEnabledActivityIds()).containsAll(activities)) {
            enabledActivityIds = new HashSet(enabledActivityIds);
            enabledActivityIds.addAll(activities);
            activitySupport.setEnabledActivityIds(activities);
        }
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
            this.fModelsEnabledForActivities.clear();
        }
    }
}

