/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.util.ChartUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeferredCacheManager {
    private final IDeviceRenderer fDeviceRenderer;
    private final Chart fChart;
    private DeferredCache fFirstDC;
    private DeferredCache fLastDC;
    private DeferredCache fSingleDC;
    private final List<DeferredCache> fDeferredCacheList = new ArrayList<DeferredCache>();

    public DeferredCacheManager(IDeviceRenderer idr, Chart chart) {
        this.fDeviceRenderer = idr;
        this.fChart = chart;
        this.fFirstDC = new DeferredCache(this.fDeviceRenderer, this.fChart);
        this.fLastDC = new DeferredCache(this.fDeviceRenderer, this.fChart);
    }

    private boolean hasStackedSeries() {
        int count = 0;
        for (SeriesDefinition sd : ChartUtil.getAllOrthogonalSeriesDefinitions(this.fChart)) {
            if (sd.getDesignTimeSeries() != null && sd.getDesignTimeSeries().isStacked()) {
                ++count;
            }
            if (count <= true) continue;
            return true;
        }
        return false;
    }

    private boolean needSignleDeferredCache(BaseRenderer br) {
        boolean is2DDepth;
        if (this.fSingleDC != null) {
            return true;
        }
        boolean bl = is2DDepth = this.fChart.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL;
        return br != null && br.getSeries() != null && (2 == this.fChart.getDimension().getValue() || br.getSeries().isSingleCache() || this.fChart instanceof ChartWithoutAxes && is2DDepth || is2DDepth && this.hasStackedSeries());
    }

    public DeferredCache createDeferredCache(BaseRenderer br) {
        if (this.needSignleDeferredCache(br)) {
            return this.createSingleDeferredCache();
        }
        return this.createDeferredCache();
    }

    DeferredCache createDeferredCache() {
        DeferredCache dc = new DeferredCache(this.fDeviceRenderer, this.fChart);
        this.fDeferredCacheList.add(dc);
        return dc;
    }

    DeferredCache createSingleDeferredCache() {
        if (this.fSingleDC != null) {
            return this.fSingleDC;
        }
        this.fSingleDC = new DeferredCache(this.fDeviceRenderer, this.fChart);
        this.fDeferredCacheList.add(this.fSingleDC);
        return this.fSingleDC;
    }

    public void flushAll() throws ChartException {
        int options = 51;
        this.flushOptions(options);
        this.flushMarkersNLabels();
        this.clearDC();
    }

    public void flushOptions(int options) throws ChartException {
        this.fFirstDC.flushOptions(options);
        for (DeferredCache obj : this.fDeferredCacheList) {
            if (!(obj instanceof DeferredCache)) continue;
            obj.flushOptions(options);
        }
        this.fLastDC.flushOptions(options);
    }

    void flushMarkersNLabels() throws ChartException {
        ArrayList<IRenderInstruction> allMarkers = new ArrayList<IRenderInstruction>();
        ArrayList<TextRenderEvent> allLabels = new ArrayList<TextRenderEvent>();
        this.getMarkersNLabels(allMarkers, allLabels);
        DeferredCache.flushMarkers(this.fDeviceRenderer, allMarkers);
        DeferredCache.flushLabels(this.fDeviceRenderer, allLabels);
    }

    public void getMarkersNLabels(List<IRenderInstruction> allMarkers, List<TextRenderEvent> allLabels) {
        allMarkers.addAll(this.fFirstDC.getAllMarkers());
        this.fFirstDC.getAllMarkers().clear();
        allLabels.addAll(this.fFirstDC.getAllLabels());
        this.fFirstDC.getAllLabels().clear();
        for (DeferredCache obj : this.fDeferredCacheList) {
            if (obj instanceof DeferredCache) {
                allMarkers.addAll(obj.getAllMarkers());
                obj.getAllMarkers().clear();
                allLabels.addAll(obj.getAllLabels());
                obj.getAllLabels().clear();
                continue;
            }
            if (!(obj instanceof List)) continue;
            Collections.sort((List)((Object)obj));
            for (DeferredCache dc : (List)((Object)obj)) {
                allMarkers.addAll(dc.getAllMarkers());
                dc.getAllMarkers().clear();
                allLabels.addAll(dc.getAllLabels());
                dc.getAllLabels().clear();
            }
        }
        allMarkers.addAll(this.fLastDC.getAllMarkers());
        this.fLastDC.getAllMarkers().clear();
        allLabels.addAll(this.fLastDC.getAllLabels());
        this.fLastDC.getAllLabels().clear();
    }

    public void clearDC() {
        this.fDeferredCacheList.clear();
        this.fFirstDC = null;
        this.fLastDC = null;
        this.fSingleDC = null;
    }

    public DeferredCache getFirstDeferredCache() {
        return this.fFirstDC;
    }

    public DeferredCache getLastDeferredCache() {
        return this.fLastDC;
    }

    public void process3DEvent(DeferredCache deferredCache, Engine3D engine, double xOffset, double yOffset) {
        if (deferredCache != null) {
            deferredCache.process3DEvent(engine, xOffset, yOffset);
        } else {
            this.fFirstDC.process3DEvent(engine, xOffset, yOffset);
            for (DeferredCache obj : this.fDeferredCacheList) {
                if (!(obj instanceof DeferredCache)) continue;
                obj.process3DEvent(engine, xOffset, yOffset);
            }
            this.fLastDC.process3DEvent(engine, xOffset, yOffset);
        }
    }
}

