/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Label;

public class EllipsisHelper {
    public static final String ELLIPSIS_STRING = "...";
    private int iMinCharToView = 0;
    private int iVisChar = 0;
    private String sText;
    private final ITester tester;

    public EllipsisHelper(ITester tester_, int iMinCharToView) {
        this.tester = tester_;
        this.iMinCharToView = iMinCharToView;
    }

    public ITester getTester() {
        return this.tester;
    }

    public void setIMinCharToView(int iMinCharToView) {
        this.iMinCharToView = iMinCharToView;
    }

    public static String ellipsisString(String str, int iVisChar) {
        if (iVisChar > 0 && iVisChar < str.length()) {
            return String.valueOf(str.substring(0, iVisChar)) + ELLIPSIS_STRING;
        }
        return str;
    }

    public int getVisibleCharCount() {
        return this.iVisChar;
    }

    private boolean testNthChar(int iChar, Object oPara) throws ChartException {
        String newText = String.valueOf(this.sText.substring(0, iChar)) + ELLIPSIS_STRING;
        boolean bResult = this.tester.testLabelVisible(newText, oPara);
        if (bResult) {
            this.iVisChar = iChar;
        }
        return bResult;
    }

    public boolean checkLabelEllipsis(String sText_, Object oPara) throws ChartException {
        int iEnd;
        this.sText = sText_;
        this.iVisChar = 0;
        boolean bCanViewFullText = this.tester.testLabelVisible(this.sText, oPara);
        if (bCanViewFullText) {
            return true;
        }
        if (this.iMinCharToView <= 0) {
            return bCanViewFullText;
        }
        int len = this.sText.length() - 1;
        if (len < this.iMinCharToView) {
            return false;
        }
        if (!this.testNthChar(this.iMinCharToView, oPara)) {
            return false;
        }
        if (len < 8) {
            int iChar = len;
            while (iChar >= this.iMinCharToView) {
                if (this.testNthChar(iChar, oPara)) {
                    return true;
                }
                --iChar;
            }
            return false;
        }
        int iStart = this.iMinCharToView;
        int iChar = iEnd = len;
        int iLimit = 19;
        while (iLimit > 0 && iEnd > iStart + 1) {
            iChar = (iStart + iEnd) / 2;
            if (this.testNthChar(iChar, oPara)) {
                iStart = iChar;
            } else {
                iEnd = iChar;
            }
            --iLimit;
        }
        if (iChar != iStart) {
            return this.testNthChar(iStart, oPara);
        }
        this.iVisChar = iChar;
        return true;
    }

    public static ITester createSimpleTester(IChartComputation cComp, IDisplayServer xs, Label la, Double fontHeight) throws ChartException {
        return new SimpleTester(cComp, xs, la, fontHeight);
    }

    public static EllipsisHelper simpleInstance(IChartComputation cComp, IDisplayServer xs, Label la, Double fontHeight) throws ChartException {
        return new EllipsisHelper(EllipsisHelper.createSimpleTester(cComp, xs, la, fontHeight), 1);
    }

    public static interface ITester {
        public double getWidth() throws ChartException;

        public double getHeight() throws ChartException;

        public boolean testLabelVisible(String var1, Object var2) throws ChartException;
    }

    private static class SimpleTester
    implements ITester {
        private final IChartComputation cComp;
        private final IDisplayServer xs;
        private final Label la;
        private final Double fontHeight;
        private BoundingBox bb = null;

        public SimpleTester(IChartComputation cComp, IDisplayServer xs, Label la, Double fontHeight) throws ChartException {
            this.cComp = cComp;
            this.xs = xs;
            this.la = la;
            this.fontHeight = fontHeight != null ? fontHeight : Double.valueOf(cComp.computeFontHeight(xs, la));
        }

        private void computeSize(double dWrapping) throws ChartException {
            this.bb = this.cComp.computeLabelSize(this.xs, this.la, dWrapping, this.fontHeight);
        }

        private boolean testSize(LabelLimiter lblLimit) {
            return this.bb.getWidth() <= lblLimit.getMaxWidth() && this.bb.getHeight() <= lblLimit.getMaxHeight();
        }

        public boolean testLabelVisible(String strNew, Object para) throws ChartException {
            LabelLimiter lbLimit = (LabelLimiter)para;
            this.la.getCaption().setValue(strNew);
            if (lbLimit.getMaxHeight() < this.fontHeight) {
                return false;
            }
            this.computeSize(0.0);
            if (this.testSize(lbLimit)) {
                return true;
            }
            if (lbLimit.getWrapping() > 0.0) {
                this.computeSize(lbLimit.getWrapping());
                return this.testSize(lbLimit);
            }
            return false;
        }

        public double getHeight() throws ChartException {
            if (this.bb == null) {
                this.computeSize(0.0);
            }
            return this.bb.getHeight();
        }

        public double getWidth() throws ChartException {
            if (this.bb == null) {
                this.computeSize(0.0);
            }
            return this.bb.getWidth();
        }
    }
}

