/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelType;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModelPropertiesPage
extends WizardPage {
    private Text modelNameText;
    private Combo modelTypeCombo;
    private ComboViewer modelParentViewer;
    private Composite container;
    private Button loadModelsButton;
    private Model model;

    public ModelPropertiesPage(Model model) {
        super("Model Properties");
        this.setTitle("Model Properties");
        this.setDescription("Configure a computational model");
        this.model = model;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        Label modelNameLabel = new Label(this.container, 0);
        modelNameLabel.setText("Model Name");
        this.modelNameText = new Text(this.container, 2052);
        this.modelNameText.setText(WizardHelper.safeGet(this.model.getName()));
        GridData modelNameTextData = new GridData(768);
        modelNameTextData.horizontalSpan = 2;
        this.modelNameText.setLayoutData((Object)modelNameTextData);
        this.modelNameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ModelPropertiesPage.this.formatTextFields();
                ModelPropertiesPage.this.validatePage();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.modelNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ModelPropertiesPage.this.validatePage();
            }
        });
        String[] modelTypes = WizardHelper.getModelTypes();
        Label modelTypeLabel = new Label(this.container, 0);
        modelTypeLabel.setText("Model Type");
        this.modelTypeCombo = new Combo(this.container, 8);
        GridData modelTypeComboData = new GridData();
        modelTypeComboData.horizontalSpan = 2;
        this.modelTypeCombo.setLayoutData((Object)modelTypeComboData);
        this.modelTypeCombo.setItems(modelTypes);
        this.modelTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelPropertiesPage.this.doSelectModelType();
                ModelPropertiesPage.this.validatePage();
            }
        });
        Label modelParentLabel = new Label(this.container, 0);
        modelParentLabel.setText("Parent Model");
        this.modelParentViewer = new ComboViewer(this.container, 8);
        this.modelParentViewer.setContentProvider((IContentProvider)new ModelParentContentProvider());
        this.modelParentViewer.setLabelProvider((IBaseLabelProvider)new ModelParentLabelProvider());
        this.modelParentViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof EClass && e2 instanceof EClass) {
                    return ((EClass)e1).getName().compareTo(((EClass)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.modelParentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelPropertiesPage.this.validatePage();
            }
        });
        this.loadModelsButton = new Button(this.container, 8);
        this.loadModelsButton.setEnabled(true);
        this.loadModelsButton.setText("Reload Model List");
        this.loadModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardHelper.loadMetamodels(true, (IRunnableContext)ModelPropertiesPage.this.getContainer());
                ModelPropertiesPage.this.modelParentViewer.refresh();
            }
        });
        this.modelTypeCombo.select(0);
        int idx = 0;
        while (idx < modelTypes.length) {
            if (modelTypes[idx].equals(this.model.getModelType().getLiteral())) {
                this.modelTypeCombo.select(idx);
                break;
            }
            ++idx;
        }
        this.doSelectModelType();
        this.doSelectParentModel();
        this.setControl((Control)this.container);
        this.validatePage();
    }

    private void doSelectParentModel() {
        if (this.model.getParentModel() != null) {
            String[] items = this.modelParentViewer.getCombo().getItems();
            int idx = 0;
            while (idx < items.length) {
                Object selected;
                if (items[idx].equals(this.model.getParentModel().getName()) && (selected = this.modelParentViewer.getElementAt(idx)) != null) {
                    this.modelParentViewer.setSelection((ISelection)new StructuredSelection(selected));
                    break;
                }
                ++idx;
            }
        }
    }

    private void doSelectModelType() {
        ModelType selectedType = this.getModelType();
        this.modelParentViewer.setInput((Object)selectedType);
    }

    public String getModelName() {
        return this.modelNameText.getText();
    }

    public ModelType getModelType() {
        return ModelType.get((String)this.modelTypeCombo.getItem(this.modelTypeCombo.getSelectionIndex()));
    }

    public Model getParentModel() {
        StructuredSelection selection = (StructuredSelection)this.modelParentViewer.getSelection();
        if (selection.getFirstElement() instanceof Model) {
            Model selectedModel = (Model)selection.getFirstElement();
            if (this.model.getParentModel() != null && this.model.getParentModel().getName() != null && this.model.getParentModel().getName().equals(selectedModel.getName())) {
                return this.model.getParentModel();
            }
            return selectedModel;
        }
        return null;
    }

    private void loadModelPackages() {
        WizardHelper.loadMetamodels(false, (IRunnableContext)this.getContainer());
    }

    boolean validatePage() {
        String errorMessage = null;
        boolean valid = true;
        if (valid && WizardHelper.isNullOrEmpty(this.getModelName())) {
            errorMessage = "Please enter a name for this model";
            valid = false;
        }
        if (valid && !WizardHelper.isValidJavaName(WizardHelper.formatToUpperCaseWordsNoSpaces(this.getModelName()))) {
            errorMessage = "The model name is invalid.  Please check that it contains only alphanumeric characters and the first letter is non-numeric.";
            valid = false;
        }
        if (valid && this.getParentModel() == null) {
            errorMessage = "Please select a parent model for this model";
            valid = false;
        }
        if (valid) {
            this.model.setModelType(this.getModelType());
            this.model.setName(this.getModelName());
            if (this.model.getCompartments() == null) {
                CompartmentGroup cg = MetamodelFactory.eINSTANCE.createCompartmentGroup();
                this.model.setCompartments(cg);
            }
            this.model.getCompartments().setName(this.getModelName());
            Model parentModel = this.getParentModel();
            if (parentModel != null && parentModel != this.model.getParentModel()) {
                this.model.setParentModel(parentModel);
                this.model.getCompartments().setParentGroup(parentModel.getCompartments());
            }
        }
        this.setPageComplete(valid);
        this.setErrorMessage(errorMessage);
        return valid;
    }

    void formatTextFields() {
        this.modelNameText.setText(WizardHelper.formatToUpperCaseWordsNoSpaces(this.modelNameText.getText()));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadModelPackages();
            this.doSelectParentModel();
        } else {
            this.formatTextFields();
        }
    }

    private class ModelParentContentProvider
    implements IStructuredContentProvider {
        private ModelParentContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List<Model> data = WizardHelper.getModelsForModelType((ModelType)inputElement, false, (IProgressMonitor)new NullProgressMonitor());
            if (data != null) {
                return data.toArray();
            }
            return new Object[0];
        }
    }

    private class ModelParentLabelProvider
    extends LabelProvider {
        private ModelParentLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Model) {
                return ((Model)element).getName();
            }
            return "";
        }
    }
}

