/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.AggregateReferenceFileLoader;
import org.eclipse.stem.ui.reports.views.AggregateTimeSeriesCanvas;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AggregateValueHistoryPlotter
extends ReportControl
implements ISimulationListenerSync {
    AggregateTimeSeriesCanvas aggregateSeriesCanvas;
    PropertySelector propertySelector;
    List<ItemPropertyDescriptor> selectedProperties;
    Set<ItemPropertyDescriptor> allProperties = new HashSet<ItemPropertyDescriptor>();
    Map<String, List<Double>> dataMap = new HashMap<String, List<Double>>();
    List<Double> aggregateReference = new ArrayList<Double>();
    Set<String> referenceIDs = new HashSet<String>();
    String selectedReferenceFile;
    HashMap<String, Set<RelativeValueProviderAdapter>> relativeValueProviderSet = new HashMap();
    HashMap<String, Double> totalPopulation = new HashMap();
    Graph graph = null;
    int timeCount = 0;
    protected static final String REFERENCE_PROPERTY = "ref";
    Set<ISimulation> activeSimulations = new HashSet<ISimulation>();
    String populationId;
    private final PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (rvp != null) {
                rvp.setTarget((Notifier)dynamicLabel);
                for (Object element : rvp.getProperties()) {
                    ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                    retValue.add(property);
                }
            }
            return retValue;
        }
    };

    public AggregateValueHistoryPlotter(Composite parent) {
        super(parent, 0);
        this.simulation = null;
        this.dataMap.put(REFERENCE_PROPERTY, this.aggregateReference);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        this.timeCount = 0;
        this.identifiableTitle = new Label((Composite)this, 0);
        this.aggregateSeriesCanvas = new AggregateTimeSeriesCanvas(this);
        this.aggregateSeriesCanvas.reset();
        this.propertySelector = new PropertySelector((Composite)this, 0, true);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText("remove");
        this.addReferenceLabel = new Label((Composite)this, 2048);
        String refFile = Activator.getDefault().getPreferenceStore().getString("reference.file");
        if (refFile == null) {
            refFile = "";
        }
        this.selectedReferenceFile = refFile;
        this.addReferenceLabel.setText(refFile);
        this.addReferenceButton = new Button((Composite)this, 0);
        this.addReferenceButton.setText("Add Reference");
        final Shell shell = this.getShell();
        final AggregateValueHistoryPlotter self = this;
        this.addReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selected;
                FileDialog dd = new FileDialog(shell, 4096);
                dd.setText(Messages.getString("REPORTVIEW.SELECTREFENCEFOLDER"));
                dd.setFilterPath(AggregateValueHistoryPlotter.this.addReferenceLabel.getText());
                self.selectedReferenceFile = selected = dd.open();
                AggregateValueHistoryPlotter.this.addReferenceLabel.setText(selected);
                Activator.getDefault().getPreferenceStore().setValue("reference.file", selected);
                try {
                    AggregateReferenceFileLoader refLoader = new AggregateReferenceFileLoader(selected);
                    AggregateValueHistoryPlotter.this.aggregateReference = refLoader.getAggregateData();
                    AggregateValueHistoryPlotter.this.dataMap.put(AggregateValueHistoryPlotter.REFERENCE_PROPERTY, AggregateValueHistoryPlotter.this.aggregateReference);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Activator.logError(ex.getMessage(), ex);
                }
            }
        });
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        FormData chartFormData = new FormData();
        this.aggregateSeriesCanvas.setLayoutData(chartFormData);
        chartFormData.top = new FormAttachment((Control)this.identifiableTitle, 0);
        chartFormData.bottom = new FormAttachment((Control)this.propertySelector, 0);
        chartFormData.left = new FormAttachment(0, 0);
        chartFormData.right = new FormAttachment(100, 0);
        FormData propertySelectorFormData = new FormData();
        propertySelectorFormData.bottom = new FormAttachment(100, 0);
        propertySelectorFormData.left = new FormAttachment(0, 0);
        propertySelectorFormData.right = new FormAttachment(30, 0);
        this.propertySelector.setLayoutData((Object)propertySelectorFormData);
        FormData removeButtonFormData = new FormData();
        removeButtonFormData.bottom = new FormAttachment(100, 0);
        removeButtonFormData.left = new FormAttachment((Control)this.propertySelector, 0);
        removeButtonFormData.right = new FormAttachment(60, 0);
        this.removeButton.setLayoutData((Object)removeButtonFormData);
        FormData addReferenceButtonFormData = new FormData();
        addReferenceButtonFormData.bottom = new FormAttachment((Control)this.removeButton, 0);
        addReferenceButtonFormData.left = new FormAttachment((Control)this.removeButton, 0);
        addReferenceButtonFormData.right = new FormAttachment(100, 0);
        this.addReferenceButton.setLayoutData((Object)addReferenceButtonFormData);
        FormData addReferenceLabelFormData = new FormData();
        addReferenceLabelFormData.top = new FormAttachment((Control)this.addReferenceButton, 0);
        addReferenceLabelFormData.left = new FormAttachment((Control)this.removeButton, 0);
        addReferenceLabelFormData.right = new FormAttachment(100, 0);
        this.addReferenceLabel.setLayoutData((Object)addReferenceLabelFormData);
        this.propertySelector.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                AggregateValueHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                AggregateValueHistoryPlotter.this.selectedProperties = AggregateValueHistoryPlotter.this.getPropertiesToDisplay(AggregateValueHistoryPlotter.this.selectedDecorator);
                AggregateValueHistoryPlotter.this.populationId = propertySelectionEvent.getId();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AggregateValueHistoryPlotter.this.fireRemoveEvent(AggregateValueHistoryPlotter.this.identifiable);
                AggregateValueHistoryPlotter.this.remove();
            }
        });
    }

    @Override
    public void remove() {
        this.removeListeners.clear();
        this.switchToRVHP(null);
        this.relativeValueHistoryExtended(null);
        this.identifiableTitle.setText("");
        this.propertySelector.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    @Override
    public final void setSimulation(ISimulation simulation) {
        if (this.simulation == simulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        this.simulation = simulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListenerSync((ISimulationListenerSync)this);
            this.initializeFromSimulation(this.simulation);
            ArrayList<Decorator> decorators = new ArrayList<Decorator>();
            for (Decorator d : this.graph.getDecorators()) {
                if (!(d instanceof DiseaseModel)) continue;
                decorators.add(d);
            }
            this.propertySelector.setDecorators(decorators);
            Map<Node, Integer> nodeLevelsMap = this.getNodeLevels(simulation);
            int level = this.getHighestResolution(nodeLevelsMap);
            Iterator<Node> iter = this.getNodeIterator(level, nodeLevelsMap);
            while (iter != null && iter.hasNext()) {
                Node node = iter.next();
                EList labels = node.getLabels();
                int i = 0;
                while (i < labels.size()) {
                    DiseaseModelLabel dynamicLabel;
                    RelativeValueProviderAdapter rvp;
                    NodeLabel label = (NodeLabel)labels.get(i);
                    if (label instanceof DiseaseModelLabel && (rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)(dynamicLabel = (DiseaseModelLabel)label), RelativeValueProvider.class)) != null) {
                        rvp.setTarget((Notifier)dynamicLabel);
                        String populationIdentifier = dynamicLabel.getPopulationModelLabel().getPopulationIdentifier();
                        if (this.totalPopulation.get(populationIdentifier) != null) {
                            this.totalPopulation.put(populationIdentifier, this.totalPopulation.get(populationIdentifier) + rvp.getDenominator(null));
                        } else {
                            this.totalPopulation.put(populationIdentifier, rvp.getDenominator(null));
                        }
                        if (this.relativeValueProviderSet.containsKey(populationIdentifier)) {
                            this.relativeValueProviderSet.get(populationIdentifier).add(rvp);
                        } else {
                            this.relativeValueProviderSet.put(populationIdentifier, new HashSet());
                            this.relativeValueProviderSet.get(populationIdentifier).add(rvp);
                        }
                        for (Object element : rvp.getProperties()) {
                            ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                            this.allProperties.add(property);
                        }
                    }
                    ++i;
                }
            }
            for (String p : this.totalPopulation.keySet()) {
                if (!(this.totalPopulation.get(p) <= 0.0)) continue;
                this.totalPopulation.put(p, 1.0);
            }
        } else {
            this.relativeValueProviderSet.clear();
            this.allProperties.clear();
        }
    }

    @Override
    public void setIdentifiable(Identifiable identifiable) {
    }

    public void relativeValueHistoryExtended(RelativeValueHistoryProviderAdapter rvhp) {
    }

    @Override
    protected void initializeFromSimulation(ISimulation simulation) {
        this.graph = simulation.getScenario().getCanonicalGraph();
        this.timeCount = 0;
        this.redraw();
    }

    @Override
    public void refresh2() {
    }

    public int getNumProperties() {
        return this.dataMap.keySet().size();
    }

    public String getProperty(int index) {
        Object[] keys = this.dataMap.keySet().toArray();
        Arrays.sort(keys);
        return (String)keys[index];
    }

    public double[] getValues(String property) {
        if (this.populationId == null) {
            double[] ret = new double[]{1.0};
            return ret;
        }
        List<Double> valList = this.dataMap.get(property);
        double[] data = new double[this.timeCount];
        int i = 0;
        while (i < this.timeCount) {
            if (valList != null && i < valList.size()) {
                data[i] = valList.get(i);
                if (property.equalsIgnoreCase(REFERENCE_PROPERTY)) {
                    int n = i;
                    data[n] = data[n] / this.totalPopulation.get(this.populationId);
                }
            } else {
                data[i] = 1.0 / this.totalPopulation.get(this.populationId);
            }
            ++i;
        }
        return data;
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            retValue.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return retValue;
    }

    private Graph getGraph(Node node) {
        return (Graph)node.eContainer().eContainer();
    }

    public void simulationChangedSync(SimulationEvent event) {
        if (event.getSimulationState() == SimulationState.RUNNING) {
            if (this.selectedReferenceFile == null) {
                this.selectedReferenceFile = Activator.getDefault().getPreferenceStore().getString("reference.file");
            }
            if (this.aggregateReference == null || this.aggregateReference.size() == 0) {
                try {
                    AggregateReferenceFileLoader refLoader = new AggregateReferenceFileLoader(this.selectedReferenceFile);
                    this.aggregateReference = refLoader.getAggregateData();
                    this.dataMap.put(REFERENCE_PROPERTY, this.aggregateReference);
                    this.referenceIDs = refLoader.getIdSet();
                }
                catch (Exception e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        } else if (event.getSimulationState() == SimulationState.COMPLETED_CYCLE) {
            this.sumData();
            this.aggregateSeriesCanvas.draw();
            this.redraw();
            ++this.timeCount;
        } else if (event.getSimulationState() == SimulationState.STOPPED) {
            if (this.simulation == event.getSimulation()) {
                this.activeSimulations.remove(this.simulation);
                this.simulation.removeSimulationListener((ISimulationListener)this);
                this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
                this.simulation = null;
                this.identifiableTitle.setText("");
                this.propertySelector.setDecorators(Collections.EMPTY_LIST);
                this.timeCount = 0;
            }
        } else if (this.simulation == event.getSimulation() && event.getSimulationState() == SimulationState.RESET) {
            this.aggregateSeriesCanvas.resetData();
            this.timeCount = 0;
        }
    }

    public void simulationChanged(SimulationEvent event) {
        if (this.simulation == event.getSimulation() && event.getSimulationState() == SimulationState.RESET) {
            this.aggregateSeriesCanvas.resetData();
            this.timeCount = 0;
        }
        if (event.getSimulationState() == SimulationState.STOPPED && this.simulation == event.getSimulation()) {
            this.activeSimulations.remove(this.simulation);
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
            this.simulation = null;
            this.identifiableTitle.setText("");
            this.propertySelector.setDecorators(Collections.EMPTY_LIST);
            this.timeCount = 0;
        }
        if (event.getSimulationState() == SimulationState.STOPPED && this.simulation == event.getSimulation()) {
            this.activeSimulations.remove(this.simulation);
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
            this.simulation = null;
            this.identifiableTitle.setText("");
            this.propertySelector.setDecorators(Collections.EMPTY_LIST);
            this.timeCount = 0;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.rvhp != null) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
    }

    @Override
    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public String getControlType() {
        return "SIMULATION_CONTROL_FACTORY";
    }

    public void sumData() {
        Iterator<ItemPropertyDescriptor> iter = this.allProperties.iterator();
        while (iter != null && iter.hasNext()) {
            ItemPropertyDescriptor property = iter.next();
            String propertyKey = property.getDisplayName((Object)property);
            if (!this.dataMap.containsKey(propertyKey)) {
                ArrayList<Double> newData = new ArrayList<Double>();
                int i = 0;
                while (i < this.timeCount) {
                    newData.add(i, 0.0);
                    ++i;
                }
                this.dataMap.put(propertyKey, newData);
            }
            double totPop = 0.0;
            double sum = 0.0;
            if (this.relativeValueProviderSet.get(this.populationId) != null) {
                Iterator<RelativeValueProviderAdapter> iter2 = this.relativeValueProviderSet.get(this.populationId).iterator();
                while (iter2 != null && iter2.hasNext()) {
                    RelativeValueProviderAdapter rvp = iter2.next();
                    double nodePopulation = rvp.getDenominator(null);
                    totPop += nodePopulation;
                    sum += nodePopulation * rvp.getRelativeValue(property);
                }
            }
            if (totPop <= 0.0) {
                totPop = 1.0;
            }
            this.totalPopulation.put(this.populationId, totPop);
            this.aggregateSeriesCanvas.setMinYscale(1.0 / this.totalPopulation.get(this.populationId));
            List<Double> aggregateList = this.dataMap.get(propertyKey);
            aggregateList.add(this.timeCount, sum /= totPop);
            this.dataMap.put(propertyKey, aggregateList);
        }
    }

    private int getHighestResolution(Map<Node, Integer> nodeLevels) {
        int retVal = -1;
        Collection<Integer> vals = nodeLevels.values();
        for (int level : vals) {
            if (level < retVal) continue;
            retVal = level;
        }
        return retVal;
    }

    private Iterator<Node> getNodeIterator(int level, Map<Node, Integer> nodeLevels) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Map.Entry<Node, Integer> entry : nodeLevels.entrySet()) {
            if (entry.getValue() != level) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    public Map<Node, Integer> getNodeLevels(ISimulation simulation) {
        HashMap<Node, Integer> result = new HashMap<Node, Integer>();
        Graph graph = simulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            EMap allNodes = graph.getNodes();
            Set allGraphURIs = allNodes.keySet();
            Iterator graphIter2 = allGraphURIs.iterator();
            while (graphIter2 != null && graphIter2.hasNext()) {
                URI uri = (URI)graphIter2.next();
                Node node = (Node)allNodes.get((Object)uri);
                String id = node.getURI().toString();
                int level = this.getAdminLevel(id);
                result.put(node, level);
            }
        }
        return result;
    }

    private int getAdminLevel(String uriKey) {
        int retVal = 0;
        String test = uriKey;
        while (test.contains("-")) {
            String test2;
            ++retVal;
            int idx1 = test.indexOf("-");
            test = test2 = test.substring(idx1 + 1, test.length());
        }
        return retVal;
    }

    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

