/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.RemoveUnsupportedAnnotationOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class UnsupportedAnnotationResolution
extends WorkbenchMarkerResolution {
    protected IMarker fBackingMarker = null;
    private boolean plural = false;

    public UnsupportedAnnotationResolution(IMarker marker) {
        this.fBackingMarker = marker;
    }

    public String getDescription() {
        if (this.plural) {
            return MarkerMessages.UnsupportedAnnotationResolution_remove_unsupported_annotation;
        }
        return this.getLabel();
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_REMOVE");
    }

    public String getLabel() {
        if (this.plural) {
            return this.getDescription();
        }
        try {
            String arg = (String)this.fBackingMarker.getAttribute("messagearguments");
            String[] args = arg.split("#");
            return NLS.bind((String)MarkerMessages.UnsupportedAnnotationResolution_remove_unsupported_named_annotation, (Object[])new String[]{args[0]});
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void run(IMarker marker) {
        RemoveUnsupportedAnnotationOperation op = new RemoveUnsupportedAnnotationOperation(new IMarker[]{marker});
        op.schedule();
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        int i = 0;
        while (i < markers.length) {
            if (Util.isApiProblemMarker((IMarker)markers[i]) && !this.fBackingMarker.equals((Object)markers[i]) && markers[i].getAttribute("apiMarkerID", -1) == 11) {
                mset.add(markers[i]);
            }
            ++i;
        }
        int size = mset.size();
        this.plural = size > 0;
        return mset.toArray(new IMarker[size]);
    }
}

