/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class XYSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private AnalysisControl control = null;
    protected int chartIndex = 0;
    private static final String DEFAULT_KEY_PREFIX = "XY";
    private static String defaultKey = "XY";
    protected static final int[][] colorDefault;
    private int seriesCount = 0;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    protected final Map<String, DataXYSeries> dataSeriesMap = new HashMap<String, DataXYSeries>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxY = Double.MIN_VALUE;
    double maxX = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private double minX = Double.MAX_VALUE;
    public String Ordinate_LEGEND = "Y";
    public String Ordinate_AXIS = "Y";
    protected ColorDefinition foreGround = ColorDefinitionImpl.WHITE();
    private ColorDefinition backgroundGround = ColorDefinitionImpl.BLACK();
    private ColorDefinition frameColor = ColorDefinitionImpl.create((int)180, (int)180, (int)200);
    Image imgChart = null;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[3];
        nArray[2] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 255;
        nArray4[1] = 255;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[3];
        nArrayArray[5] = new int[]{127, 127, 127};
        nArrayArray[6] = new int[]{255, 255, 255};
        nArrayArray[7] = new int[]{255, 197, 41};
        colorDefault = nArrayArray;
    }

    public XYSeriesCanvas(AnalysisControl analysisControl, Composite parent, String ordinateString, String yAxisLabel, ColorDefinition foreground, ColorDefinition background, ColorDefinition framecolor, int chartIndex) {
        super(parent, 0x20000800);
        this.Ordinate_LEGEND = ordinateString;
        this.Ordinate_AXIS = yAxisLabel;
        defaultKey = DEFAULT_KEY_PREFIX + chartIndex;
        this.foreGround = foreground;
        this.backgroundGround = background;
        this.frameColor = framecolor;
        this.chartIndex = chartIndex;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError(Messages.getString("COMMON.ERRORINIT"), pex);
            return;
        }
        this.control = analysisControl;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (XYSeriesCanvas.this.imgChart != null) {
                    XYSeriesCanvas.this.imgChart.dispose();
                }
                XYSeriesCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                XYSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)XYSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)XYSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    XYSeriesCanvas.this.gr.render(XYSeriesCanvas.this.idr, XYSeriesCanvas.this.gr.build(XYSeriesCanvas.this.idr.getDisplayServer(), XYSeriesCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(XYSeriesCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public XYSeriesCanvas(Composite parent, String ordinateString, String yAxisLabel, ColorDefinition foreground, ColorDefinition background, ColorDefinition framecolor, int chartIndex) {
        super(parent, 0x20000800);
        this.Ordinate_LEGEND = ordinateString;
        this.Ordinate_AXIS = yAxisLabel;
        defaultKey = DEFAULT_KEY_PREFIX + chartIndex;
        this.foreGround = foreground;
        this.backgroundGround = background;
        this.frameColor = framecolor;
        this.chartIndex = chartIndex;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError(Messages.getString("COMMON.ERRORINIT"), pex);
            return;
        }
        this.control = (AnalysisControl)parent;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (XYSeriesCanvas.this.imgChart != null) {
                    XYSeriesCanvas.this.imgChart.dispose();
                }
                XYSeriesCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                XYSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)XYSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)XYSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    XYSeriesCanvas.this.gr.render(XYSeriesCanvas.this.idr, XYSeriesCanvas.this.gr.build(XYSeriesCanvas.this.idr.getDisplayServer(), XYSeriesCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(XYSeriesCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError(Messages.getString("COMMON.ERRORINIT"), ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        this.resetData();
        this.maxY = -1.0;
        this.minY = 0.0;
        this.maxX = -1.0;
        this.minX = 0.0;
        double adjustedMaxY = 0.0;
        double adjustedMaxX = 0.0;
        int i = 0;
        while (i <= 1) {
            DataXYSeries series;
            String property = DEFAULT_KEY_PREFIX + this.chartIndex;
            if (i == 1) {
                property = "FIT" + this.chartIndex;
            }
            if (!this.dataSeriesMap.containsKey(property)) {
                series = new DataXYSeries(property);
                ++this.seriesCount;
                this.dataSeriesMap.put(property, series);
            }
            if ((series = this.dataSeriesMap.get(property)).isVisible()) {
                series.show();
            } else {
                series.hide();
            }
            int maxPoints = 0;
            double[] doubleValuesX = this.control.getValues(this.chartIndex, 2 * i + 2);
            double[] doubleValuesY = this.control.getValues(this.chartIndex, 2 * i + 3);
            int j = 0;
            while (j < doubleValuesX.length) {
                double log;
                if (doubleValuesY[j] <= this.minY) {
                    this.minY = doubleValuesY[j];
                    this.minY = Math.round(this.minY);
                }
                if (doubleValuesX[j] <= this.minX) {
                    this.minX = doubleValuesX[j];
                    this.minX = Math.round(this.minX);
                }
                if (doubleValuesY[j] >= this.maxY) {
                    this.maxY = doubleValuesY[j];
                    log = Math.floor(Math.log10(this.maxY));
                    adjustedMaxY = Math.ceil(this.maxY / Math.pow(10.0, log)) * Math.pow(10.0, log);
                }
                if (doubleValuesX[j] >= this.maxX) {
                    this.maxX = 1.02 * doubleValuesX[j];
                    log = Math.floor(Math.log10(this.maxX));
                    adjustedMaxX = Math.ceil(this.maxX / Math.pow(10.0, log)) * Math.pow(10.0, log);
                }
                ++j;
            }
            this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)adjustedMaxX));
            double stepX = adjustedMaxX / 10.0;
            this.xAxisPrimary.getScale().setStep(stepX);
            this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)this.minY));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)adjustedMaxY));
            double stepY = adjustedMaxY / 10.0;
            this.yAxisPrimary.getScale().setStep(stepY);
            this.yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
            if (doubleValuesX.length > 0) {
                if (maxPoints < doubleValuesX.length) {
                    maxPoints = doubleValuesX.length;
                }
                int cycleNumber = 0;
                while (cycleNumber < doubleValuesX.length) {
                    Double valueX = doubleValuesX[cycleNumber];
                    Double valueY = doubleValuesY[cycleNumber];
                    series.addValue(valueX, valueY);
                    ++cycleNumber;
                }
            }
            ++i;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public final Chart createSimpleLineChart(Map<String, DataXYSeries> dataXYSeriesMap, String seriesIdentifier) {
        ChartWithAxes retValue = ChartWithAxesImpl.create();
        retValue.getBlock().setBackground((Fill)this.frameColor);
        Plot p = retValue.getPlot();
        p.getClientArea().setBackground((Fill)this.backgroundGround);
        retValue.getTitle().setVisible(false);
        this.legend = retValue.getLegend();
        LineAttributes lia = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.foreGround);
        this.legend.getOutline().setColor(this.foreGround);
        this.xAxisPrimary = retValue.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary = retValue.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.setCategoryAxis(false);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.xAxisPrimary.getScale().setStep(0.1);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.xAxisPrimary.getTitle().getCaption().setValue(Messages.getString("TS.TIMELABEL"));
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.1);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary.getTitle().getCaption().setValue(this.Ordinate_AXIS);
        this.yAxisPrimary.getTitle().setVisible(true);
        if (!dataXYSeriesMap.containsKey(defaultKey)) {
            DataXYSeries series = new DataXYSeries(defaultKey);
            ++this.seriesCount;
            dataXYSeriesMap.put(defaultKey, series);
        }
        return retValue;
    }

    protected void createContextMenu(Composite parent) {
        MenuManager contextMenuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        contextMenuManager.add((IAction)this.linearTimeAction);
        contextMenuManager.add((IAction)this.logTimeAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        contextMenuManager.add((IAction)this.viewLegend);
        contextMenuManager.add((IAction)this.hideLegend);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite parent) {
        this.popUpMenu.dispose();
        MenuManager contextMenuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        contextMenuManager.add((IAction)this.linearTimeAction);
        contextMenuManager.add((IAction)this.logTimeAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        contextMenuManager.add((IAction)this.viewLegend);
        contextMenuManager.add((IAction)this.hideLegend);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        int i = 0;
        while (i < this.control.getNumProperties(this.chartIndex)) {
            String nextProp = this.control.getProperty(this.chartIndex, i);
            DataXYSeries series = this.dataSeriesMap.get(nextProp);
            DisplayableProperty property = new DisplayableProperty(nextProp, series.isVisible());
            contextMenuManager.add((IAction)property);
            ++i;
        }
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        Menu popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
    }

    public static void setColorDefs(List<String> propertiesToPlot, List<ScatterSeries> lsList) {
        Map colorMap = VisualizationPreferencePage.getColorMapping();
        int i = 0;
        while (i < lsList.size()) {
            ColorDefinition color = ColorDefinitionImpl.BLUE();
            if (propertiesToPlot != null && propertiesToPlot.size() > i) {
                String key = propertiesToPlot.get(i);
                if (colorMap.containsKey(key)) {
                    STEMColor c = (STEMColor)colorMap.get(key);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                }
                lsList.get(i).setSeriesIdentifier((Object)key);
                lsList.get(i).getLineAttributes().setColor(color);
            } else if (lsList.get(i) != null) {
                lsList.get(i).setSeriesIdentifier((Object)" ");
                lsList.get(i).getLineAttributes().setColor(color);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
    }

    private void clearData() {
        Iterator<String> iter = this.dataSeriesMap.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            DataXYSeries series = this.dataSeriesMap.get(key);
            series.yValues.clear();
            series.xValues.clear();
            series.addValue(0.0, 0.0);
        }
    }

    void toggleAxisScale() {
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    protected class DataXYSeries {
        public String propertyName = "";
        public List<Double> yValues = new ArrayList<Double>();
        public List<Double> xValues = new ArrayList<Double>();
        public Series seriesX = null;
        public ScatterSeries scatterSeriesY = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private SeriesDefinition sdX = null;

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean state) {
            this.visible = state;
        }

        public void toggleVisible() {
            this.visible = !this.visible;
        }

        public DataXYSeries(String propertyName) {
            this.propertyName = propertyName;
            this.yValues = new ArrayList<Double>();
            this.yValues.add(0.0);
            this.xValues = new ArrayList<Double>();
            this.xValues.add(0.0);
            this.addScatterSeries(propertyName);
        }

        public void addValue(Double valX, Double valY) {
            if (this.yValues == null) {
                this.yValues = new ArrayList<Double>();
            }
            if (this.xValues == null) {
                this.xValues = new ArrayList<Double>();
            }
            this.xValues.add(valX);
            this.yValues.add(valY);
        }

        public void addScatterSeries(String propertyName) {
            NumberDataSet orthoValues = NumberDataSetImpl.create(this.yValues);
            NumberDataSet xAxisValues = NumberDataSetImpl.create(this.xValues);
            this.sdX = SeriesDefinitionImpl.create();
            XYSeriesCanvas.this.xAxisPrimary.getSeriesDefinitions().add((Object)this.sdX);
            if (this.scatterSeriesY == null) {
                this.sdY = SeriesDefinitionImpl.create();
                this.scatterSeriesY = (ScatterSeries)ScatterSeriesImpl.create();
                this.seriesX = SeriesImpl.create();
            }
            this.seriesX.getLabel().getCaption().setColor(XYSeriesCanvas.this.foreGround);
            this.seriesX.getLabel().getOutline().setColor(XYSeriesCanvas.this.foreGround);
            this.seriesX.setDataSet((DataSet)xAxisValues);
            this.sdX.getSeries().add((Object)this.seriesX);
            this.scatterSeriesY.setDataSet((DataSet)orthoValues);
            this.setColorDefs(propertyName);
            ColorDefinition color = ColorDefinitionImpl.create((int)colorDefault[XYSeriesCanvas.this.chartIndex][0], (int)colorDefault[XYSeriesCanvas.this.chartIndex][1], (int)colorDefault[XYSeriesCanvas.this.chartIndex][2]);
            this.sdY.getSeriesPalette().update((Fill)color);
            this.sdY.getSeries().add((Object)this.scatterSeriesY);
            XYSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
        }

        public void hide() {
            this.scatterSeriesY.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.scatterSeriesY.setVisible(true);
            this.visible = true;
        }

        public void setColorDefs(String propertyName) {
            this.scatterSeriesY.setSeriesIdentifier((Object)propertyName);
            if (propertyName.indexOf(XYSeriesCanvas.DEFAULT_KEY_PREFIX) >= 0) {
                this.scatterSeriesY.setPaletteLineColor(true);
                Marker marker = MarkerImpl.create((MarkerType)MarkerType.CIRCLE_LITERAL, (int)2);
                this.scatterSeriesY.getMarkers().clear();
                this.scatterSeriesY.getMarkers().add((Object)marker);
                this.scatterSeriesY.getLineAttributes().setVisible(false);
            } else {
                this.scatterSeriesY.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
                this.scatterSeriesY.getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
                this.scatterSeriesY.getLineAttributes().setVisible(true);
                if (!this.scatterSeriesY.getMarkers().isEmpty()) {
                    Marker marker = (Marker)this.scatterSeriesY.getMarkers().get(0);
                    marker.setVisible(false);
                }
            }
        }

        public int getDataSize() {
            return this.yValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public List<Double> getyValues() {
            return this.yValues;
        }

        public void setyValues(List<Double> yValues) {
            this.yValues = yValues;
        }

        public void setScatterSeries(ScatterSeries lineSeries) {
            this.scatterSeriesY = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        String property;

        public DisplayableProperty(String property, boolean visibility) {
            super(property, 2);
            this.property = null;
            this.property = property;
            this.setChecked(visibility);
        }

        public String getText() {
            return this.property;
        }

        public void run() {
            DataXYSeries series = XYSeriesCanvas.this.dataSeriesMap.get(this.property);
            series.toggleVisible();
            XYSeriesCanvas.this.dataSeriesMap.put(this.property, series);
            this.setChecked(series.isVisible());
            XYSeriesCanvas.this.draw();
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!XYSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!XYSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleLegend();
            }
            XYSeriesCanvas.this.draw();
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(XYSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (XYSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleLegend();
            }
            XYSeriesCanvas.this.draw();
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(XYSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (XYSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleAxisScale();
            }
            XYSeriesCanvas.this.draw();
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!XYSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!XYSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleAxisScale();
            }
            XYSeriesCanvas.this.draw();
        }
    }
}

