/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis.shp;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.EndianUtils;
import org.eclipse.stem.gis.shp.ShpHeader;
import org.eclipse.stem.gis.shp.ShpInputStream;
import org.eclipse.stem.gis.shp.ShpRecord;

public class ShxInputStream
extends ShpInputStream {
    private static final List<Integer> offsets = new ArrayList<Integer>();

    public ShxInputStream(InputStream is) throws IOException {
        super(is);
        this.readIndexFile();
    }

    private void readIndexFile() throws IOException {
        try {
            while (true) {
                int offset = EndianUtils.swapInteger((int)this.readInt());
                EndianUtils.swapInteger((int)this.readInt());
                offsets.add(offset);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public int getOffsetForRecord(int recordNumber) {
        return offsets.get(recordNumber + 1);
    }

    @Override
    public ShpRecord readNextRecord() throws IOException {
        return null;
    }

    @Override
    public ShpHeader getHeader() {
        return super.getHeader();
    }

    public static void main(String[] args) throws IOException {
        try (ShxInputStream is = null;){
            is = new ShxInputStream(new BufferedInputStream(new FileInputStream(new File("data/global.shx"))));
            System.out.println(is.getHeader());
        }
    }
}

