/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.builder;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.stem.model.codegen.xtext.ExpressionsClassGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.StringInputStream;

public class ExpressionMethodGenerator {
    private GenClass labelGenClass;
    private GenClass modelGenClass;
    private GenClass labelValueGenClass;
    private IProject project;

    public ExpressionMethodGenerator(IProject project, GenClass modelGenClass, GenClass labelGenClass, GenClass labelValueGenClass) {
        this.modelGenClass = modelGenClass;
        this.labelGenClass = labelGenClass;
        this.labelValueGenClass = labelValueGenClass;
        this.project = project;
    }

    private ExpressionsClassGenerator getExpressionMethodGenerator() {
        return new ExpressionsClassGenerator();
    }

    public void generate(List<XtextResource> resources) {
        ExpressionsClassGenerator gen = this.getExpressionMethodGenerator();
        gen.setModelGenClass(this.modelGenClass);
        gen.setLabelGenClass(this.labelGenClass);
        gen.setLabelValueGenClass(this.labelValueGenClass);
        ImportManager importManager = new ImportManager(this.modelGenClass.getGenPackage().getClassPackageName());
        importManager.addMasterImport(this.modelGenClass.getGenPackage().getClassPackageName(), this.getExpressionsClassFileName());
        gen.setImportManager(importManager);
        InMemoryFileSystemAccess fsa = new InMemoryFileSystemAccess();
        gen.doGenerate(resources, (IFileSystemAccess)fsa);
        String body = ((CharSequence)fsa.getTextFiles().values().iterator().next()).toString();
        this.writeToFile(body);
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void writeToFile(String body) {
        IPath expressionsFilePath = this.getExpressionsFilePath();
        IFile expressionsFile = this.project.getWorkspace().getRoot().getFile(expressionsFilePath);
        StringInputStream is = new StringInputStream(body);
        try {
            if (expressionsFile.exists()) {
                expressionsFile.setContents((InputStream)is, true, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                expressionsFile.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        try {
            this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    protected String getExpressionsClassFileName() {
        return String.valueOf(this.modelGenClass.getName()) + "Expressions.java";
    }

    protected IPath getExpressionsFilePath() {
        StringBuilder path = new StringBuilder();
        path.append("src/");
        path.append(this.modelGenClass.getGenPackage().getClassPackageName().replace('.', '/'));
        path.append("/");
        path.append(this.getExpressionsClassFileName());
        return this.project.getFullPath().append(path.toString());
    }
}

