/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stem.model.ctdl.ctdl.AbsoluteCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.BooleanLiteral;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentTransitionDefinitions;
import org.eclipse.stem.model.ctdl.ctdl.DefStatement;
import org.eclipse.stem.model.ctdl.ctdl.Div;
import org.eclipse.stem.model.ctdl.ctdl.Evaluation;
import org.eclipse.stem.model.ctdl.ctdl.Expression;
import org.eclipse.stem.model.ctdl.ctdl.ExternalFunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.FunctionCall;
import org.eclipse.stem.model.ctdl.ctdl.FunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.GlobalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.LocalVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.MetamodelResource;
import org.eclipse.stem.model.ctdl.ctdl.Minus;
import org.eclipse.stem.model.ctdl.ctdl.ModelParamReference;
import org.eclipse.stem.model.ctdl.ctdl.Multi;
import org.eclipse.stem.model.ctdl.ctdl.NumberLiteral;
import org.eclipse.stem.model.ctdl.ctdl.Plus;
import org.eclipse.stem.model.ctdl.ctdl.PrimaryExpression;
import org.eclipse.stem.model.ctdl.ctdl.RelativeCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.ScopedVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.StringLiteral;
import org.eclipse.stem.model.ctdl.ctdl.TransitionBlock;
import org.eclipse.stem.model.ctdl.ctdl.VariableReference;
import org.eclipse.stem.model.ctdl.functions.FunctionArgumentReference;
import org.eclipse.stem.model.ctdl.functions.JavaMethodArgument;
import org.eclipse.stem.model.ctdl.functions.SystemArgumentReference;
import org.eclipse.stem.model.ctdl.serializer.ITypeSerializer;
import org.eclipse.stem.model.ctdl.serializer.TypeSerializerFactory;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtend.lib.Property;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CTDLGenerator
implements IGenerator {
    @Property
    private GenClass _modelGenClass;
    @Property
    private GenClass _labelValueGenClass;

    public String addImport(String fqn) {
        boolean _tripleNotEquals;
        GenClass _modelGenClass = this.getModelGenClass();
        boolean bl = _tripleNotEquals = _modelGenClass != null;
        if (_tripleNotEquals) {
            return this.getModelGenClass().getGenModel().getImportedName(fqn);
        }
        return fqn;
    }

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), CompartmentTransitionDefinitions.class));
        MetamodelResource mm = ctd.getMetamodel();
        Transition trans = mm.getTransition();
        String _name = trans.getSource().getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = trans.getTarget().getName();
        String fname = String.valueOf(_plus) + _name_1;
        fsa.generateFile(fname, this.compile((Notifier)resource));
    }

    protected CharSequence _compile(Resource r) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile((Notifier)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)r.getAllContents()), TransitionBlock.class)));
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compile(TransitionBlock t) {
        String labelClass;
        EObject _eContainer = t.eContainer();
        CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)_eContainer;
        String modelClass = ctd.getMetamodel().getModel().getClass_().getInstanceTypeName();
        if (modelClass == null) {
            modelClass = ctd.getMetamodel().getModel().getClass_().getName();
        }
        labelClass = (labelClass = ctd.getMetamodel().getModel().getCompartments().getClass_().getInstanceTypeName()) == null ? ctd.getMetamodel().getModel().getCompartments().getClass_().getName() : this.addImport(labelClass);
        String labelValueClass = ctd.getMetamodel().getModel().getCompartments().getValueClass().getInstanceTypeName();
        labelValueClass = labelValueClass == null ? ctd.getMetamodel().getModel().getCompartments().getValueClass().getName() : this.addImport(labelValueClass);
        Transition transition = ctd.getMetamodel().getTransition();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("protected double ");
        String _name = transition.getSource().getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = transition.getTarget().getName();
        String _plus_1 = String.valueOf(_plus) + _name_1;
        _builder.append(_plus_1);
        _builder.append(" (");
        _builder.newLineIfNotEmpty();
        _builder.append("double t, ");
        _builder.newLine();
        _builder.append("long timeDelta, ");
        _builder.newLine();
        String _addImport = this.addImport("org.eclipse.stem.core.model.STEMTime");
        _builder.append(_addImport);
        _builder.append(" time,");
        _builder.newLineIfNotEmpty();
        _builder.append(modelClass);
        _builder.append(" model,");
        _builder.newLineIfNotEmpty();
        _builder.append(labelClass);
        _builder.append(" label,");
        _builder.newLineIfNotEmpty();
        _builder.append(labelValueClass);
        _builder.append(" labelValue,");
        _builder.newLineIfNotEmpty();
        String _addImport_1 = this.addImport("org.eclipse.stem.core.graph.Node");
        _builder.append(_addImport_1);
        _builder.append(" node) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        EList<DefStatement> _statements = t.getBlock().getStatements();
        for (DefStatement s : _statements) {
            CharSequence _compile = this.compile((Notifier)s);
            _builder.append((Object)_compile, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _compile_1 = this.compile((Notifier)t.getBlock().getRet());
        _builder.append((Object)_compile_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _compile(DefStatement d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("double ");
        String _varname = d.getVarname();
        _builder.append(_varname);
        _builder.append("=");
        CharSequence _compile = this.compile((Notifier)d.getExpr());
        _builder.append((Object)_compile);
        _builder.append(";");
        return _builder;
    }

    protected CharSequence _compile(Evaluation e) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(e.getExpression(), Double.TYPE);
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compile(PrimaryExpression pe, Class<?> expectedType) {
        String neg = "";
        boolean _isNegate = pe.isNegate();
        if (_isNegate) {
            neg = "-";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        _builder.append(neg);
        CharSequence _compile = this.compile(pe.getExp(), expectedType);
        _builder.append((Object)_compile);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _compile(Plus p, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _compile = this.compile(p.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("+");
        CharSequence _compile_1 = this.compile(p.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compile(Minus m, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        CharSequence _compile = this.compile(m.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("-");
        CharSequence _compile_1 = this.compile(m.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compile(Multi m, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(m.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("*");
        CharSequence _compile_1 = this.compile(m.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        return _builder;
    }

    protected CharSequence _compile(Div d, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(d.getLeft(), Double.TYPE);
        _builder.append((Object)_compile);
        _builder.append("/");
        CharSequence _compile_1 = this.compile(d.getRight(), Double.TYPE);
        _builder.append((Object)_compile_1);
        return _builder;
    }

    protected CharSequence _compileReference(GlobalVariableReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rf.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _compileReference(LocalVariableReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = rf.getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _compileReference(AbsoluteCompartmentValueReference rf, Class<?> expectedType) {
        ITypeSerializer serializer = TypeSerializerFactory.getSerializer(rf, expectedType, this.getLabelValueGenClass());
        if (serializer != null) {
            return serializer.serialize();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("labelValue.get");
        String _firstUpper = StringExtensions.toFirstUpper((String)rf.getObj().getName());
        _builder.append(_firstUpper);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _compileReference(RelativeCompartmentValueReference rf, Class<?> expectedType) {
        ITypeSerializer serializer = TypeSerializerFactory.getSerializer(rf, expectedType, this.getLabelValueGenClass());
        if (serializer != null) {
            return serializer.serialize();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("labelValue.get");
        String _firstUpper = StringExtensions.toFirstUpper((String)rf.getObj().getName());
        _builder.append(_firstUpper);
        _builder.append("()/labelValue.getPopulationCount()");
        return _builder;
    }

    protected CharSequence _compileReference(ModelParamReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _firstUpper = StringExtensions.toFirstUpper((String)rf.getObj().getName());
        _builder.append(_firstUpper);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _compile(VariableReference rf, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compileReference = this.compileReference(rf.getRef(), expectedType);
        _builder.append((Object)_compileReference);
        return _builder;
    }

    protected CharSequence _compile(NumberLiteral nl, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        double _value = nl.getValue();
        _builder.append((Object)_value);
        return _builder;
    }

    protected CharSequence _compile(StringLiteral sl, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _value = sl.getValue();
        _builder.append(_value);
        _builder.append("\"");
        return _builder;
    }

    protected CharSequence _compile(BooleanLiteral bl, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isValue = bl.isValue();
        _builder.append((Object)_isValue);
        return _builder;
    }

    protected CharSequence _compileArgument(SystemArgumentReference arg, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _mapsFrom = arg.getMapsFrom();
        _builder.append(_mapsFrom);
        return _builder;
    }

    protected CharSequence _compileArgument(FunctionArgumentReference arg, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile((Expression)fc.getArgs().get(arg.getArgIndex()), arg.getJavaType());
        _builder.append((Object)_compile);
        return _builder;
    }

    protected CharSequence _compileFunction(ExternalFunctionReference fcr, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _addImport = this.addImport(fcr.getFunc().getClassName());
        _builder.append(_addImport);
        _builder.append(".");
        String _methodName = fcr.getFunc().getMethodName();
        _builder.append(_methodName);
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        EList _javaMethodArguments = fcr.getFunc().getJavaMethodArguments();
        for (JavaMethodArgument arg : _javaMethodArguments) {
            boolean _notEquals;
            _builder.append("\t\t");
            JavaMethodArgument _head = (JavaMethodArgument)IterableExtensions.head((Iterable)fcr.getFunc().getJavaMethodArguments());
            boolean bl = _notEquals = !Objects.equal((Object)arg, (Object)_head);
            if (_notEquals) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            CharSequence _compileArgument = this.compileArgument(arg, fc);
            _builder.append((Object)_compileArgument, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compileFunction(FunctionReference fcr, FunctionCall fc) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = fcr.getName();
        _builder.append(_name);
        _builder.append("(");
        EList<Expression> _args = fc.getArgs();
        for (Expression e : _args) {
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
            Expression _head = (Expression)IterableExtensions.head(fc.getArgs());
            boolean _equals = Objects.equal((Object)e, (Object)_head);
            if (_equals) {
                CharSequence _compile = this.compile((Notifier)e);
                _builder.append((Object)_compile);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append(",");
                CharSequence _compile_1 = this.compile((Notifier)e);
                _builder.append((Object)_compile_1);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t\t");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence _compile(FunctionCall fc, Class<?> expectedType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compileFunction = this.compileFunction(fc.getRef(), fc);
        _builder.append((Object)_compileFunction);
        return _builder;
    }

    public CharSequence compile(Notifier e) {
        if (e instanceof Evaluation) {
            return this._compile((Evaluation)e);
        }
        if (e instanceof DefStatement) {
            return this._compile((DefStatement)e);
        }
        if (e instanceof TransitionBlock) {
            return this._compile((TransitionBlock)e);
        }
        if (e instanceof Resource) {
            return this._compile((Resource)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public CharSequence compile(Expression bl, Class<?> expectedType) {
        if (bl instanceof BooleanLiteral) {
            return this._compile((BooleanLiteral)bl, expectedType);
        }
        if (bl instanceof Div) {
            return this._compile((Div)bl, expectedType);
        }
        if (bl instanceof FunctionCall) {
            return this._compile((FunctionCall)bl, expectedType);
        }
        if (bl instanceof Minus) {
            return this._compile((Minus)bl, expectedType);
        }
        if (bl instanceof Multi) {
            return this._compile((Multi)bl, expectedType);
        }
        if (bl instanceof NumberLiteral) {
            return this._compile((NumberLiteral)bl, expectedType);
        }
        if (bl instanceof Plus) {
            return this._compile((Plus)bl, expectedType);
        }
        if (bl instanceof PrimaryExpression) {
            return this._compile((PrimaryExpression)bl, expectedType);
        }
        if (bl instanceof StringLiteral) {
            return this._compile((StringLiteral)bl, expectedType);
        }
        if (bl instanceof VariableReference) {
            return this._compile((VariableReference)bl, expectedType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(bl, expectedType).toString());
    }

    public CharSequence compileReference(ScopedVariableReference rf, Class<?> expectedType) {
        if (rf instanceof AbsoluteCompartmentValueReference) {
            return this._compileReference((AbsoluteCompartmentValueReference)rf, expectedType);
        }
        if (rf instanceof RelativeCompartmentValueReference) {
            return this._compileReference((RelativeCompartmentValueReference)rf, expectedType);
        }
        if (rf instanceof GlobalVariableReference) {
            return this._compileReference((GlobalVariableReference)rf, expectedType);
        }
        if (rf instanceof LocalVariableReference) {
            return this._compileReference((LocalVariableReference)rf, expectedType);
        }
        if (rf instanceof ModelParamReference) {
            return this._compileReference((ModelParamReference)rf, expectedType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rf, expectedType).toString());
    }

    public CharSequence compileArgument(JavaMethodArgument arg, FunctionCall fc) {
        if (arg instanceof FunctionArgumentReference) {
            return this._compileArgument((FunctionArgumentReference)arg, fc);
        }
        if (arg instanceof SystemArgumentReference) {
            return this._compileArgument((SystemArgumentReference)arg, fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(arg, fc).toString());
    }

    public CharSequence compileFunction(FunctionReference fcr, FunctionCall fc) {
        if (fcr instanceof ExternalFunctionReference) {
            return this._compileFunction((ExternalFunctionReference)fcr, fc);
        }
        if (fcr != null) {
            return this._compileFunction(fcr, fc);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fcr, fc).toString());
    }

    @Pure
    public GenClass getModelGenClass() {
        return this._modelGenClass;
    }

    public void setModelGenClass(GenClass modelGenClass) {
        this._modelGenClass = modelGenClass;
    }

    @Pure
    public GenClass getLabelValueGenClass() {
        return this._labelValueGenClass;
    }

    public void setLabelValueGenClass(GenClass labelValueGenClass) {
        this._labelValueGenClass = labelValueGenClass;
    }
}

