/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.sequencer.impl;

import java.text.SimpleDateFormat;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.sequencer.SequencerPackage;

public abstract class SequencerImpl
extends IdentifiableImpl
implements Sequencer {
    protected STEMTime startTime = ModelFactory.eINSTANCE.createSTEMTime();
    protected STEMTime endTime;
    protected STEMTime currentTime;
    protected static final long TIME_DELTA_EDEFAULT = 0L;
    protected long timeDelta = 0L;
    protected static final long DURATION_EDEFAULT = -1L;
    protected long duration = -1L;
    protected static final boolean TIME_TO_STOP_EDEFAULT = false;
    protected static final double WORK_COMPLETE_EDEFAULT = 0.0;
    protected double workComplete = 0.0;
    protected static final int WORK_INCREMENT_EDEFAULT = 0;
    protected static final int CYCLE_EDEFAULT = 0;
    protected int cycle = 0;

    protected SequencerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SequencerPackage.Literals.SEQUENCER;
    }

    @Override
    public STEMTime getStartTime() {
        return (STEMTime)EcoreUtil.copy((EObject)this.startTime);
    }

    public NotificationChain basicSetStartTime(STEMTime newStartTime, NotificationChain msgs) {
        STEMTime oldStartTime = this.startTime;
        this.startTime = newStartTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldStartTime, (Object)newStartTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStartTime(STEMTime newStartTime) {
        if (newStartTime != this.startTime) {
            NotificationChain msgs = null;
            if (this.startTime != null) {
                msgs = ((InternalEObject)this.startTime).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newStartTime != null) {
                msgs = ((InternalEObject)newStartTime).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetStartTime(newStartTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newStartTime, (Object)newStartTime));
        }
    }

    @Override
    public STEMTime getEndTime() {
        return this.endTime;
    }

    public NotificationChain basicSetEndTime(STEMTime newEndTime, NotificationChain msgs) {
        STEMTime oldEndTime = this.endTime;
        this.endTime = newEndTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldEndTime, (Object)newEndTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setEndTime(STEMTime newEndTime) {
        if (newEndTime != this.endTime) {
            NotificationChain msgs = null;
            if (this.endTime != null) {
                msgs = ((InternalEObject)this.endTime).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newEndTime != null) {
                msgs = ((InternalEObject)newEndTime).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetEndTime(newEndTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newEndTime, (Object)newEndTime));
        }
    }

    @Override
    public STEMTime getCurrentTime() {
        if (this.currentTime == null) {
            this.setCurrentTime((STEMTime)EcoreUtil.copy((EObject)this.getStartTime()));
        }
        return this.currentTime;
    }

    public NotificationChain basicSetCurrentTime(STEMTime newCurrentTime, NotificationChain msgs) {
        STEMTime oldCurrentTime = this.currentTime;
        this.currentTime = newCurrentTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCurrentTime, (Object)newCurrentTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCurrentTime(STEMTime newCurrentTime) {
        if (newCurrentTime != this.currentTime) {
            NotificationChain msgs = null;
            if (this.currentTime != null) {
                msgs = ((InternalEObject)this.currentTime).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newCurrentTime != null) {
                msgs = ((InternalEObject)newCurrentTime).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetCurrentTime(newCurrentTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newCurrentTime, (Object)newCurrentTime));
        }
    }

    @Override
    public STEMTime getNextTime() {
        this.setCycle(this.getCycle() + 1);
        return null;
    }

    @Override
    public long getTimeDelta() {
        return this.timeDelta;
    }

    @Override
    public long getDuration() {
        if (this.duration == -1L && this.getStartTime() != null && this.getEndTime() != null) {
            this.setDuration(this.getEndTime().getTime().getTime() - this.getStartTime().getTime().getTime());
        }
        return this.duration;
    }

    @Override
    public void setDuration(long newDuration) {
        long oldDuration = this.duration;
        this.duration = newDuration;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldDuration, this.duration));
        }
    }

    @Override
    public boolean isTimeToStop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getWorkComplete() {
        return this.workComplete;
    }

    @Override
    public void setWorkComplete(double newWorkComplete) {
        double oldWorkComplete = this.workComplete;
        this.workComplete = newWorkComplete;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldWorkComplete, this.workComplete));
        }
    }

    @Override
    public int getWorkIncrement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCycle() {
        return this.cycle;
    }

    @Override
    public void setCycle(int newCycle) {
        int oldCycle = this.cycle;
        this.cycle = newCycle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldCycle, this.cycle));
        }
    }

    @Override
    public void reset() {
        this.setCurrentTime((STEMTime)EcoreUtil.copy((EObject)this.getStartTime()));
        this.setWorkComplete(0.0);
        this.setCycle(0);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetStartTime(null, msgs);
            }
            case 4: {
                return this.basicSetEndTime(null, msgs);
            }
            case 5: {
                return this.basicSetCurrentTime(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getStartTime();
            }
            case 4: {
                return this.getEndTime();
            }
            case 5: {
                return this.getCurrentTime();
            }
            case 6: {
                return this.getNextTime();
            }
            case 7: {
                return this.getTimeDelta();
            }
            case 8: {
                return this.getDuration();
            }
            case 9: {
                return this.isTimeToStop();
            }
            case 10: {
                return this.getWorkComplete();
            }
            case 11: {
                return this.getWorkIncrement();
            }
            case 12: {
                return this.getCycle();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setStartTime((STEMTime)newValue);
                return;
            }
            case 4: {
                this.setEndTime((STEMTime)newValue);
                return;
            }
            case 5: {
                this.setCurrentTime((STEMTime)newValue);
                return;
            }
            case 8: {
                this.setDuration((Long)newValue);
                return;
            }
            case 10: {
                this.setWorkComplete((Double)newValue);
                return;
            }
            case 12: {
                this.setCycle((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setStartTime(null);
                return;
            }
            case 4: {
                this.setEndTime(null);
                return;
            }
            case 5: {
                this.setCurrentTime(null);
                return;
            }
            case 8: {
                this.setDuration(-1L);
                return;
            }
            case 10: {
                this.setWorkComplete(0.0);
                return;
            }
            case 12: {
                this.setCycle(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.startTime != null;
            }
            case 4: {
                return this.endTime != null;
            }
            case 5: {
                return this.currentTime != null;
            }
            case 6: {
                return this.getNextTime() != null;
            }
            case 7: {
                return this.timeDelta != 0L;
            }
            case 8: {
                return this.duration != -1L;
            }
            case 9: {
                return this.isTimeToStop();
            }
            case 10: {
                return this.workComplete != 0.0;
            }
            case 11: {
                return this.getWorkIncrement() != 0;
            }
            case 12: {
                return this.cycle != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy");
        StringBuffer result = new StringBuffer();
        result.append(dateFormat.format(this.startTime.getTime()));
        if (this.getEndTime() != null) {
            result.append(" to ");
            result.append(dateFormat.format(this.getEndTime().getTime()));
        }
        if (this.getCurrentTime() != null) {
            result.append(", current=");
            result.append(dateFormat.format(this.getCurrentTime().getTime()));
        }
        result.append(" (timeDelta: ");
        result.append(this.getTimeDelta());
        result.append(" (");
        long days = this.getTimeDelta() / STEMTime.Units.DAY.getMilliseconds();
        result.append(days);
        result.append(days == 1L ? " day)" : " days)");
        result.append(", duration: ");
        result.append(this.getDuration());
        result.append(", workComplete: ");
        result.append(this.getWorkComplete());
        result.append(')');
        return result.toString();
    }
}

