/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class DelegatingAnnotationPreference
extends AnnotationPreference {
    private AnnotationType fType;
    private AnnotationPreferenceLookup fLookup;
    private Set<Object> fCache = new HashSet<Object>();

    public DelegatingAnnotationPreference(AnnotationType type, AnnotationPreferenceLookup lookup) {
        this.fType = type;
        this.fLookup = lookup;
    }

    private boolean isCached(Object attribute) {
        return this.fCache.contains(attribute);
    }

    private void markCached(Object attribute) {
        this.fCache.add(attribute);
    }

    private AnnotationPreference getDefiningPreference(Object attribute) {
        AnnotationPreference p = this.fLookup.getAnnotationPreferenceFragment(this.fType.getType());
        if (p != null && p.hasValue(attribute)) {
            return p;
        }
        String[] superTypes = this.fType.getSuperTypes();
        int i = 0;
        while (i < superTypes.length) {
            p = this.fLookup.getAnnotationPreferenceFragment(superTypes[i]);
            if (p != null && p.hasValue(attribute)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    private Object getAttributeValue(Object attribute) {
        if (!this.isCached(attribute)) {
            AnnotationPreference preference = this.getDefiningPreference(attribute);
            if (preference != null) {
                this.setValue(attribute, preference.getValue(attribute));
            }
            this.markCached(attribute);
        }
        return super.getValue(attribute);
    }

    private boolean getBooleanAttributeValue(Object attribute) {
        Object value = this.getAttributeValue(attribute);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public Object getAnnotationType() {
        return this.fType.getType();
    }

    public boolean contributesToHeader() {
        return this.getBooleanAttributeValue(HEADER_VALUE);
    }

    public IAnnotationImageProvider getAnnotationImageProvider() {
        if (!this.isCached(IMAGE_PROVIDER)) {
            AnnotationPreference preference = this.getDefiningPreference(IMAGE_PROVIDER);
            if (preference != null) {
                this.fAnnotationImageProvider = preference.fAnnotationImageProvider;
                this.fAnnotationImageProviderAttribute = preference.fAnnotationImageProviderAttribute;
                this.fConfigurationElement = preference.fConfigurationElement;
            }
            this.markCached(IMAGE_PROVIDER);
        }
        return super.getAnnotationImageProvider();
    }

    public String getColorPreferenceKey() {
        return (String)this.getAttributeValue(COLOR_PREFERENCE_KEY);
    }

    public RGB getColorPreferenceValue() {
        return (RGB)this.getAttributeValue(COLOR_PREFERENCE_VALUE);
    }

    public String getHighlightPreferenceKey() {
        return (String)this.getAttributeValue(HIGHLIGHT_PREFERENCE_KEY);
    }

    public boolean getHighlightPreferenceValue() {
        return this.getBooleanAttributeValue(HIGHLIGHT_PREFERENCE_VALUE);
    }

    public ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.getAttributeValue(IMAGE_DESCRIPTOR);
    }

    public ImageDescriptor getQuickFixImageDescriptor() {
        return (ImageDescriptor)this.getAttributeValue(QUICK_FIX_IMAGE_DESCRIPTOR);
    }

    public String getIsGoToNextNavigationTargetKey() {
        return (String)this.getAttributeValue(IS_GO_TO_NEXT_TARGET_KEY);
    }

    public String getIsGoToPreviousNavigationTargetKey() {
        return (String)this.getAttributeValue(IS_GO_TO_PREVIOUS_TARGET_KEY);
    }

    public String getOverviewRulerPreferenceKey() {
        return (String)this.getAttributeValue(OVERVIEW_RULER_PREFERENCE_KEY);
    }

    public boolean getOverviewRulerPreferenceValue() {
        return this.getBooleanAttributeValue(OVERVIEW_RULER_PREFERENCE_VALUE);
    }

    public String getPreferenceLabel() {
        return (String)this.getAttributeValue(PREFERENCE_LABEL);
    }

    public int getPresentationLayer() {
        Object value = this.getAttributeValue(PRESENTATION_LAYER);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public String getShowInNextPrevDropdownToolbarActionKey() {
        return (String)this.getAttributeValue(SHOW_IN_NAVIGATION_DROPDOWN_KEY);
    }

    public String getSymbolicImageName() {
        return (String)this.getAttributeValue(SYMBOLIC_IMAGE_NAME);
    }

    public String getTextPreferenceKey() {
        return (String)this.getAttributeValue(TEXT_PREFERENCE_KEY);
    }

    public boolean getTextPreferenceValue() {
        return this.getBooleanAttributeValue(TEXT_PREFERENCE_VALUE);
    }

    public String getVerticalRulerPreferenceKey() {
        return (String)this.getAttributeValue(VERTICAL_RULER_PREFERENCE_KEY);
    }

    public boolean getVerticalRulerPreferenceValue() {
        return this.getBooleanAttributeValue(VERTICAL_RULER_PREFERENCE_VALUE);
    }

    public boolean isGoToNextNavigationTarget() {
        return this.getBooleanAttributeValue(IS_GO_TO_NEXT_TARGET_VALUE);
    }

    public boolean isGoToPreviousNavigationTarget() {
        return this.getBooleanAttributeValue(IS_GO_TO_PREVIOUS_TARGET_VALUE);
    }

    public boolean isShowInNextPrevDropdownToolbarAction() {
        return this.getBooleanAttributeValue(SHOW_IN_NAVIGATION_DROPDOWN_VALUE);
    }

    public String getTextStylePreferenceKey() {
        return (String)this.getAttributeValue(TEXT_STYLE_PREFERENCE_KEY);
    }

    public String getTextStyleValue() {
        return (String)this.getAttributeValue(TEXT_STYLE_PREFERENCE_VALUE);
    }

    public Object getValue(Object attribute) {
        return this.getAttributeValue(attribute);
    }
}

