/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.csv.logger;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class DelimetedWriter
extends BufferedWriter {
    public static char[] DEFAULT_NEW_LINE_DELIMETER = new char[]{'\n'};
    public static char[] DEFAULT_ENTRY_DELIMETER = new char[]{','};
    public static int DEFAULT_BUFFER_SIZE = 1024;
    private String entryDelimeter;
    private String newLineDelimeter;
    private boolean newLine = true;

    public DelimetedWriter(int bufSize, Writer writer) throws IOException {
        this(new String(DEFAULT_ENTRY_DELIMETER), new String(DEFAULT_NEW_LINE_DELIMETER), bufSize, writer);
    }

    public DelimetedWriter(String entryDelimeter, int bufSize, Writer writer) throws IOException {
        this(entryDelimeter, new String(DEFAULT_NEW_LINE_DELIMETER), bufSize, writer);
    }

    public DelimetedWriter(String entryDelimeter, String newLineDelimeter, int bufSize, Writer writer) throws IOException {
        super(writer, bufSize);
        this.entryDelimeter = entryDelimeter;
        this.newLineDelimeter = newLineDelimeter;
    }

    public boolean isEmptyLine() {
        return this.newLine;
    }

    public void writeEntry(int val) throws IOException {
        this.writeEntry(String.valueOf(val));
    }

    public void writeEntry(double val) throws IOException {
        this.writeEntry(String.valueOf(val));
    }

    public void writeEntry(float val) throws IOException {
        this.writeEntry(String.valueOf(val));
    }

    public void writeEntry(byte[] val) throws IOException {
        this.writeEntry(new String(val));
    }

    public void writeEntry(byte val) throws IOException {
        this.writeEntry(String.valueOf(val));
    }

    public void writeEntry(long val) throws IOException {
        this.writeEntry(String.valueOf(val));
    }

    public void writeEntry(char val) throws IOException {
        this.writeEntry(String.valueOf(val));
    }

    public void writeEntry(Object val) throws IOException {
        String str = null;
        str = val != null ? val.toString() : "";
        if (this.newLine) {
            this.newLine = false;
        } else {
            super.write(this.entryDelimeter);
        }
        super.write(str);
    }

    @Override
    public void newLine() throws IOException {
        this.write(this.newLineDelimeter);
        this.newLine = true;
    }

    public void writeLine(List<?> vals) throws IOException {
        if (vals != null) {
            if (!this.isEmptyLine()) {
                this.newLine();
            }
            for (Object val : vals) {
                this.writeEntry(val);
            }
            this.newLine();
        }
    }
}

