/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.veterinary.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.veterinary.SimpleVeterinaryDisease;
import org.eclipse.stem.diseasemodels.veterinary.SimpleVeterinaryDiseaseLabel;
import org.eclipse.stem.diseasemodels.veterinary.SimpleVeterinaryDiseaseLabelValue;
import org.eclipse.stem.diseasemodels.veterinary.VeterinaryFactory;
import org.eclipse.stem.diseasemodels.veterinary.VeterinaryPackage;
import org.eclipse.stem.diseasemodels.veterinary.impl.SimpleVeterinaryDiseaseExpressions;

public class SimpleVeterinaryDiseaseImpl
extends SIImpl
implements SimpleVeterinaryDisease {
    protected static final double ENVIRONMENTAL_TRANSMISSION_RATE_EDEFAULT = 0.0;
    protected double environmentalTransmissionRate = 0.0;

    protected EClass eStaticClass() {
        return VeterinaryPackage.Literals.SIMPLE_VETERINARY_DISEASE;
    }

    @Override
    public double getEnvironmentalTransmissionRate() {
        return this.environmentalTransmissionRate;
    }

    @Override
    public void setEnvironmentalTransmissionRate(double newEnvironmentalTransmissionRate) {
        this.environmentalTransmissionRate = newEnvironmentalTransmissionRate;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 23: {
                return this.getEnvironmentalTransmissionRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 23: {
                this.setEnvironmentalTransmissionRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 23: {
                this.setEnvironmentalTransmissionRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 23: {
                return this.environmentalTransmissionRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (environmentalTransmissionRate: ");
        result.append(this.environmentalTransmissionRate);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime currentTime, double continuousTime, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(currentTime, continuousTime, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel label, long timeDelta) {
        super.doStochasticProcess(label, timeDelta);
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        SimpleVeterinaryDiseaseExpressions deltaCalculator = new SimpleVeterinaryDiseaseExpressions();
        int _i = 0;
        while (_i < labels.size()) {
            SimpleVeterinaryDiseaseLabel diseaseLabel = (SimpleVeterinaryDiseaseLabel)labels.get(_i);
            SimpleVeterinaryDiseaseLabelValue currentDiseaseState = (SimpleVeterinaryDiseaseLabelValue)diseaseLabel.getProbeValue();
            SimpleVeterinaryDiseaseLabelValue deltaValue = (SimpleVeterinaryDiseaseLabelValue)diseaseLabel.getDeltaValue();
            deltaValue.reset();
            deltaCalculator.calculate(t, timeDelta, time, this, diseaseLabel, currentDiseaseState, diseaseLabel.getNode(), deltaValue);
            deltaValue.scale((double)timeDelta / (double)this.getTimePeriod());
            this.computeAdditionalDeltasAndExchanges((IntegrationLabel)diseaseLabel, time, t, timeDelta);
            ++_i;
        }
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        SimpleVeterinaryDiseaseLabel label = VeterinaryFactory.eINSTANCE.createSimpleVeterinaryDiseaseLabel();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return VeterinaryFactory.eINSTANCE.createSimpleVeterinaryDiseaseLabelValue();
    }
}

