/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.graph.provider.StaticNodeLabelItemProvider;
import org.eclipse.stem.definitions.edges.provider.DefinitionsEditPlugin;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.geography.names.GeographicNames;

public class PopulationLabelItemProvider
extends StaticNodeLabelItemProvider {
    public PopulationLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPopulationIdentifierPropertyDescriptor(object);
            this.addCurrentPopulationValuePropertyDescriptor(object);
            this.addPopulatedAreaPropertyDescriptor(object);
            this.addValidYearPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPopulationIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_populationIdentifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_populationIdentifier_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__POPULATION_IDENTIFIER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCurrentPopulationValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_currentPopulationValue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_currentPopulationValue_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__CURRENT_POPULATION_VALUE, false, false, false, null, null, null));
    }

    protected void addPopulatedAreaPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_populatedArea_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_populatedArea_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__POPULATED_AREA, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    protected void addValidYearPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PopulationLabel_validYear_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PopulationLabel_validYear_feature", "_UI_PopulationLabel_type"), (EStructuralFeature)LabelsPackage.Literals.POPULATION_LABEL__VALID_YEAR, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public String getText(Object object) {
        StringBuilder sb = new StringBuilder();
        PopulationLabel populationLabel = (PopulationLabel)object;
        sb.append(GeographicNames.getName((URI)populationLabel.getURIOfIdentifiableToBeLabeled()));
        sb.append(", \"");
        sb.append(populationLabel.getPopulationIdentifier());
        sb.append("\" population: ");
        sb.append((int)populationLabel.getCurrentPopulationValue().getCount());
        sb.append(populationLabel.getPopulatedArea() == 0.0 ? "" : " (" + populationLabel.getPopulatedArea() + " km^2)");
        return sb.toString();
    }

    public String getTextGen(Object object) {
        URI labelValue = ((PopulationLabel)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_PopulationLabel_type") : String.valueOf(this.getString("_UI_PopulationLabel_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PopulationLabel.class)) {
            case 7: 
            case 9: 
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return DefinitionsEditPlugin.INSTANCE;
    }
}

