/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.TraversalData;

public class ConstraintAwareTypeArgumentCollector
extends DeclaratorTypeArgumentCollector {
    private final TypesFactory factory;

    public ConstraintAwareTypeArgumentCollector(TypesFactory factory) {
        this.factory = factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, TraversalData data) {
        JvmType type = reference.getType();
        if (type == null || type.eIsProxy() || !data.getVisited().add(type)) return Boolean.FALSE;
        if (!(type instanceof JvmTypeParameter)) return this.doVisitParameterizedTypeReference(reference, type, data);
        if (data.getTypeParameterMapping().containsKey(type)) return Boolean.FALSE;
        EList constraints = ((JvmTypeParameter)type).getConstraints();
        ArrayList upperBounds = Lists.newArrayList();
        for (JvmTypeConstraint constraint : constraints) {
            if (!(constraint instanceof JvmUpperBound)) continue;
            this.visit(constraint.getTypeReference(), data);
            upperBounds.add((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)constraint.getTypeReference()));
        }
        if (upperBounds.size() > 1) {
            JvmMultiTypeReference boundReference = this.factory.createJvmMultiTypeReference();
            boundReference.getReferences().addAll((Collection)upperBounds);
            data.getTypeParameterMapping().put((JvmTypeParameter)type, (JvmTypeReference)boundReference);
            return Boolean.FALSE;
        } else {
            if (upperBounds.size() != 1) return Boolean.FALSE;
            data.getTypeParameterMapping().put((JvmTypeParameter)type, (JvmTypeReference)upperBounds.get(0));
        }
        return Boolean.FALSE;
    }
}

