/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.quickfix.AbstractIssueResolutionProviderAdapter;
import org.eclipse.xtext.ui.editor.quickfix.ILanguageResourceHelper;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.util.IssueUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerResolutionGenerator
extends AbstractIssueResolutionProviderAdapter
implements IMarkerResolutionGenerator2 {
    @Inject
    @Named(value="languageName")
    private String editorId;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private ILanguageResourceHelper languageResourceHelper;
    @Inject
    private IWorkbench workbench;

    public IssueUtil getIssueUtil() {
        return this.issueUtil;
    }

    public void setIssueUtil(IssueUtil issueUtil) {
        this.issueUtil = issueUtil;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public String getEditorId() {
        return this.editorId;
    }

    public boolean hasResolutions(IMarker marker) {
        return this.getResolutionProvider().hasResolutionFor(this.getIssueUtil().getCode(marker));
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IMarkerResolution[] emptyResult = new IMarkerResolution[]{};
        try {
            if (!marker.isSubtypeOf("org.eclipse.xtext.ui.check")) {
                return emptyResult;
            }
        }
        catch (CoreException e) {
            return emptyResult;
        }
        if (!this.languageResourceHelper.isLanguageResource(marker.getResource())) {
            return emptyResult;
        }
        XtextEditor editor = this.getEditor(marker.getResource());
        if (editor == null) {
            return emptyResult;
        }
        IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (annotationModel != null && !this.isMarkerStillValid(marker, annotationModel)) {
            return emptyResult;
        }
        Iterable<IssueResolution> resolutions = this.getResolutions(this.getIssueUtil().createIssue(marker), editor.getDocument());
        return this.getAdaptedResolutions(Lists.newArrayList(resolutions));
    }

    public boolean isMarkerStillValid(final IMarker marker, IAnnotationModel annotationModel) {
        Iterator iterator = annotationModel.getAnnotationIterator();
        return Iterators.any((Iterator)iterator, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return false;
                }
                return this.referringToSameIssue(annotation, marker);
            }

            private boolean referringToSameIssue(Annotation annotation, IMarker marker2) {
                return MarkerResolutionGenerator.this.getIssueUtil().refersToSameIssue(marker2, annotation);
            }
        });
    }

    public IXtextDocument getXtextDocument(IResource resource) {
        IXtextDocument result = XtextDocumentUtil.get(resource);
        if (result == null) {
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                IFile file = ResourceUtil.getFile((Object)resource);
                FileEditorInput input = new FileEditorInput(file);
                page.openEditor((IEditorInput)input, this.getEditorId());
            }
            catch (PartInitException e) {
                return null;
            }
        }
        return XtextDocumentUtil.get(resource);
    }

    public XtextEditor getEditor(IResource resource) {
        XtextEditor result = this.findEditor(resource);
        if (result == null) {
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                IFile file = ResourceUtil.getFile((Object)resource);
                FileEditorInput input = new FileEditorInput(file);
                result = (XtextEditor)page.openEditor((IEditorInput)input, this.getEditorId());
            }
            catch (PartInitException e) {
                return null;
            }
        }
        return result;
    }

    public XtextEditor findEditor(IResource resource) {
        IWorkbenchPage activePage;
        IEditorPart editor;
        if (resource instanceof IFile && (editor = (activePage = this.workbench.getActiveWorkbenchWindow().getActivePage()).findEditor((IEditorInput)new FileEditorInput((IFile)resource))) instanceof XtextEditor) {
            return (XtextEditor)editor;
        }
        return null;
    }

    protected IMarkerResolution[] getAdaptedResolutions(List<IssueResolution> resolutions) {
        IMarkerResolution[] result = new IMarkerResolution[resolutions.size()];
        int i = 0;
        while (i < resolutions.size()) {
            result[i] = new ResolutionAdapter(resolutions.get(i));
            ++i;
        }
        return result;
    }

    public class ResolutionAdapter
    implements IMarkerResolution2 {
        private final IssueResolution resolution;

        public ResolutionAdapter(IssueResolution resolution) {
            this.resolution = resolution;
        }

        public String getLabel() {
            return this.resolution.getLabel();
        }

        public void run(IMarker marker) {
            this.resolution.apply();
        }

        public String getDescription() {
            return this.resolution.getDescription();
        }

        public Image getImage() {
            return MarkerResolutionGenerator.this.getImage(this.resolution);
        }
    }
}

