/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.stochastic.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.TransformationDecorator;
import org.eclipse.stem.core.solver.SolverException;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.core.trigger.TriggerList;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelImpl;
import org.eclipse.stem.populationmodels.standard.AgeGroup;
import org.eclipse.stem.populationmodels.standard.AgingPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.solvers.stochastic.StandardStochastic;
import org.eclipse.stem.solvers.stochastic.StochasticPackage;
import org.eclipse.stem.solvers.stochastic.impl.StochasticImpl;

public class StandardStochasticImpl
extends StochasticImpl
implements StandardStochastic {
    protected static final long SEED_EDEFAULT = 17L;
    protected long seed = 17L;
    BinomialDistributionUtil binomialDist;

    public boolean step(STEMTime time, long timeDelta, int cycle) throws SolverException {
        this.partitioner.setNumProcesses(1);
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            EList allLabels = decorator.getLabelsToUpdate();
            Iterator currentStateLabelIter = allLabels.iterator();
            while (currentStateLabelIter.hasNext()) {
                if (decorator instanceof IntegrationDecorator) {
                    IntegrationLabel iLabel = (IntegrationLabel)currentStateLabelIter.next();
                    ((IntegrationLabelValue)iLabel.getCurrentValue()).prepareCycle();
                    iLabel.getProbeValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    continue;
                }
                currentStateLabelIter.next();
            }
        }
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (!(decorator instanceof Trigger) && !(decorator instanceof TriggerList) && !(decorator instanceof TransformationDecorator)) continue;
            decorator.updateLabels(time, timeDelta, cycle);
        }
        BasicEList iDecorators = new BasicEList();
        BasicEList transDecorators = new BasicEList();
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (decorator.isEnabled() && decorator instanceof IntegrationDecorator) {
                iDecorators.add((Object)((IntegrationDecorator)decorator));
            }
            if (!(decorator instanceof TransformationDecorator)) continue;
            transDecorators.add((Object)((TransformationDecorator)decorator));
        }
        double t = cycle;
        if (this.binomialDist == null) {
            this.binomialDist = new BinomialDistributionUtil(this.getSeed());
        }
        for (IntegrationDecorator imodel : iDecorators) {
            imodel.calculateDeltas(time, t, timeDelta, this.partitioner.partitionDecoratorLabels((Decorator)imodel, 0));
        }
        for (IntegrationDecorator imodel : iDecorators) {
            imodel.applyExternalDeltas(time, t, timeDelta, this.partitioner.partitionDecoratorLabels((Decorator)imodel, 0));
        }
        for (IntegrationDecorator imodel : iDecorators) {
            for (DynamicLabel lab : this.partitioner.partitionDecoratorLabels((Decorator)imodel, 0)) {
                double sourceCount;
                double transitionCount;
                ExchangeType type;
                IntegrationLabel iLab = (IntegrationLabel)lab;
                IntegrationLabelValue iLabCurrentValue = (IntegrationLabelValue)lab.getCurrentValue();
                IntegrationLabelValue iLabDeltaVal = iLab.getDeltaValue();
                block17: for (Exchange departureExchange : iLabDeltaVal.getDepartures()) {
                    type = departureExchange.getType();
                    transitionCount = departureExchange.getCount();
                    sourceCount = 0.0;
                    double targetCount = 0.0;
                    switch (type.getValue()) {
                        case 4: {
                            int iTransitionCount;
                            sourceCount = iLabCurrentValue.eGetDouble(departureExchange.getSource().getFeatureID());
                            targetCount = iLabCurrentValue.eGetDouble(departureExchange.getTarget().getFeatureID());
                            if (!(sourceCount > 0.0)) break;
                            double draw = transitionCount / sourceCount;
                            if (draw > 1.0) {
                                draw = 1.0;
                            }
                            if (sourceCount < (double)(iTransitionCount = this.binomialDist.fastPickFromBinomialDist(draw, (int)Math.round(sourceCount)))) {
                                iTransitionCount = (int)Math.floor(sourceCount);
                            }
                            iLabCurrentValue.eSetDouble(departureExchange.getSource().getFeatureID(), sourceCount - (double)iTransitionCount);
                            iLabCurrentValue.eSetDouble(departureExchange.getTarget().getFeatureID(), targetCount + (double)iTransitionCount);
                            if (departureExchange.getForIncidence() == null) break;
                            for (EAttribute ea : departureExchange.getForIncidence()) {
                                iLabCurrentValue.eSetDouble(ea.getFeatureID(), iLabCurrentValue.eGetDouble(ea.getFeatureID()) + (double)iTransitionCount);
                            }
                            continue block17;
                        }
                        case 1: {
                            int sum = 0;
                            for (Label otherLabel : departureExchange.getOtherLabels()) {
                                IntegrationLabelValue otherLabelValue;
                                if (otherLabel instanceof DiseaseModelLabel) {
                                    otherLabelValue = (IntegrationLabelValue)otherLabel.getCurrentValue();
                                    for (EAttribute ea : otherLabelValue.eClass().getEAllAttributes()) {
                                        int deathsCount;
                                        if (DiseaseModelImpl.isIncidence((EAttribute)ea) || DiseaseModelImpl.isDiseaseDeaths((EAttribute)ea) || !ea.isChangeable() || !((sourceCount = otherLabelValue.eGetDouble(ea.getFeatureID())) > 0.0)) continue;
                                        double weightedTransition = transitionCount * (sourceCount / otherLabelValue.eGetDouble(org.eclipse.stem.diseasemodels.standard.StandardPackage.eINSTANCE.getDiseaseModelLabelValue_PopulationCount().getFeatureID()));
                                        double draw = weightedTransition / sourceCount;
                                        if (draw > 1.0) {
                                            draw = 1.0;
                                        }
                                        if ((double)(deathsCount = this.binomialDist.fastPickFromBinomialDist(draw, (int)Math.round(sourceCount))) > sourceCount) {
                                            deathsCount = (int)Math.floor(sourceCount);
                                        }
                                        otherLabelValue.eSetDouble(ea.getFeatureID(), sourceCount - (double)deathsCount);
                                        this.copyCurrentToNext((IntegrationLabel)otherLabel);
                                        sum += deathsCount;
                                    }
                                    iLabCurrentValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), iLabCurrentValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) - (double)sum);
                                    iLabCurrentValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Deaths().getFeatureID(), (double)sum);
                                    continue;
                                }
                                otherLabelValue = (IntegrationLabelValue)otherLabel.getCurrentValue();
                                sourceCount = iLabCurrentValue.eGetDouble(departureExchange.getSource().getFeatureID());
                                if (!(sourceCount > 0.0)) continue;
                                int actualDiseaseDeaths = this.binomialDist.fastPickFromBinomialDist(transitionCount / sourceCount, (int)Math.round(sourceCount));
                                if (iLabCurrentValue.eGetDouble(departureExchange.getSource().getFeatureID()) < (double)actualDiseaseDeaths) {
                                    actualDiseaseDeaths = (int)Math.floor(iLabCurrentValue.eGetDouble(departureExchange.getSource().getFeatureID()));
                                }
                                iLabCurrentValue.eSetDouble(departureExchange.getSource().getFeatureID(), iLabCurrentValue.eGetDouble(departureExchange.getSource().getFeatureID()) - (double)actualDiseaseDeaths);
                                iLabCurrentValue.eSetDouble(departureExchange.getTarget().getFeatureID(), iLabCurrentValue.eGetDouble(departureExchange.getTarget().getFeatureID()) + (double)actualDiseaseDeaths);
                                otherLabelValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), otherLabelValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) - (double)actualDiseaseDeaths);
                                this.copyCurrentToNext((IntegrationLabel)otherLabel);
                            }
                            continue block17;
                        }
                    }
                }
                block21: for (Exchange arrivalsExchange : iLabDeltaVal.getArrivals()) {
                    type = arrivalsExchange.getType();
                    transitionCount = arrivalsExchange.getCount();
                    sourceCount = 0.0;
                    switch (type.getValue()) {
                        case 1: {
                            Iterator group;
                            for (Label otherLabel : arrivalsExchange.getOtherLabels()) {
                                EAttribute birthsCompartment = arrivalsExchange.getTarget();
                                IntegrationLabelValue otherLabelValue = (IntegrationLabelValue)otherLabel.getCurrentValue();
                                if (imodel instanceof AgingPopulationModel) {
                                    HashMap<String, AgeGroup> groups = new HashMap<String, AgeGroup>();
                                    AgingPopulationModel apm = (AgingPopulationModel)imodel;
                                    for (PopulationGroup group2 : apm.getPopulationGroups()) {
                                        groups.put(group2.getIdentifier(), (AgeGroup)group2);
                                    }
                                    for (NodeLabel lab2 : iLab.getNode().getLabels()) {
                                        StandardPopulationModelLabel label;
                                        if (!(lab2 instanceof StandardPopulationModelLabel) || (group = (AgeGroup)groups.get((label = (StandardPopulationModelLabel)lab2).getPopulationIdentifier())) == null) continue;
                                        double count = ((StandardPopulationModelLabelValue)label.getCurrentValue()).getCount();
                                        sourceCount += count;
                                    }
                                } else {
                                    sourceCount = iLabCurrentValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID());
                                }
                                if (!(sourceCount > 0.0)) continue;
                                double draw = transitionCount / sourceCount;
                                if (draw > 1.0) {
                                    draw = 1.0;
                                }
                                int birthsCount = this.binomialDist.fastPickFromBinomialDist(draw, (int)Math.round(sourceCount));
                                otherLabelValue.eSetDouble(birthsCompartment.getFeatureID(), otherLabelValue.eGetDouble(birthsCompartment.getFeatureID()) + (double)birthsCount);
                                iLabCurrentValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), iLabCurrentValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) + (double)birthsCount);
                                iLabCurrentValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Births().getFeatureID(), (double)birthsCount);
                                this.copyCurrentToNext((IntegrationLabel)otherLabel);
                            }
                            continue block21;
                        }
                        case 2: {
                            Iterator group;
                            IntegrationLabel otherPopulationModelLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(0);
                            IntegrationLabelValue otherPopulationModelLabelValue = (IntegrationLabelValue)otherPopulationModelLabel.getCurrentValue();
                            sourceCount = otherPopulationModelLabelValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID());
                            int sumMigration = 0;
                            if (!(sourceCount > 0.0)) break;
                            int i = 1;
                            while (i < arrivalsExchange.getOtherLabels().size() - 1) {
                                IntegrationLabel otherDiseaseModelLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(i);
                                IntegrationLabelValue otherDiseaseModelLabelValue = (IntegrationLabelValue)otherDiseaseModelLabel.getCurrentValue();
                                IntegrationLabel thisDiseaseModelLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(i + 1);
                                IntegrationLabelValue thisDiseaseModelLabelValue = (IntegrationLabelValue)thisDiseaseModelLabel.getCurrentValue();
                                group = otherDiseaseModelLabelValue.eClass().getEAllAttributes().iterator();
                                while (group.hasNext()) {
                                    EAttribute ea = (EAttribute)group.next();
                                    if (DiseaseModelImpl.isIncidence((EAttribute)ea) || DiseaseModelImpl.isDiseaseDeaths((EAttribute)ea) || !ea.isChangeable() || !((sourceCount = otherDiseaseModelLabelValue.eGetDouble(ea.getFeatureID())) > 0.0)) continue;
                                    double weightedTransition = transitionCount * (sourceCount / otherDiseaseModelLabelValue.eGetDouble(org.eclipse.stem.diseasemodels.standard.StandardPackage.eINSTANCE.getDiseaseModelLabelValue_PopulationCount().getFeatureID()));
                                    double draw = weightedTransition / sourceCount;
                                    if (draw > 1.0) {
                                        draw = 1.0;
                                    }
                                    int iMigrationCount = this.binomialDist.fastPickFromBinomialDist(draw, (int)Math.round(sourceCount));
                                    if (otherDiseaseModelLabelValue.eGetDouble(ea.getFeatureID()) < (double)iMigrationCount) {
                                        iMigrationCount = (int)Math.floor(otherDiseaseModelLabelValue.eGetDouble(ea.getFeatureID()));
                                    }
                                    otherDiseaseModelLabelValue.eSetDouble(ea.getFeatureID(), otherDiseaseModelLabelValue.eGetDouble(ea.getFeatureID()) - (double)iMigrationCount);
                                    thisDiseaseModelLabelValue.eSetDouble(ea.getFeatureID(), thisDiseaseModelLabelValue.eGetDouble(ea.getFeatureID()) + (double)iMigrationCount);
                                    sumMigration += iMigrationCount;
                                }
                                this.copyCurrentToNext(otherDiseaseModelLabel);
                                i += 2;
                            }
                            iLabCurrentValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), iLabCurrentValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) + (double)sumMigration);
                            IntegrationLabel targetPopulationLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(0);
                            IntegrationLabelValue targetPopulationLabelValue = (IntegrationLabelValue)targetPopulationLabel.getCurrentValue();
                            targetPopulationLabelValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), targetPopulationLabelValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) - (double)sumMigration);
                            this.copyCurrentToNext(targetPopulationLabel);
                            break;
                        }
                        case 3: {
                            IntegrationLabel otherPopulationModelLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(0);
                            IntegrationLabelValue otherPopulationModelLabelValue = (IntegrationLabelValue)otherPopulationModelLabel.getCurrentValue();
                            sourceCount = otherPopulationModelLabelValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID());
                            int sumAging = 0;
                            if (!(sourceCount > 0.0)) break;
                            int i = 1;
                            while (i < arrivalsExchange.getOtherLabels().size() - 1) {
                                IntegrationLabel otherDiseaseModelLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(i);
                                IntegrationLabelValue otherDiseaseModelLabelValue = (IntegrationLabelValue)otherDiseaseModelLabel.getCurrentValue();
                                IntegrationLabel thisDiseaseModelLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(i + 1);
                                IntegrationLabelValue thisDiseaseModelLabelValue = (IntegrationLabelValue)thisDiseaseModelLabel.getCurrentValue();
                                for (EAttribute ea : otherDiseaseModelLabelValue.eClass().getEAllAttributes()) {
                                    int iAgingCount;
                                    if (DiseaseModelImpl.isIncidence((EAttribute)ea) || DiseaseModelImpl.isDiseaseDeaths((EAttribute)ea) || !ea.isChangeable() || !((sourceCount = otherDiseaseModelLabelValue.eGetDouble(ea.getFeatureID())) > 0.0)) continue;
                                    double weightedTransition = transitionCount * (sourceCount / otherDiseaseModelLabelValue.eGetDouble(org.eclipse.stem.diseasemodels.standard.StandardPackage.eINSTANCE.getDiseaseModelLabelValue_PopulationCount().getFeatureID()));
                                    double draw = weightedTransition / sourceCount;
                                    if (draw > 1.0) {
                                        draw = 1.0;
                                    }
                                    if ((double)(iAgingCount = this.binomialDist.fastPickFromBinomialDist(draw, (int)Math.round(sourceCount))) > sourceCount) {
                                        iAgingCount = (int)Math.floor(sourceCount);
                                    }
                                    otherDiseaseModelLabelValue.eSetDouble(ea.getFeatureID(), otherDiseaseModelLabelValue.eGetDouble(ea.getFeatureID()) - (double)iAgingCount);
                                    thisDiseaseModelLabelValue.eSetDouble(ea.getFeatureID(), thisDiseaseModelLabelValue.eGetDouble(ea.getFeatureID()) + (double)iAgingCount);
                                    sumAging += iAgingCount;
                                }
                                this.copyCurrentToNext(otherDiseaseModelLabel);
                                this.copyCurrentToNext(thisDiseaseModelLabel);
                                i += 2;
                            }
                            iLabCurrentValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), iLabCurrentValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) + (double)sumAging);
                            IntegrationLabel targetPopulationLabel = (IntegrationLabel)arrivalsExchange.getOtherLabels().get(0);
                            IntegrationLabelValue targetPopulationLabelValue = (IntegrationLabelValue)targetPopulationLabel.getCurrentValue();
                            targetPopulationLabelValue.eSetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID(), targetPopulationLabelValue.eGetDouble(StandardPackage.eINSTANCE.getStandardPopulationModelLabelValue_Count().getFeatureID()) - (double)sumAging);
                            this.copyCurrentToNext(targetPopulationLabel);
                            break;
                        }
                    }
                }
                this.copyCurrentToNext(iLab);
            }
        }
        return true;
    }

    private void copyCurrentToNext(IntegrationLabel iLabel) {
        IntegrationLabelValue iLabelValueCurrent = (IntegrationLabelValue)iLabel.getCurrentValue();
        IntegrationLabelValue iLabelValueNext = (IntegrationLabelValue)iLabel.getNextValue();
        iLabelValueNext.set(iLabelValueCurrent);
    }

    @Override
    protected EClass eStaticClass() {
        return StochasticPackage.Literals.STANDARD_STOCHASTIC;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long newSeed) {
        long oldSeed = this.seed;
        this.seed = newSeed;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldSeed, this.seed));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getSeed();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setSeed((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setSeed(17L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.seed != 17L;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (seed: ");
        result.append(this.seed);
        result.append(')');
        return result.toString();
    }

    public void reset() {
        this.binomialDist = new BinomialDistributionUtil(this.getSeed());
        this.setInitialized(false);
    }
}

