/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.interventions.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.graphgenerators.Activator;
import org.eclipse.stem.graphgenerators.impl.GraphGeneratorImpl;
import org.eclipse.stem.interventions.InterventionsFactory;
import org.eclipse.stem.interventions.InterventionsPackage;
import org.eclipse.stem.interventions.PeriodicControlGraphGenerator;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardPeriodicInterventionLabelValue;

public class PeriodicControlGraphGeneratorImpl
extends GraphGeneratorImpl
implements PeriodicControlGraphGenerator {
    public static final String CONTROL_GRAPH_TYPE = "Control Graph";
    public static final String INTERVENTION_LABEL_URI_SEGMENT = "intervention";
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;
    protected static final long PERIOD_EDEFAULT = 86400000L;
    protected long period = 86400000L;
    protected static final boolean USE_VACCINATIONS_EDEFAULT = true;
    protected boolean useVaccinations = true;
    protected static final boolean FRACTION_EDEFAULT = true;
    protected boolean fraction = true;

    public Graph getGraph() {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        try {
            DublinCore dc = graph.getDublinCore();
            dc.populate();
            dc.setTitle(CONTROL_GRAPH_TYPE);
            dc.setSource(this.getClass().getSimpleName());
            Calendar c = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
            String valid = formatter.format(c.getTime());
            dc.setValid(valid);
            String file = this.getDataPath();
            BufferedReader fw = new BufferedReader(new FileReader(file));
            String locationStr = fw.readLine();
            String[] locations = locationStr.split(",");
            int i = 0;
            while (i < locations.length) {
                StandardInterventionLabel scl = InterventionsFactory.eINSTANCE.createStandardInterventionLabel();
                scl.setURIOfIdentifiableToBeLabeled(RegionImpl.createRegionNodeURI((String)locations[i]));
                scl.setPopulationIdentifier(this.getPopulationIdentifier());
                StandardPeriodicInterventionLabelValue currentValue = InterventionsFactory.eINSTANCE.createStandardPeriodicInterventionLabelValue();
                currentValue.setPeriod(this.getPeriod());
                currentValue.setAbsolute(!this.isFraction());
                scl.setCurrentValue(currentValue);
                scl.setURI(STEMURI.createURI((String)("intervention/" + locations[i])));
                graph.putNodeLabel((NodeLabel)scl);
                ++i;
            }
            String dataLine = fw.readLine();
            while (dataLine != null) {
                String[] sData = dataLine.split(",");
                double[] data = new double[sData.length];
                int i2 = 0;
                while (i2 < data.length) {
                    data[i2] = Double.parseDouble(sData[i2]);
                    URI intURI = STEMURI.createURI((String)("intervention/" + locations[i2]));
                    StandardInterventionLabel sil = (StandardInterventionLabel)graph.getNodeLabel(intURI);
                    StandardPeriodicInterventionLabelValue spilv = (StandardPeriodicInterventionLabelValue)sil.getCurrentValue();
                    if (this.isUseVaccinations()) {
                        spilv.getVaccinations().add((Object)data[i2]);
                    } else {
                        spilv.getIsolations().add((Object)data[i2]);
                    }
                    ++i2;
                }
                dataLine = fw.readLine();
            }
            fw.close();
            assert (graph.sane());
        }
        catch (IOException ioe) {
            Activator.logError((String)ioe.getMessage(), (Throwable)ioe);
        }
        return graph;
    }

    protected EClass eStaticClass() {
        return InterventionsPackage.Literals.PERIODIC_CONTROL_GRAPH_GENERATOR;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        String oldPopulationIdentifier = this.populationIdentifier;
        this.populationIdentifier = newPopulationIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldPopulationIdentifier, (Object)this.populationIdentifier));
        }
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String newDataPath) {
        String oldDataPath = this.dataPath;
        this.dataPath = newDataPath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDataPath, (Object)this.dataPath));
        }
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public void setPeriod(long newPeriod) {
        long oldPeriod = this.period;
        this.period = newPeriod;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldPeriod, this.period));
        }
    }

    @Override
    public boolean isUseVaccinations() {
        return this.useVaccinations;
    }

    @Override
    public void setUseVaccinations(boolean newUseVaccinations) {
        boolean oldUseVaccinations = this.useVaccinations;
        this.useVaccinations = newUseVaccinations;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldUseVaccinations, this.useVaccinations));
        }
    }

    @Override
    public boolean isFraction() {
        return this.fraction;
    }

    @Override
    public void setFraction(boolean newFraction) {
        boolean oldFraction = this.fraction;
        this.fraction = newFraction;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldFraction, this.fraction));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getPopulationIdentifier();
            }
            case 4: {
                return this.getDataPath();
            }
            case 5: {
                return this.getPeriod();
            }
            case 6: {
                return this.isUseVaccinations();
            }
            case 7: {
                return this.isFraction();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 4: {
                this.setDataPath((String)newValue);
                return;
            }
            case 5: {
                this.setPeriod((Long)newValue);
                return;
            }
            case 6: {
                this.setUseVaccinations((Boolean)newValue);
                return;
            }
            case 7: {
                this.setFraction((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 4: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
            case 5: {
                this.setPeriod(86400000L);
                return;
            }
            case 6: {
                this.setUseVaccinations(true);
                return;
            }
            case 7: {
                this.setFraction(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 4: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
            case 5: {
                return this.period != 86400000L;
            }
            case 6: {
                return !this.useVaccinations;
            }
            case 7: {
                return !this.fraction;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (populationIdentifier: ");
        result.append(this.populationIdentifier);
        result.append(", dataPath: ");
        result.append(this.dataPath);
        result.append(", period: ");
        result.append(this.period);
        result.append(", useVaccinations: ");
        result.append(this.useVaccinations);
        result.append(", fraction: ");
        result.append(this.fraction);
        result.append(')');
        return result.toString();
    }
}

