/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class EditProfileContainerPage
extends EditDirectoryContainerPage {
    private Button fUseDefaultConfig;
    private Label fConfigLabel;
    private Combo fConfigLocation;
    private Button fConfigBrowse;
    private Button fConfigVariables;
    private static final String SETTINGS_CONFIG_1 = "config1";
    private static final String SETTINGS_CONFIG_2 = "config2";
    private static final String SETTINGS_CONFIG_3 = "config3";

    public EditProfileContainerPage() {
        super(null, "EditProfileContainer");
    }

    public EditProfileContainerPage(ITargetLocation container) {
        super(container, "EditProfileContainer");
    }

    protected String getDefaultTitle() {
        if (this.fContainer != null) {
            return Messages.EditProfileContainerPage_3;
        }
        return Messages.AddProfileContainerPage_0;
    }

    protected String getDefaultMessage() {
        return Messages.AddProfileContainerPage_1;
    }

    protected void createLocationArea(Composite parent) {
        super.createLocationArea(parent);
        Composite configComp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        if (this.fContainer == null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.location_add_installation_wizard");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.location_edit_installation_wizard");
        }
        this.fUseDefaultConfig = new Button(configComp, 131104);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUseDefaultConfig.setLayoutData((Object)gd);
        this.fUseDefaultConfig.setFont(parent.getFont());
        this.fUseDefaultConfig.setText(Messages.AddProfileContainerPage_2);
        this.fUseDefaultConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileContainerPage.this.updateConfigEnablement();
                EditProfileContainerPage.this.containerChanged(0L);
            }
        });
        this.fConfigLabel = SWTFactory.createLabel(configComp, Messages.AddProfileContainerPage_3, 1);
        ((GridData)this.fConfigLabel.getLayoutData()).horizontalIndent = 15;
        this.fConfigLocation = SWTFactory.createCombo(configComp, 2048, 1, this.getConfigComboItems());
        this.fConfigLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isItem = false;
                String[] items = EditProfileContainerPage.this.fConfigLocation.getItems();
                int i = 0;
                while (i < items.length) {
                    if (EditProfileContainerPage.this.fConfigLocation.getText().equals(items[i])) {
                        isItem = true;
                        break;
                    }
                    ++i;
                }
                EditProfileContainerPage.this.containerChanged(isItem ? 0 : 200);
            }
        });
        Composite buttonComp = SWTFactory.createComposite(configComp, 2, 2, 2, 0, 0);
        gd = (GridData)buttonComp.getLayoutData();
        gd.horizontalAlignment = 131072;
        this.fConfigBrowse = SWTFactory.createPushButton(buttonComp, Messages.AddProfileContainerPage_4, null);
        this.fConfigBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(EditProfileContainerPage.this.getShell());
                dialog.setFilterPath(EditProfileContainerPage.this.fConfigLocation.getText());
                dialog.setText(Messages.AddProfileContainerPage_5);
                dialog.setMessage(Messages.AddProfileContainerPage_6);
                String result = dialog.open();
                if (result != null) {
                    EditProfileContainerPage.this.fConfigLocation.setText(result);
                }
            }
        });
        this.fConfigVariables = SWTFactory.createPushButton(buttonComp, Messages.EditProfileContainerPage_1, null);
        this.fConfigVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(EditProfileContainerPage.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    EditProfileContainerPage.this.fConfigLocation.setText(String.valueOf(EditProfileContainerPage.this.fConfigLocation.getText()) + variable);
                }
            }
        });
    }

    private String[] getConfigComboItems() {
        ArrayList<String> previousConfigs = new ArrayList<String>(4);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String location = settings.get(SETTINGS_CONFIG_1);
            if (location != null) {
                previousConfigs.add(location);
            }
            if ((location = settings.get(SETTINGS_CONFIG_2)) != null) {
                previousConfigs.add(location);
            }
            if ((location = settings.get(SETTINGS_CONFIG_3)) != null) {
                previousConfigs.add(location);
            }
        }
        previousConfigs.add("${eclipse_home}/configuration");
        return previousConfigs.toArray(new String[previousConfigs.size()]);
    }

    public void storeSettings() {
        super.storeSettings();
        if (this.fConfigLocation.isEnabled()) {
            String newLocation = this.fConfigLocation.getText().trim();
            String[] items = this.fConfigLocation.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(newLocation)) {
                    return;
                }
                ++i;
            }
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                String location = settings.get(SETTINGS_CONFIG_2);
                if (location != null) {
                    settings.put(SETTINGS_CONFIG_3, location);
                }
                if ((location = settings.get(SETTINGS_CONFIG_1)) != null) {
                    settings.put(SETTINGS_CONFIG_2, location);
                }
                settings.put(SETTINGS_CONFIG_1, newLocation);
            }
        }
    }

    protected void initializeInputFields(ITargetLocation container) {
        if (container instanceof ProfileBundleContainer) {
            String configLocation = ((ProfileBundleContainer)container).getConfigurationLocation();
            if (configLocation == null) {
                this.fUseDefaultConfig.setSelection(true);
                this.fConfigLocation.setText("");
            } else {
                this.fUseDefaultConfig.setSelection(false);
                this.fConfigLocation.setText(configLocation);
            }
        } else {
            this.fUseDefaultConfig.setSelection(true);
            this.fConfigLocation.setText("");
        }
        this.updateConfigEnablement();
        super.initializeInputFields(container);
    }

    private void updateConfigEnablement() {
        boolean isDefault = this.fUseDefaultConfig.getSelection();
        this.fConfigLabel.setEnabled(!isDefault);
        this.fConfigLocation.setEnabled(!isDefault);
        this.fConfigBrowse.setEnabled(!isDefault);
        this.fConfigVariables.setEnabled(!isDefault);
    }

    protected boolean validateInput() {
        boolean valid = super.validateInput();
        if (valid && this.fConfigLocation.isEnabled()) {
            if (this.fConfigLocation.getText().trim().length() == 0) {
                this.setMessage(Messages.EditProfileContainerPage_2);
                return false;
            }
            String locationString = null;
            try {
                locationString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fConfigLocation.getText().trim());
            }
            catch (CoreException e) {
                this.setMessage(e.getMessage(), 2);
                return true;
            }
            File configLocation = new File(locationString);
            if (!configLocation.isDirectory()) {
                this.setMessage(Messages.AddProfileContainerPage_8, 2);
            } else {
                this.setMessage(this.getDefaultMessage());
            }
        }
        return valid;
    }

    protected ITargetLocation createContainer(ITargetLocation previous) throws CoreException {
        return EditProfileContainerPage.getTargetPlatformService().newProfileLocation(this.fInstallLocation.getText(), this.fConfigLocation.isEnabled() ? this.fConfigLocation.getText() : null);
    }
}

