/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.ExportTargetJob;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.TargetDefinitionExportWizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class TargetDefinitionExportWizard
extends Wizard
implements IExportWizard {
    private TargetDefinitionExportWizardPage fPage = null;
    private ITargetDefinition fTarget;
    static final String SETTINGS_SECTION = "exportTargetDefinitionWizard";

    public TargetDefinitionExportWizard() {
        this(null);
    }

    public TargetDefinitionExportWizard(ITargetDefinition target) {
        this.fTarget = target;
        if (this.fTarget == null) {
            try {
                ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
                if (service != null) {
                    this.fTarget = service.getWorkspaceTargetDefinition();
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEUIMessages.ExportActiveTargetDefinition);
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_TARGET_WIZ);
    }

    public void addPages() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION);
        }
        this.setDialogSettings(settings);
        this.fPage = new TargetDefinitionExportWizardPage(this.fTarget);
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.storeSettings();
        String destDir = this.fPage.getDestinationDirectory();
        boolean clearDestDir = this.fPage.isClearDestinationDirectory();
        File file = new File(destDir);
        ExportTargetJob job = new ExportTargetJob(this.fTarget, file.toURI(), clearDestDir);
        job.schedule(200L);
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

