/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JREBlock {
    private AbstractLauncherTab fTab;
    private Listener fListener = new Listener();
    private Button fJavawButton;
    private Button fJavaButton;
    private Button fJreButton;
    private Button fEeButton;
    private Button fJrePrefButton;
    private Button fEePrefButton;
    private Combo fJreCombo;
    private Combo fEeCombo;
    private Text fBootstrap;

    public JREBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.MainTab_jreSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createJavaExecutableSection((Composite)group);
        this.createJRESection((Composite)group);
        this.createBootstrapEntriesSection((Composite)group);
    }

    protected void createJRESection(Composite parent) {
        this.fEeButton = new Button(parent, 16);
        this.fEeButton.setText(PDEUIMessages.BasicLauncherTab_ee);
        this.fEeButton.addSelectionListener((SelectionListener)this.fListener);
        this.fEeCombo = SWTFactory.createCombo(parent, 12, 1, null);
        this.fEeCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fEePrefButton = new Button(parent, 8);
        this.fEePrefButton.setText(PDEUIMessages.BasicLauncherTab_environments);
        this.fEePrefButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String currentEE = this.parseEESelection(this.fEeCombo.getText());
            if (SWTFactory.showPreferencePage(this.fTab.getControl().getShell(), "org.eclipse.jdt.debug.ui.jreProfiles", null) == 0 && !this.fTab.getControl().isDisposed()) {
                this.setEECombo();
                this.setEEComboSelection(currentEE);
            }
        }));
        this.fEePrefButton.setLayoutData((Object)new GridData(4, 4, false, false));
        SWTUtil.setButtonDimensionHint(this.fEePrefButton);
        this.fJreButton = new Button(parent, 16);
        this.fJreButton.setText(PDEUIMessages.BasicLauncherTab_jre);
        this.fJreButton.addSelectionListener((SelectionListener)this.fListener);
        this.fJreCombo = SWTFactory.createCombo(parent, 12, 1, null);
        this.fJreCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fJrePrefButton = new Button(parent, 8);
        this.fJrePrefButton.setText(PDEUIMessages.BasicLauncherTab_installedJREs);
        this.fJrePrefButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String currentVM = this.fJreCombo.getText();
            String currentEE = this.parseEESelection(this.fEeCombo.getText());
            boolean useDefault = VMUtil.getDefaultVMInstallName().equals(currentVM);
            if (SWTFactory.showPreferencePage(this.fTab.getControl().getShell(), "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", null) == 0 && !this.fTab.getControl().isDisposed()) {
                this.setJRECombo();
                if (useDefault || this.fJreCombo.indexOf(currentVM) == -1) {
                    this.fJreCombo.setText(VMUtil.getDefaultVMInstallName());
                } else {
                    this.fJreCombo.setText(currentVM);
                }
                this.setEECombo();
                this.setEEComboSelection(currentEE);
                this.updateBootstrapEnablement();
            }
        }));
        this.fJrePrefButton.setLayoutData((Object)new GridData(4, 4, false, false));
        SWTUtil.setButtonDimensionHint(this.fJrePrefButton);
    }

    protected void createJavaExecutableSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.BasicLauncherTab_javaExec);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 20;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        this.fJavawButton = new Button(composite, 16);
        this.fJavawButton.addSelectionListener((SelectionListener)this.fListener);
        this.fJavaButton = new Button(composite, 16);
        this.fJavaButton.setText("&java");
        this.fJavaButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createBootstrapEntriesSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.BasicLauncherTab_bootstrap);
        this.fBootstrap = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.fBootstrap.setLayoutData((Object)gd);
        this.fBootstrap.addModifyListener((ModifyListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.initializeJRESection(config);
        this.initializeBootstrapEntriesSection(config);
    }

    private void initializeJRESection(ILaunchConfiguration config) throws CoreException {
        String javaCommand = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, "javaw");
        String javawText = NLS.bind((String)PDEUIMessages.BasicLauncherTab_javaExecDefault, (Object)javaCommand);
        this.fJavawButton.setText(javawText);
        this.fJavawButton.setSelection(javaCommand.equals("javaw"));
        this.fJavaButton.setSelection(!this.fJavawButton.getSelection());
        String jre = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        IPath jrePath = null;
        if (jre != null) {
            jrePath = Path.fromPortableString((String)jre);
        }
        String vmInstallName = null;
        String eeId = null;
        if (jrePath == null) {
            eeId = VMHelper.getDefaultEEName((ILaunchConfiguration)config);
            if (eeId == null) {
                vmInstallName = VMHelper.getDefaultVMInstallName((ILaunchConfiguration)config);
            }
        } else {
            eeId = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
            if (eeId == null) {
                vmInstallName = JavaRuntime.getVMInstallName((IPath)jrePath);
            }
        }
        this.fJreButton.setSelection(vmInstallName != null);
        this.fEeButton.setSelection(eeId != null);
        this.setJRECombo();
        this.setEECombo();
        this.setJREComboSelection(vmInstallName);
        this.setEEComboSelection(eeId);
        this.updateJREEnablement();
        this.updateBootstrapEnablement();
    }

    private void updateBootstrapEnablement() {
        IVMInstall vmInstall;
        IExecutionEnvironment environment;
        IPath jrePath = null;
        if (this.fJreButton.getSelection()) {
            if (this.fJreCombo.getSelectionIndex() != -1) {
                String jreName = this.fJreCombo.getText();
                IVMInstall install = VMHelper.getVMInstall((String)jreName);
                jrePath = JavaRuntime.newJREContainerPath((IVMInstall)install);
            }
        } else if (this.fEeCombo.getSelectionIndex() != -1 && (environment = VMUtil.getExecutionEnvironment((String)this.parseEESelection(this.fEeCombo.getText()))) != null) {
            jrePath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)environment);
        }
        if (jrePath != null && (vmInstall = JavaRuntime.getVMInstall(jrePath)) != null) {
            boolean modularJava = JavaRuntime.isModularJava((IVMInstall)vmInstall);
            this.fBootstrap.setEnabled(!modularJava);
        }
    }

    private void setEEComboSelection(String eeId) {
        if (eeId != null) {
            String[] items = this.fEeCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (this.parseEESelection(items[i]).equals(eeId)) {
                    this.fEeCombo.select(i);
                    return;
                }
                ++i;
            }
        }
        if (this.fEeCombo.getItemCount() > 0 && this.fEeCombo.getSelectionIndex() == -1) {
            this.fEeCombo.select(0);
        }
    }

    private void setJREComboSelection(String vmInstallName) {
        if (vmInstallName != null) {
            this.fJreCombo.setText(vmInstallName);
        }
        if (this.fJreCombo.getSelectionIndex() == -1) {
            this.fJreCombo.setText(VMUtil.getDefaultVMInstallName());
        }
    }

    private void updateJREEnablement() {
        this.fJreCombo.setEnabled(this.fJreButton.getSelection());
        this.fJrePrefButton.setEnabled(this.fJreButton.getSelection());
        this.fEeCombo.setEnabled(this.fEeButton.getSelection());
        this.fEePrefButton.setEnabled(this.fEeButton.getSelection());
    }

    private void initializeBootstrapEntriesSection(ILaunchConfiguration config) throws CoreException {
        this.fBootstrap.setText(config.getAttribute("bootstrap", ""));
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.saveJRESection(config);
        this.saveBootstrapEntriesSection(config);
    }

    protected void saveJRESection(ILaunchConfigurationWorkingCopy config) {
        IExecutionEnvironment environment;
        String javaCommand = this.fJavawButton.getSelection() ? null : "java";
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, javaCommand);
        IPath jrePath = null;
        if (this.fJreButton.getSelection()) {
            if (this.fJreCombo.getSelectionIndex() != -1) {
                String jreName = this.fJreCombo.getText();
                IVMInstall install = VMHelper.getVMInstall((String)jreName);
                jrePath = JavaRuntime.newJREContainerPath((IVMInstall)install);
            }
        } else if (this.fEeCombo.getSelectionIndex() != -1 && (environment = VMUtil.getExecutionEnvironment((String)this.parseEESelection(this.fEeCombo.getText()))) != null) {
            jrePath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)environment);
        }
        String attr = null;
        if (jrePath != null) {
            attr = jrePath.toPortableString();
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, attr);
    }

    protected void saveBootstrapEntriesSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("bootstrap", this.fBootstrap.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("bootstrap", "");
    }

    private void setJRECombo() {
        String[] jres = VMUtil.getVMInstallNames();
        Arrays.sort(jres, this.getComparator());
        this.fJreCombo.setItems(jres);
    }

    private void setEECombo() {
        IExecutionEnvironment[] eeObjects = VMUtil.getExecutionEnvironments();
        String[] ees = new String[eeObjects.length];
        int i = 0;
        while (i < eeObjects.length) {
            String vm;
            try {
                vm = VMUtil.getVMInstallName((IExecutionEnvironment)eeObjects[i]);
            }
            catch (CoreException coreException) {
                vm = PDEUIMessages.BasicLauncherTab_unbound;
            }
            ees[i] = NLS.bind((String)"{0} ({1})", (Object[])new String[]{eeObjects[i].getId(), vm});
            ++i;
        }
        this.fEeCombo.setItems(ees);
    }

    private Comparator<Object> getComparator() {
        return (arg0, arg1) -> arg0.toString().compareTo(arg1.toString());
    }

    public String validate() {
        if (this.fEeButton.getSelection() && this.fEeCombo.getText().indexOf(PDEUIMessages.BasicLauncherTab_unbound) != -1) {
            return NLS.bind((String)PDEUIMessages.BasicLauncherTab_noJreForEeMessage, (Object)this.parseEESelection(this.fEeCombo.getText()));
        }
        return null;
    }

    private String parseEESelection(String selection) {
        int index = selection.indexOf(" (");
        if (index == -1) {
            return selection;
        }
        return selection.substring(0, index);
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof Button && !((Button)source).getSelection()) {
                return;
            }
            JREBlock.this.fTab.updateLaunchConfigurationDialog();
            if (source == JREBlock.this.fEeCombo || source == JREBlock.this.fEeButton || source == JREBlock.this.fJreCombo || source == JREBlock.this.fJreButton) {
                JREBlock.this.updateBootstrapEnablement();
            }
            if (source == JREBlock.this.fJreButton || source == JREBlock.this.fEeButton) {
                JREBlock.this.updateJREEnablement();
            }
        }

        public void modifyText(ModifyEvent e) {
            JREBlock.this.fTab.scheduleUpdateJob();
        }
    }
}

