/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;

public class NodeData {
    private Node node;
    private double origX;
    private double origY;
    private int activeLabel;
    private int graphListIndex;

    public NodeData(Node node, double origX, double origY, int activeLabel, int graphListIndex) {
        this.node = node;
        this.origX = origX;
        this.origY = origY;
        this.activeLabel = activeLabel;
        this.graphListIndex = graphListIndex;
    }

    public Node getNode() {
        return this.node;
    }

    public URI getNodeURI() {
        return this.node.getURI();
    }

    public EList<NodeLabel> getNodeLabels() {
        return this.node.getLabels();
    }

    public String getNodeTitle() {
        if (this.node.getDublinCore().getTitle() != null) {
            return this.node.getDublinCore().getTitle();
        }
        return "";
    }

    public void setNodeTitle(String nodeTitle) {
        this.node.getDublinCore().setTitle(nodeTitle);
    }

    public double getOrigX() {
        return this.origX;
    }

    public void setOrigX(double origX) {
        this.origX = origX;
    }

    public double getOrigY() {
        return this.origY;
    }

    public void setOrigY(double origY) {
        this.origY = origY;
    }

    public int getActiveLabel() {
        return this.activeLabel;
    }

    public void setActiveLabel(int activeLabel) {
        this.activeLabel = activeLabel;
    }

    public int getGraphListIndex() {
        return this.graphListIndex;
    }

    public double getAreaLabelValue() {
        AreaLabel areaLabel = (AreaLabel)this.node.getLabels().get(this.activeLabel);
        return areaLabel.getCurrentAreaValue().getArea();
    }

    public void setAreaLabelValue(double area) {
        AreaLabel areaLabel = (AreaLabel)this.node.getLabels().get(this.activeLabel);
        areaLabel.getCurrentAreaValue().setArea(area);
    }

    public String getPopulationLabelPopulation() {
        PopulationLabel populationLabel = (PopulationLabel)this.node.getLabels().get(this.activeLabel);
        if (populationLabel.getPopulationIdentifier() != null) {
            return populationLabel.getPopulationIdentifier();
        }
        return "";
    }

    public void setPopulationLabelPopulation(String population) {
        PopulationLabel populationLabel = (PopulationLabel)this.node.getLabels().get(this.activeLabel);
        populationLabel.setPopulationIdentifier(population);
    }

    public double getPopulationLabelCount() {
        PopulationLabel populationLabel = (PopulationLabel)this.node.getLabels().get(this.activeLabel);
        return populationLabel.getCurrentPopulationValue().getCount();
    }

    public void setPopulationLabelCount(double count) {
        PopulationLabel populationLabel = (PopulationLabel)this.node.getLabels().get(this.activeLabel);
        populationLabel.getCurrentPopulationValue().setCount(count);
    }

    public double getPopulationLabelArea() {
        PopulationLabel populationLabel = (PopulationLabel)this.node.getLabels().get(this.activeLabel);
        return populationLabel.getPopulatedArea();
    }

    public void setPopulationLabelArea(double area) {
        PopulationLabel populationLabel = (PopulationLabel)this.node.getLabels().get(this.activeLabel);
        populationLabel.setPopulatedArea(area);
    }
}

