/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.standard.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.stem.populationmodels.standard.AgingPopulationModel;
import org.eclipse.stem.populationmodels.standard.DemographicPopulationModel;
import org.eclipse.stem.populationmodels.standard.ExternalDataSourcePopulationModel;
import org.eclipse.stem.populationmodels.standard.MosquitoPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.SeasonalPopulationModel;
import org.eclipse.stem.populationmodels.standard.SinModulatePopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;
import org.eclipse.stem.ui.populationmodels.adapters.PopulationModelPropertyEditor;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationModelWizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class StandardPopulationModelPropertyEditor
extends PopulationModelPropertyEditor {
    private ArrayList<Composite> groupComposites = new ArrayList();
    private ArrayList<Text> groupIDComposites = new ArrayList();
    private ArrayList<Text> groupFracComposites = new ArrayList();
    private ArrayList<Text> groupFromAgeComposites = new ArrayList();
    private ArrayList<Text> groupToAgeComposites = new ArrayList();
    private ArrayList<Text> groupDeathFactorComposites = new ArrayList();
    private static double DEFAULT_POPULATION_FRACTION = 1.0;
    private static int DEFAULT_AGEGROUP_RANGE = 20;
    private static double DEFAULT_DEATH_FACTOR = 1.0;
    Group allGroups;
    String populationID;

    public StandardPopulationModelPropertyEditor(Composite parent, int style, PopulationModel populationModel, final ModifyListener projectValidator, IProject project) {
        super(parent, style, populationModel, projectValidator, project);
        this.populationID = populationModel.getPopulationIdentifier();
        if (populationModel instanceof DemographicPopulationModel && !(populationModel instanceof AgingPopulationModel)) {
            this.allGroups = new Group((Composite)this, 0);
            this.allGroups.setLayout((Layout)new GridLayout(1, true));
            this.allGroups.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
            this.addPopulationGroupField((Composite)this.allGroups, projectValidator);
            Button addButton = new Button((Composite)this, 0);
            addButton.setText(PopulationModelWizardMessages.getString("addGroup"));
            addButton.setToolTipText(PopulationModelWizardMessages.getString("addGroupTT"));
            addButton.setLayoutData((Object)new GridData(1, 1, true, true, 3, 1));
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    StandardPopulationModelPropertyEditor.this.addPopulationGroupField((Composite)StandardPopulationModelPropertyEditor.this.allGroups, projectValidator);
                    StandardPopulationModelPropertyEditor.this.updateGui();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        } else if (populationModel instanceof AgingPopulationModel) {
            Button hasMaxAgeButton = (Button)this.booleanMap.get(StandardPackage.Literals.AGING_POPULATION_MODEL__HAS_MAX_AGE);
            hasMaxAgeButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StandardPopulationModelPropertyEditor.this.updateTextFields();
                }
            });
            this.allGroups = new Group((Composite)this, 0);
            this.allGroups.setLayout((Layout)new GridLayout(1, true));
            this.allGroups.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
            this.addAgeGroupField((Composite)this.allGroups, projectValidator);
            Button addButton = new Button((Composite)this, 0);
            addButton.setText(PopulationModelWizardMessages.getString("addGroup"));
            addButton.setToolTipText(PopulationModelWizardMessages.getString("addGroupTT"));
            addButton.setLayoutData((Object)new GridData(1, 1, true, true, 3, 1));
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    StandardPopulationModelPropertyEditor.this.addAgeGroupField((Composite)StandardPopulationModelPropertyEditor.this.allGroups, projectValidator);
                    StandardPopulationModelPropertyEditor.this.updateGui();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Button fractionsButton = new Button((Composite)this, 0);
            fractionsButton.setText(PopulationModelWizardMessages.getString("setFractions"));
            fractionsButton.setToolTipText(PopulationModelWizardMessages.getString("setFractionsTT"));
            fractionsButton.setLayoutData((Object)new GridData(1, 2, true, true, 3, 1));
            fractionsButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StandardPopulationModelPropertyEditor.this.setFractionToEquilibrium();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button deathRatesButton = new Button((Composite)this, 0);
            deathRatesButton.setText(PopulationModelWizardMessages.getString("setDeathRates"));
            deathRatesButton.setToolTipText(PopulationModelWizardMessages.getString("setDeathRatesTT"));
            deathRatesButton.setLayoutData((Object)new GridData(1, 2, true, true, 3, 1));
            deathRatesButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StandardPopulationModelPropertyEditor.this.setDeathRatesToEquilibrium();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void addPopulationGroupField(Composite parent, ModifyListener projectValidator) {
        Group groupInfo = new Group(parent, 2048);
        groupInfo.setLayout((Layout)new GridLayout(11, false));
        groupInfo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.groupComposites.add((Composite)groupInfo);
        final Button removeButton = new Button((Composite)groupInfo, 0);
        removeButton.setText(PopulationModelWizardMessages.getString("removeGroup"));
        removeButton.setToolTipText(PopulationModelWizardMessages.getString("removeGroupTT"));
        removeButton.setLayoutData((Object)new GridData(1, 2, true, false));
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int ind = StandardPopulationModelPropertyEditor.this.groupComposites.indexOf(removeButton.getParent());
                StandardPopulationModelPropertyEditor.this.groupComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupFracComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupIDComposites.remove(ind);
                removeButton.getParent().dispose();
                StandardPopulationModelPropertyEditor.this.updateGui();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("populationId"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        Text text = new Text((Composite)groupInfo, 133120);
        text.setText(String.valueOf(this.populationID) + this.groupComposites.size());
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        text.addModifyListener(projectValidator);
        this.groupIDComposites.add(text);
        label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("populationIdFraction"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        text = new Text((Composite)groupInfo, 133120);
        text.setText(String.valueOf(DEFAULT_POPULATION_FRACTION));
        text.setLayoutData((Object)new GridData(3, 2, true, false));
        text.addModifyListener(projectValidator);
        this.groupFracComposites.add(text);
        this.getParent().pack();
        this.getParent().layout();
    }

    private void addAgeGroupField(Composite parent, ModifyListener projectValidator) {
        Group groupInfo = new Group(parent, 2048);
        groupInfo.setLayout((Layout)new GridLayout(11, false));
        groupInfo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.groupComposites.add((Composite)groupInfo);
        final Button removeButton = new Button((Composite)groupInfo, 0);
        removeButton.setText(PopulationModelWizardMessages.getString("removeGroup"));
        removeButton.setToolTipText(PopulationModelWizardMessages.getString("removeGroupTT"));
        removeButton.setLayoutData((Object)new GridData(1, 2, true, false));
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int ind = StandardPopulationModelPropertyEditor.this.groupComposites.indexOf(removeButton.getParent());
                StandardPopulationModelPropertyEditor.this.groupComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupFracComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupIDComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupFromAgeComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupToAgeComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.groupDeathFactorComposites.remove(ind);
                StandardPopulationModelPropertyEditor.this.updateTextFields();
                removeButton.getParent().dispose();
                StandardPopulationModelPropertyEditor.this.updateGui();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("populationId"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        Text text = new Text((Composite)groupInfo, 133120);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        text.addModifyListener(projectValidator);
        this.groupIDComposites.add(text);
        label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("populationIdFraction"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        text = new Text((Composite)groupInfo, 133120);
        text.setText(String.valueOf(DEFAULT_POPULATION_FRACTION));
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        text.addModifyListener(projectValidator);
        this.groupFracComposites.add(text);
        label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("fromAge"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        text = new Text((Composite)groupInfo, 133120);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        text.addModifyListener(projectValidator);
        this.groupFromAgeComposites.add(text);
        label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("toAge"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        text = new Text((Composite)groupInfo, 133120);
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        text.addModifyListener(projectValidator);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardPopulationModelPropertyEditor.this.updateTextFields();
            }
        });
        this.groupToAgeComposites.add(text);
        label = new Label((Composite)groupInfo, 0);
        label.setText(PopulationModelWizardMessages.getString("deathFactor"));
        label.setLayoutData((Object)new GridData(3, 2, true, false));
        text = new Text((Composite)groupInfo, 133120);
        text.setText(String.valueOf(DEFAULT_DEATH_FACTOR));
        text.setLayoutData((Object)new GridData(4, 2, true, false));
        text.addModifyListener(projectValidator);
        this.groupDeathFactorComposites.add(text);
        this.updateTextFields();
    }

    @Override
    public void populate(PopulationModel populationModel) {
        PopulationGroup newGroup;
        int i;
        DemographicPopulationModel dpm;
        StandardPopulationModel model;
        super.populate(populationModel);
        populationModel.setPopulationIdentifier(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__POPULATION_IDENTIFIER)).getText());
        populationModel.setName(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__NAME)).getText());
        populationModel.setInitialRescalingFactor(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__INITIAL_RESCALING_FACTOR)).getText()));
        if (populationModel instanceof StandardPopulationModel) {
            model = (StandardPopulationModel)populationModel;
            model.setBirthRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__BIRTH_RATE)).getText()));
            model.setDeathRate(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__DEATH_RATE)).getText()));
            model.setTimePeriod(Long.parseLong(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)).getText()));
        }
        if (populationModel instanceof SeasonalPopulationModel) {
            model = (SeasonalPopulationModel)populationModel;
            model.setModulationAmplitude(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SEASONAL_POPULATION_MODEL__MODULATION_AMPLITUDE)).getText()));
            model.setPhase(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SEASONAL_POPULATION_MODEL__PHASE)).getText()));
        }
        if (populationModel instanceof MosquitoPopulationModel) {
            model = (MosquitoPopulationModel)populationModel;
            model.setScalingFactor(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.MOSQUITO_POPULATION_MODEL__SCALING_FACTOR)).getText()));
            model.setTimePeriod(Long.parseLong(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)).getText()));
        }
        if (populationModel instanceof DemographicPopulationModel && !(populationModel instanceof AgingPopulationModel)) {
            dpm = (DemographicPopulationModel)populationModel;
            i = 0;
            while (i < this.groupIDComposites.size()) {
                newGroup = StandardFactory.eINSTANCE.createPopulationGroup();
                String id = this.groupIDComposites.get(i).getText();
                double fr = Double.parseDouble(this.groupFracComposites.get(i).getText());
                newGroup.setIdentifier(id);
                newGroup.setFraction(fr);
                dpm.getPopulationGroups().add((Object)newGroup);
                ++i;
            }
        }
        if (populationModel instanceof AgingPopulationModel) {
            dpm = (AgingPopulationModel)populationModel;
            i = 0;
            while (i < this.groupIDComposites.size()) {
                newGroup = StandardFactory.eINSTANCE.createAgeGroup();
                newGroup.setIdentifier(this.groupIDComposites.get(i).getText());
                newGroup.setFraction(Double.parseDouble(this.groupFracComposites.get(i).getText()));
                newGroup.setFromAge(Integer.parseInt(this.groupFromAgeComposites.get(i).getText()));
                try {
                    newGroup.setLimited(true);
                    newGroup.setToAge(Integer.parseInt(this.groupToAgeComposites.get(i).getText()));
                }
                catch (NumberFormatException e) {
                    newGroup.setLimited(false);
                }
                newGroup.setDeathFactor(Double.parseDouble(this.groupDeathFactorComposites.get(i).getText()));
                dpm.getPopulationGroups().add((Object)newGroup);
                ++i;
            }
        }
        if (populationModel instanceof ExternalDataSourcePopulationModel) {
            Button button;
            model = (ExternalDataSourcePopulationModel)populationModel;
            Text txt = (Text)this.map.get(StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_MODEL__DATA_PATH);
            if (txt != null) {
                model.setDataPath(txt.getText());
            }
            if ((button = (Button)this.booleanMap.get(StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_MODEL__RESTART)) != null) {
                model.setRestart(button.getSelection());
            }
            if ((txt = (Text)this.map.get(StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_MODEL__BUFFER_SIZE)) != null) {
                model.setBufferSize(Integer.parseInt(txt.getText().trim()));
            }
        }
        if (populationModel instanceof SinModulatePopulationModel) {
            model = (SinModulatePopulationModel)populationModel;
            model.setMaxBound(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SIN_MODULATE_POPULATION_MODEL__MAX_BOUND)).getText()));
            model.setMinBound(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SIN_MODULATE_POPULATION_MODEL__MIN_BOUND)).getText()));
            model.setPeriodSin(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SIN_MODULATE_POPULATION_MODEL__PERIOD_SIN)).getText()));
            model.setPhaseShift(Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.SIN_MODULATE_POPULATION_MODEL__PHASE_SHIFT)).getText()));
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__POPULATION_IDENTIFIER);
        if (text != null && text.getText().equals("")) {
            this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr0");
            return false;
        }
        text = (Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__INITIAL_RESCALING_FACTOR);
        if (text != null) {
            String val = text.getText();
            if (val == null || val.trim().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr27");
                return false;
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(val);
            }
            catch (Exception e) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr27");
                return false;
            }
            if (d < 0.0) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr27");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__DEATH_RATE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr4");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr5");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__BIRTH_RATE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr6");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr7");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr8");
                return false;
            }
            if (!this.isValidLongValue(text.getText(), 0L)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr9");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.STOCHASTIC_STANDARD_POPULATION_MODEL__GAIN)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr10");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr10");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SEASONAL_POPULATION_MODEL__MODULATION_AMPLITUDE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr18");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText(), 0.0, 1.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr18");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SEASONAL_POPULATION_MODEL__PHASE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr19");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr19");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.MOSQUITO_POPULATION_MODEL__SCALING_FACTOR)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr20");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr20");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr21");
                return false;
            }
            if (!this.isValidLongValue(text.getText())) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr21");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SIN_MODULATE_POPULATION_MODEL__MAX_BOUND)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr28");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr30");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.MOSQUITO_POPULATION_MODEL__SCALING_FACTOR)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr29");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr30");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.SEASONAL_POPULATION_MODEL__PHASE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr19");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr19");
                return false;
            }
        }
        if ((text = (Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr21");
                return false;
            }
            if (!this.isValidLongValue(text.getText())) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr21");
                return false;
            }
        }
        double sum = 0.0;
        for (Text t : this.groupFracComposites) {
            if (!this.isValidValue(t.getText(), 0.0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr13");
                return false;
            }
            sum += Double.parseDouble(t.getText());
        }
        if (sum > 1.0) {
            this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr11");
            return false;
        }
        for (Text t : this.groupIDComposites) {
            if (!t.getText().trim().equals("")) continue;
            this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr12");
            return false;
        }
        int lastValue = -1;
        for (Text t : this.groupToAgeComposites) {
            if (!t.getEditable()) continue;
            if (!this.isValidIntValue(t.getText(), 0)) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr22");
                return false;
            }
            if (Integer.parseInt(t.getText()) <= lastValue) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr22");
                return false;
            }
            lastValue = Integer.parseInt(t.getText());
        }
        for (Text t : this.groupDeathFactorComposites) {
            if (this.isValidValue(t.getText(), 0.0)) continue;
            this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr23");
            return false;
        }
        text = (Text)this.map.get(StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_MODEL__DATA_PATH);
        if (text != null && text.getText().equals("")) {
            this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr26");
            return false;
        }
        text = (Text)this.map.get(StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_MODEL__BUFFER_SIZE);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr31");
                return false;
            }
            String intText = text.getText();
            try {
                int r = Integer.parseInt(intText);
                if (r < 1) {
                    this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr31");
                    return false;
                }
            }
            catch (Exception e) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr31");
                return false;
            }
        }
        return true;
    }

    private void updateGui() {
        this.pack();
        this.getParent().layout();
        this.getParent().getParent().getParent().layout();
    }

    private void updateTextFields() {
        Button hasMaxAgeButton = (Button)this.booleanMap.get(StandardPackage.Literals.AGING_POPULATION_MODEL__HAS_MAX_AGE);
        int n = this.groupToAgeComposites.size();
        int i = 0;
        while (i < n) {
            if (i == 0) {
                if (!this.groupFromAgeComposites.get(i).getText().equals("0")) {
                    this.groupFromAgeComposites.get(i).setText("0");
                }
            } else {
                try {
                    String age = String.valueOf(Integer.parseInt(this.groupToAgeComposites.get(i - 1).getText()) + 1);
                    if (!this.groupFromAgeComposites.get(i).getText().equals(age)) {
                        this.groupFromAgeComposites.get(i).setText(age);
                    }
                }
                catch (NumberFormatException age) {
                    // empty catch block
                }
            }
            if (i == n - 1 && !hasMaxAgeButton.getSelection()) {
                if (this.groupToAgeComposites.get(i).getEditable()) {
                    this.groupToAgeComposites.get(i).setEditable(false);
                }
                if (!this.groupToAgeComposites.get(i).getText().equals(" ")) {
                    this.groupToAgeComposites.get(i).setText(" ");
                }
            } else {
                if (!this.groupToAgeComposites.get(i).getEditable()) {
                    this.groupToAgeComposites.get(i).setEditable(true);
                }
                if (this.groupToAgeComposites.get(i).getText().trim().equals("")) {
                    try {
                        int age = Integer.parseInt(this.groupFromAgeComposites.get(i).getText()) + DEFAULT_AGEGROUP_RANGE - 1;
                        this.groupToAgeComposites.get(i).setText(String.valueOf(age));
                    }
                    catch (NumberFormatException age) {
                        // empty catch block
                    }
                }
            }
            String id = String.valueOf(this.populationID) + this.groupFromAgeComposites.get(i).getText().trim() + "-" + this.groupToAgeComposites.get(i).getText().trim();
            if (!this.groupIDComposites.get(i).getText().equals(id)) {
                this.groupIDComposites.get(i).setText(id);
            }
            ++i;
        }
    }

    private void setFractionToEquilibrium() {
        double birthRate = Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__BIRTH_RATE)).getText());
        double deathRate = Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__DEATH_RATE)).getText());
        long timePeriod = Long.parseLong(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)).getText());
        int n = this.groupComposites.size();
        int[] ageRanges = new int[n];
        double[] deathRates = new double[n];
        double[] fractions = new double[n];
        int i = 0;
        while (i < n) {
            try {
                ageRanges[i] = Integer.parseInt(this.groupToAgeComposites.get(i).getText()) - Integer.parseInt(this.groupFromAgeComposites.get(i).getText()) + 1;
            }
            catch (NumberFormatException e) {
                ageRanges[i] = 0;
            }
            deathRates[i] = Double.parseDouble(this.groupDeathFactorComposites.get(i).getText()) * deathRate;
            fractions[i] = Double.parseDouble(this.groupFracComposites.get(i).getText());
            ++i;
        }
        double years = (double)timePeriod / 3.1556952216E10;
        int step = 0;
        while (step < 1000000) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < n) {
                sum += fractions[i2];
                ++i2;
            }
            i2 = n - 1;
            while (i2 >= 0) {
                double arrivals = 0.0;
                double deparures = 0.0;
                arrivals = i2 == 0 ? birthRate * sum : years / (double)ageRanges[i2 - 1] * fractions[i2 - 1];
                deparures = ageRanges[i2] != 0 ? (deathRates[i2] + years / (double)ageRanges[i2]) * fractions[i2] : deathRates[i2] * fractions[i2];
                int n2 = i2--;
                fractions[n2] = fractions[n2] + (arrivals - deparures);
            }
            ++step;
        }
        double sum = 0.0;
        int i3 = 0;
        while (i3 < n) {
            sum += fractions[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < n) {
            this.groupFracComposites.get(i3).setText(String.valueOf(fractions[i3] / sum));
            ++i3;
        }
    }

    private void setDeathRatesToEquilibrium() {
        double birthRate = Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__BIRTH_RATE)).getText());
        double deathRate = Double.parseDouble(((Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__DEATH_RATE)).getText());
        long timePeriod = Long.parseLong(((Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__TIME_PERIOD)).getText());
        int n = this.groupComposites.size();
        int[] ageRanges = new int[n];
        double[] fractions = new double[n];
        int i = 0;
        while (i < n) {
            try {
                ageRanges[i] = Integer.parseInt(this.groupToAgeComposites.get(i).getText()) - Integer.parseInt(this.groupFromAgeComposites.get(i).getText()) + 1;
            }
            catch (NumberFormatException e) {
                ageRanges[i] = 0;
            }
            fractions[i] = Double.parseDouble(this.groupFracComposites.get(i).getText());
            ++i;
        }
        double years = (double)timePeriod / 3.1556952216E10;
        double sum = 0.0;
        double[] deathFactors = new double[n];
        int i2 = 0;
        while (i2 < n) {
            sum += fractions[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            double desiredDeaths = 0.0;
            desiredDeaths = i2 == 0 ? birthRate * sum - years / (double)ageRanges[i2] * fractions[i2] : (ageRanges[i2] != 0 ? years / (double)ageRanges[i2 - 1] * fractions[i2 - 1] - years / (double)ageRanges[i2] * fractions[i2] : years / (double)ageRanges[i2 - 1] * fractions[i2 - 1]);
            deathFactors[i2] = desiredDeaths / fractions[i2] / deathRate;
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            this.groupDeathFactorComposites.get(i2).setText(String.valueOf(deathFactors[i2]));
            ++i2;
        }
    }
}

