/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.util.Date;
import org.eclipse.stem.ui.ge.Activator;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;

public class GELog {
    public static boolean DEBUG = false;
    private static final long start = new Date().getTime();

    public static void debug(String msg) {
        if (DEBUG) {
            System.out.println("GE: " + msg);
            System.out.flush();
        }
    }

    public static void debug(Object where, String msg) {
        if (DEBUG) {
            String classname = "";
            if (where instanceof String) {
                classname = (String)where;
            } else if (where instanceof Class) {
                classname = ((Class)where).getSimpleName();
            } else {
                classname = where.getClass().getSimpleName();
                Thread t = Thread.currentThread();
                StackTraceElement[] st = t.getStackTrace();
                if (st[3].getClassName().contains(classname)) {
                    classname = String.valueOf(classname) + "." + st[3].getMethodName();
                }
            }
            String prefix = String.valueOf(classname) + ": ";
            if (Activator.getDefault() != null && GEPreferencePage.isTest()) {
                String t = GELog.getThread();
                String clock = GELog.getClock();
                prefix = String.valueOf(clock) + " " + t + "-" + prefix;
            }
            System.out.println(String.valueOf(prefix) + msg);
            System.out.flush();
        }
    }

    private static String getThread() {
        return Thread.currentThread().getName();
    }

    private static String getClock() {
        long now = new Date().getTime() - start;
        return Long.toString(now);
    }

    public static void info(Class current, String msg) {
        GELog.info(String.valueOf(current.getSimpleName()) + ": " + msg);
    }

    public static void info(String msg) {
        if (DEBUG) {
            System.err.println(msg);
        }
        Activator.logInfo(msg, null);
    }

    public static void error(String msg, Throwable t) {
        if (DEBUG) {
            System.err.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
        System.err.flush();
        Activator.logError(msg, t);
    }

    public static void memory() {
        Runtime rt = Runtime.getRuntime();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        GELog.debug("Memory Total: " + rt.totalMemory() / 1024L + "K");
        GELog.debug("Memory Free:  " + rt.freeMemory() / 1024L + "K");
        GELog.debug("Memory Max:   " + rt.maxMemory() / 1024L + "K");
    }

    public static boolean memoryCheck(double percent) {
        Runtime rt = Runtime.getRuntime();
        GELog.debug("Memory Max:   " + rt.maxMemory() / 1024L + "K");
        long used = rt.totalMemory() - rt.freeMemory();
        double currentPercent = (double)used / (double)rt.maxMemory();
        GELog.debug("Memory Used:  " + used / 1024L + "K");
        GELog.debug("Percent Used: " + currentPercent);
        if (currentPercent > percent) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            used = rt.totalMemory() - rt.freeMemory();
            currentPercent = (double)used / (double)rt.maxMemory();
            GELog.debug("Memory used after GC:  " + used / 1024L + "K");
            GELog.debug("Percent Used: " + currentPercent);
            return currentPercent > percent;
        }
        return false;
    }

    public static void main(String[] args) {
        DEBUG = true;
        GELog.debug("msg with no class.");
        GELog.debug(GELog.class, "msg with class specified");
        try {
            Object a = null;
            a.getClass();
        }
        catch (Throwable t) {
            GELog.error("Expected NullPointerException", t);
        }
    }
}

