/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Jump;

public class ConditionalJump
extends Jump {
    private boolean fJumpOnTrue;

    public ConditionalJump(boolean jumpOnTrue) {
        this.fJumpOnTrue = jumpOnTrue;
    }

    @Override
    public void execute() throws CoreException {
        IJavaValue conditionValue = this.popValue();
        IJavaPrimitiveValue condition = null;
        if (conditionValue instanceof IJavaPrimitiveValue) {
            condition = (IJavaPrimitiveValue)conditionValue;
        } else if (conditionValue instanceof IJavaObject && ((IJavaObject)conditionValue).getJavaType().getName().equals("java.lang.Boolean")) {
            condition = (IJavaPrimitiveValue)((IJavaObject)conditionValue).getField("value", false).getValue();
        }
        if (!(this.fJumpOnTrue ^ condition.getBooleanValue())) {
            this.jump(this.fOffset);
        }
    }

    @Override
    public String toString() {
        return InstructionsEvaluationMessages.ConditionalJump_conditional_jump_1;
    }
}

