/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class DefaultContentAssistProcessor
implements IContentAssistProcessor {
    private static final String NON_ALPHANUMERIC_LAST_REGEXP = "[^\\w](?!.*[^\\w])";
    private static final String NON_ALPHANUMERIC_REGEXP = "[^a-zA-Z0-9]+";
    private static final Pattern NON_ALPHANUMERIC_LAST_PATTERN = Pattern.compile("[^\\w](?!.*[^\\w])");

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String text = viewer.getDocument().get();
        String[] tokens = text.split(NON_ALPHANUMERIC_REGEXP);
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        int wordStartIndex = DefaultContentAssistProcessor.findStartingPoint(text, offset);
        String prefix = text.substring(wordStartIndex, offset);
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        for (String token : tokenSet) {
            if (token == null || token.length() < 2 || token.equals(prefix) || !token.startsWith(prefix)) continue;
            String completion = token.substring(prefix.length());
            CompletionProposal proposal = new CompletionProposal(completion, offset, 0, completion.length(), null, token, null, null);
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private static int findStartingPoint(String text, int offset) {
        String substring = text.substring(0, offset);
        Matcher m = NON_ALPHANUMERIC_LAST_PATTERN.matcher(substring);
        m.find();
        return m.end();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

