/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.multipopulation.impl;

import java.util.Calendar;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSeasonalDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultipopulationPackage;
import org.eclipse.stem.diseasemodels.multipopulation.impl.MultiPopulationSEIRDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.SEIRLabel;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;

public class MultiPopulationSeasonalDiseaseModelImpl
extends MultiPopulationSEIRDiseaseModelImpl
implements MultiPopulationSeasonalDiseaseModel {
    protected DoubleValueMatrix modulationPoints;
    protected static final boolean USE_SPLINE_INTERPOLATION_EDEFAULT = false;
    protected boolean useSplineInterpolation = false;
    private PolynomialSplineFunction splineFunction;
    private PolynomialSplineFunction linearFunction;
    private double[] x;
    private double[] y;

    @Override
    protected EClass eStaticClass() {
        return MultipopulationPackage.Literals.MULTI_POPULATION_SEASONAL_DISEASE_MODEL;
    }

    @Override
    public DoubleValueMatrix getModulationPoints() {
        return this.modulationPoints;
    }

    public NotificationChain basicSetModulationPoints(DoubleValueMatrix newModulationPoints, NotificationChain msgs) {
        this.modulationPoints = newModulationPoints;
        return msgs;
    }

    @Override
    public void setModulationPoints(DoubleValueMatrix newModulationPoints) {
        if (newModulationPoints != this.modulationPoints) {
            NotificationChain msgs = null;
            if (this.modulationPoints != null) {
                msgs = ((InternalEObject)this.modulationPoints).eInverseRemove((InternalEObject)this, -26, null, msgs);
            }
            if (newModulationPoints != null) {
                msgs = ((InternalEObject)newModulationPoints).eInverseAdd((InternalEObject)this, -26, null, msgs);
            }
            if ((msgs = this.basicSetModulationPoints(newModulationPoints, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public boolean isUseSplineInterpolation() {
        return this.useSplineInterpolation;
    }

    @Override
    public void setUseSplineInterpolation(boolean newUseSplineInterpolation) {
        this.useSplineInterpolation = newUseSplineInterpolation;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 25: {
                return this.basicSetModulationPoints(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 25: {
                return this.getModulationPoints();
            }
            case 26: {
                return this.isUseSplineInterpolation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 25: {
                this.setModulationPoints((DoubleValueMatrix)newValue);
                return;
            }
            case 26: {
                this.setUseSplineInterpolation((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 25: {
                this.setModulationPoints(null);
                return;
            }
            case 26: {
                this.setUseSplineInterpolation(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 25: {
                return this.modulationPoints != null;
            }
            case 26: {
                return this.useSplineInterpolation;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (useSplineInterpolation: ");
        result.append(this.useSplineInterpolation);
        result.append(')');
        return result.toString();
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SEIRLabelValue currentSEIR = (SEIRLabelValue)currentState;
            String thisPopulation = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            int populationIndex = this.getPopulationIndex(thisPopulation);
            double transmissionModulation = this.computeInterpolationFunctions(time);
            EList transmissionVector = ((DoubleValueList)this.getTransmissionRate().getValueLists().get(populationIndex)).getValues();
            double thisRecoveryRate = ((DoubleValue)this.getRecoveryRate().getValues().get(populationIndex)).getValue();
            double thisImmunityLossRate = ((DoubleValue)this.getImmunityLossRate().getValues().get(populationIndex)).getValue();
            double thisIncubationRate = ((DoubleValue)this.getIncubationRate().getValues().get(populationIndex)).getValue();
            double numberOfSusceptibleToExposed = 0.0;
            double numberSusceptible = currentSEIR.getS();
            Node thisNode = diseaseLabel.getNode();
            EList groupList = this.getPopulationGroups().getValues();
            int i = 0;
            while (i < transmissionVector.size()) {
                double specificTransmission = ((DoubleValue)transmissionVector.get(i)).getValue();
                double adjustedTransmission = this.getAdjustedTransmissionRate(specificTransmission, timeDelta) * transmissionModulation;
                if (!this.isFrequencyDependent()) {
                    adjustedTransmission *= this.getTransmissionRateScaleFactor(diseaseLabel);
                }
                String nextPop = ((StringValue)groupList.get(i)).getValue();
                for (NodeLabel nlabel : thisNode.getLabels()) {
                    SEIRLabel otherDiseaseLabel;
                    String otherPopulation;
                    if (!(nlabel instanceof SEIRLabel) || ((SEIRLabel)nlabel).getDecorator() != this || !(otherPopulation = (otherDiseaseLabel = (SEIRLabel)nlabel).getIdentifier()).equals(nextPop)) continue;
                    double onsiteInfectious = ((SEIRLabelValue)otherDiseaseLabel.getTempValue()).getI();
                    double effectiveInfectious = this.getNormalizedEffectiveInfectious(thisNode, (StandardDiseaseModelLabel)otherDiseaseLabel, onsiteInfectious, StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                    numberOfSusceptibleToExposed += adjustedTransmission * numberSusceptible * effectiveInfectious;
                }
                ++i;
            }
            double numberOfInfectedToRecovered = this.getAdjustedRecoveryRate(thisRecoveryRate, timeDelta) * currentSEIR.getI();
            double numberOfRecoveredToSusceptible = this.getAdjustedImmunityLossRate(thisImmunityLossRate, timeDelta) * currentSEIR.getR();
            double numberOfExposedToInfected = this.getAdjustedIncubationRate(thisIncubationRate, timeDelta) * currentSEIR.getE();
            double diseaseDeaths = this.getAdjustedInfectiousMortalityRate(timeDelta, thisPopulation) * currentSEIR.getI();
            double deltaS = -numberOfSusceptibleToExposed + numberOfRecoveredToSusceptible;
            double deltaE = numberOfSusceptibleToExposed - numberOfExposedToInfected;
            double deltaI = numberOfExposedToInfected - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            SEIRLabelValueImpl ret = (SEIRLabelValueImpl)deltaValue;
            Exchange seExchange = (Exchange)ExchangePool.POOL.get();
            seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            seExchange.setCount(numberOfSusceptibleToExposed);
            seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)seExchange);
            Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
            eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            eiExchange.setCount(numberOfExposedToInfected);
            eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)eiExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            ret.setS(deltaS);
            ret.setE(deltaE);
            ret.setI(deltaI);
            ret.setR(deltaR);
            ret.setIncidence(numberOfSusceptibleToExposed);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    private synchronized double computeInterpolationFunctions(STEMTime time) {
        boolean pointsChanged = false;
        EList points = this.modulationPoints.getValueLists();
        int n = points.size();
        int m = 10;
        if (this.x == null || this.x.length != (2 * m + 1) * n) {
            this.x = new double[(2 * m + 1) * n];
            this.y = new double[(2 * m + 1) * n];
            pointsChanged = true;
        }
        int index = 0;
        for (DoubleValueList point : points) {
            double nx = ((DoubleValue)point.getValues().get(0)).getValue();
            double ny = ((DoubleValue)point.getValues().get(1)).getValue();
            if (this.x[index] != nx - (double)m * 365.0 || this.y[index] != ny) {
                this.x[index] = nx - (double)m * 365.0;
                this.y[index] = ny;
                pointsChanged = true;
            }
            ++index;
        }
        if (pointsChanged) {
            int j = 1;
            while (j <= 2 * m) {
                int i = 0;
                while (i < n) {
                    this.x[j * n + i] = this.x[i] + (double)j * 365.0;
                    this.y[j * n + i] = this.y[i];
                    ++i;
                }
                ++j;
            }
            n = (2 * m + 1) * n;
            SplineInterpolator interpolator = new SplineInterpolator();
            this.splineFunction = interpolator.interpolate(this.x, this.y);
            PolynomialFunction[] polynomials = new PolynomialFunction[n - 1];
            int i = 0;
            while (i < n - 1) {
                double[] coefficients = new double[]{this.y[i], (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i])};
                polynomials[i] = new PolynomialFunction(coefficients);
                ++i;
            }
            this.linearFunction = new PolynomialSplineFunction(this.x, polynomials);
        }
        Calendar calJanOne = Calendar.getInstance();
        int currentYear = calJanOne.get(1);
        calJanOne.set(currentYear, 0, 1);
        double millisecondOfTheYear = Calendar.getInstance().getTimeInMillis() - calJanOne.getTimeInMillis();
        double dayOfTheYear = millisecondOfTheYear / 8.64E7;
        dayOfTheYear = Math.min(dayOfTheYear, 365.0);
        if (this.useSplineInterpolation) {
            return Math.max(this.splineFunction.value(dayOfTheYear), 0.0);
        }
        return Math.max(this.linearFunction.value(dayOfTheYear), 0.0);
    }
}

