/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SIR;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;

public class SIRImpl
extends SIImpl
implements SIR {
    protected static final double IMMUNITY_LOSS_RATE_EDEFAULT = 0.0;
    protected double immunityLossRate = 0.0;

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSIRLabel();
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSIRLabelValue();
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta);
        double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSIR.getI();
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSIR.getR();
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * currentSIR.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * currentSIR.getS() * effectiveInfectious;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            StandardInterventionLabel scl = this.findInterventionLabel((Node)diseaseLabel.getIdentifiable());
            double vaccinations = 0.0;
            double isolations = 0.0;
            if (scl != null) {
                vaccinations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getVaccinations();
                isolations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getIsolations();
                vaccinations *= (double)timeDelta / (double)this.getTimePeriod();
                isolations *= (double)timeDelta / (double)this.getTimePeriod();
                if (currentSIR.getS() < vaccinations) {
                    vaccinations = currentSIR.getS();
                }
                if (currentSIR.getI() < isolations) {
                    isolations = currentSIR.getI();
                }
                deltaS -= vaccinations;
                deltaR += vaccinations;
                deltaI -= isolations;
                deltaR += isolations;
            }
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)siExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            if (vaccinations > 0.0) {
                Exchange srExchange = (Exchange)ExchangePool.POOL.get();
                srExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                srExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                srExchange.setCount(vaccinations);
                srExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)srExchange);
            }
            if (isolations > 0.0) {
                Exchange irIsoExchange = (Exchange)ExchangePool.POOL.get();
                irIsoExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
                irIsoExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
                irIsoExchange.setCount(isolations);
                irIsoExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)irIsoExchange);
            }
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfInfectedToRecovered);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIR;
    }

    @Override
    public double getImmunityLossRate() {
        return this.immunityLossRate;
    }

    @Override
    public void setImmunityLossRate(double newImmunityLossRate) {
        this.immunityLossRate = newImmunityLossRate;
    }

    @Override
    public double getAdjustedImmunityLossRate(long timeDelta) {
        return this.getImmunityLossRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 23: {
                return this.getImmunityLossRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 23: {
                this.setImmunityLossRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 23: {
                this.setImmunityLossRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 23: {
                return this.immunityLossRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (immunityLossRate: ");
        result.append(this.immunityLossRate);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && this.getImmunityLossRate() >= 0.0;
        assert (retValue);
        boolean bl2 = retValue = retValue && !Double.isInfinite(this.getImmunityLossRate());
        assert (retValue);
        boolean bl3 = retValue = retValue && !Double.isNaN(this.getImmunityLossRate());
        assert (retValue);
        return retValue;
    }
}

