/**
 * <copyright>
 * 
 * Copyright (c) 2015 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.compare.report;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.compare.util.ModelCompareUtil;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public abstract class AbstractModelCompareReportGenerator implements IPostProcessor {
  public final static String MODEL_DIFF_REPORT_KIND = "kind";
  
  public final static String MODEL_DIFF_REPORT_LEFT_DIFF_URI = "leftURI";
  
  public final static String MODEL_DIFF_REPORT_LEFT_DIFF_TEXT = "leftChangeText";
  
  public final static String MODEL_DIFF_REPORT_RIGHT_DIFF_URI = "rightURI";
  
  public final static String MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT = "rightChangeText";
  
  public final static String MODEL_DIFF_REPORT_TARGET_REPORT_FOLDER_NAME = "reports";
  
  protected abstract CharSequence doGenerate(final Comparison comparison);
  
  public void generate(final Comparison comparison, final IFile targetFile) {
    CharSequence _doGenerate = this.doGenerate(comparison);
    this.writeFile(targetFile, _doGenerate);
  }
  
  public Notifier getLeftObject(final Comparison comparison) {
    Object _xblockexpression = null;
    {
      boolean _notEquals = (!Objects.equal(comparison, null));
      if (_notEquals) {
        EList<MatchResource> _matchedResources = comparison.getMatchedResources();
        boolean _isEmpty = _matchedResources.isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          EList<MatchResource> _matchedResources_1 = comparison.getMatchedResources();
          final MatchResource matchResource = _matchedResources_1.get(0);
          return matchResource.getLeft();
        } else {
          EList<Match> _matches = comparison.getMatches();
          boolean _isEmpty_1 = _matches.isEmpty();
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            EList<Match> _matches_1 = comparison.getMatches();
            final Match match = _matches_1.get(0);
            return match.getLeft();
          }
        }
      }
      _xblockexpression = null;
    }
    return ((Notifier)_xblockexpression);
  }
  
  public Notifier getRightObject(final Comparison comparison) {
    Object _xblockexpression = null;
    {
      boolean _notEquals = (!Objects.equal(comparison, null));
      if (_notEquals) {
        EList<MatchResource> _matchedResources = comparison.getMatchedResources();
        boolean _isEmpty = _matchedResources.isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          EList<MatchResource> _matchedResources_1 = comparison.getMatchedResources();
          final MatchResource matchResource = _matchedResources_1.get(0);
          return matchResource.getRight();
        } else {
          EList<Match> _matches = comparison.getMatches();
          boolean _isEmpty_1 = _matches.isEmpty();
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            EList<Match> _matches_1 = comparison.getMatches();
            final Match match = _matches_1.get(0);
            return match.getRight();
          }
        }
      }
      _xblockexpression = null;
    }
    return ((Notifier)_xblockexpression);
  }
  
  public IProject getTargetProject(final Comparison comparison) {
    boolean _notEquals = (!Objects.equal(comparison, null));
    if (_notEquals) {
      EList<MatchResource> _matchedResources = comparison.getMatchedResources();
      boolean _isEmpty = _matchedResources.isEmpty();
      if (_isEmpty) {
        EList<Match> _matches = comparison.getMatches();
        for (final Match match : _matches) {
          {
            EObject _left = match.getLeft();
            IFile file = EcorePlatformUtil.getFile(_left);
            boolean _equals = Objects.equal(file, null);
            if (_equals) {
              EObject _right = match.getRight();
              IFile _file = EcorePlatformUtil.getFile(_right);
              file = _file;
            }
            boolean _notEquals_1 = (!Objects.equal(file, null));
            if (_notEquals_1) {
              return file.getProject();
            }
          }
        }
      } else {
        EList<MatchResource> _matchedResources_1 = comparison.getMatchedResources();
        for (final MatchResource matchResource : _matchedResources_1) {
          {
            Resource _left = matchResource.getLeft();
            IFile file = EcorePlatformUtil.getFile(_left);
            boolean _equals = Objects.equal(file, null);
            if (_equals) {
              Resource _right = matchResource.getRight();
              IFile _file = EcorePlatformUtil.getFile(_right);
              file = _file;
            }
            boolean _notEquals_1 = (!Objects.equal(file, null));
            if (_notEquals_1) {
              return file.getProject();
            }
          }
        }
      }
    }
    return null;
  }
  
  public String getModelCompareInputText(final Object object) {
    String label = "";
    if ((object instanceof EObject)) {
      final URI uri = EcoreResourceUtil.getURI(((EObject)object), true);
      URI _trimQuery = uri.trimQuery();
      String _string = _trimQuery.toString();
      label = _string;
    } else {
      if ((object instanceof Resource)) {
        URI _uRI = ((Resource)object).getURI();
        URI _trimQuery_1 = _uRI.trimQuery();
        String _string_1 = _trimQuery_1.toString();
        label = _string_1;
      }
    }
    return label;
  }
  
  public String getName(final Object object) {
    String name = "";
    if ((object instanceof EObject)) {
      EClass _eClass = ((EObject)object).eClass();
      final EStructuralFeature eStructuralFeature = EObjectUtil.getEStructuralFeature(_eClass, "name");
      boolean _notEquals = (!Objects.equal(eStructuralFeature, null));
      if (_notEquals) {
        Object _eGet = ((EObject)object).eGet(eStructuralFeature, false);
        String _string = null;
        if (_eGet!=null) {
          _string=_eGet.toString();
        }
        name = _string;
      } else {
        EClass _eClass_1 = ((EObject)object).eClass();
        String _name = _eClass_1.getName();
        String _plus = (_name + "@");
        int _hashCode = ((EObject)object).hashCode();
        String _hexString = Integer.toHexString(_hashCode);
        String _plus_1 = (_plus + _hexString);
        name = _plus_1;
      }
    } else {
      if ((object instanceof Resource)) {
        URI _uRI = ((Resource)object).getURI();
        URI _trimQuery = _uRI.trimQuery();
        String _lastSegment = _trimQuery.lastSegment();
        name = _lastSegment;
      }
    }
    return name;
  }
  
  public String getDiffKindText(final Diff diff) {
    DifferenceKind _kind = null;
    if (diff!=null) {
      _kind=diff.getKind();
    }
    final DifferenceKind kind = _kind;
    boolean _equals = Objects.equal(kind, DifferenceKind.DELETE);
    if (_equals) {
      if ((diff instanceof ReferenceChange)) {
        final EReference reference = ((ReferenceChange)diff).getReference();
        boolean _isContainment = reference.isContainment();
        if (_isContainment) {
          return "DELETED from ";
        } else {
          return "REMOVED from ";
        }
      }
    } else {
      boolean _equals_1 = Objects.equal(kind, DifferenceKind.ADD);
      if (_equals_1) {
        return "ADDED to ";
      }
    }
    return (kind + "D ");
  }
  
  public String getDiffKindLabel(final DifferenceKind kind) {
    if (kind != null) {
      switch (kind) {
        case ADD:
          return "+-";
        case DELETE:
          return "-+";
        case CHANGE:
          return "<>";
        case MOVE:
          return "~";
        default:
          return "<>";
      }
    } else {
      return "<>";
    }
  }
  
  public Map<String, Object> handleDifferences(final Comparison comparison, final Diff diff) {
    Map<String, Object> map = CollectionLiterals.<String, Object>newHashMap();
    boolean _notEquals = (!Objects.equal(diff, null));
    if (_notEquals) {
      final DifferenceKind kind = diff.getKind();
      String _diffKindLabel = this.getDiffKindLabel(kind);
      map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_KIND, _diffKindLabel);
      StringBuffer _diffObjectURIFragment = this.getDiffObjectURIFragment(diff, DifferenceSource.LEFT);
      map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_URI, _diffObjectURIFragment);
      StringBuffer _diffObjectURIFragment_1 = this.getDiffObjectURIFragment(diff, DifferenceSource.RIGHT);
      map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_URI, _diffObjectURIFragment_1);
      if ((diff instanceof AttributeChange)) {
        StringBuffer _attributeChangeText = this.getAttributeChangeText(((AttributeChange)diff));
        map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _attributeChangeText);
        StringBuffer _attributeChangeText_1 = this.getAttributeChangeText(((AttributeChange)diff));
        map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _attributeChangeText_1);
      } else {
        DifferenceSource _source = diff.getSource();
        boolean _equals = Objects.equal(_source, DifferenceSource.LEFT);
        if (_equals) {
          boolean _equals_1 = Objects.equal(kind, DifferenceKind.ADD);
          if (_equals_1) {
            StringBuffer _referenceChangeText = this.getReferenceChangeText(diff, false);
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText);
            StringBuffer _referenceChangeText_1 = this.getReferenceChangeText(diff, true);
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_1);
          } else {
            boolean _equals_2 = Objects.equal(kind, DifferenceKind.DELETE);
            if (_equals_2) {
              StringBuffer _referenceChangeText_2 = this.getReferenceChangeText(diff, false);
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_2);
              StringBuffer _referenceChangeText_3 = this.getReferenceChangeText(diff, true);
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_3);
            } else {
              boolean _equals_3 = Objects.equal(kind, DifferenceKind.MOVE);
              if (_equals_3) {
                StringBuffer _referenceChangeText_4 = this.getReferenceChangeText(diff, false);
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_4);
                StringBuffer _referenceChangeText_5 = this.getReferenceChangeText(diff, true);
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_5);
              }
            }
          }
        } else {
          boolean _equals_4 = Objects.equal(kind, DifferenceKind.ADD);
          if (_equals_4) {
            StringBuffer _referenceChangeText_6 = this.getReferenceChangeText(diff, true);
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_6);
            StringBuffer _referenceChangeText_7 = this.getReferenceChangeText(diff, false);
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_7);
          } else {
            boolean _equals_5 = Objects.equal(kind, DifferenceKind.DELETE);
            if (_equals_5) {
              StringBuffer _referenceChangeText_8 = this.getReferenceChangeText(diff, true);
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_8);
              StringBuffer _referenceChangeText_9 = this.getReferenceChangeText(diff, false);
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_9);
            } else {
              boolean _equals_6 = Objects.equal(kind, DifferenceKind.MOVE);
              if (_equals_6) {
                StringBuffer _referenceChangeText_10 = this.getReferenceChangeText(diff, true);
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_10);
                StringBuffer _referenceChangeText_11 = this.getReferenceChangeText(diff, false);
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_11);
              }
            }
          }
        }
      }
    }
    return map;
  }
  
  public StringBuffer getDiffObjectURIFragment(final Diff diff, final DifferenceSource source) {
    StringBuffer _xblockexpression = null;
    {
      StringBuffer label = new StringBuffer();
      EObject value = null;
      if ((diff instanceof AttributeChange)) {
        final Match match = ((AttributeChange)diff).getMatch();
        EObject _xifexpression = null;
        boolean _equals = Objects.equal(source, DifferenceSource.LEFT);
        if (_equals) {
          _xifexpression = match.getLeft();
        } else {
          _xifexpression = match.getRight();
        }
        value = _xifexpression;
      } else {
        if ((diff instanceof ReferenceChange)) {
          Match _match = ((ReferenceChange)diff).getMatch();
          Comparison _comparison = _match.getComparison();
          EObject _value = ModelCompareUtil.getValue(_comparison, diff);
          value = _value;
        }
      }
      boolean _notEquals = (!Objects.equal(value, null));
      if (_notEquals) {
        URI _uRI = EcoreResourceUtil.getURI(value);
        String _fragment = null;
        if (_uRI!=null) {
          _fragment=_uRI.fragment();
        }
        label.append(_fragment);
      }
      _xblockexpression = label;
    }
    return _xblockexpression;
  }
  
  public StringBuffer getAttributeChangeText(final AttributeChange attributeChange) {
    StringBuffer _xblockexpression = null;
    {
      StringBuffer label = new StringBuffer();
      boolean _notEquals = (!Objects.equal(attributeChange, null));
      if (_notEquals) {
        EAttribute _attribute = attributeChange.getAttribute();
        String _name = null;
        if (_attribute!=null) {
          _name=_attribute.getName();
        }
        String _plus = ("[" + _name);
        String _plus_1 = (_plus + " ");
        DifferenceKind _kind = attributeChange.getKind();
        String _plus_2 = (_plus_1 + _kind);
        String _plus_3 = (_plus_2 + "D");
        String _plus_4 = (_plus_3 + "]");
        label.append(_plus_4);
      }
      _xblockexpression = label;
    }
    return _xblockexpression;
  }
  
  public StringBuffer getReferenceChangeText(final Diff diff, final boolean opposite) {
    StringBuffer _xblockexpression = null;
    {
      StringBuffer label = new StringBuffer();
      if ((diff instanceof ReferenceChange)) {
        final DifferenceKind kind = ((ReferenceChange)diff).getKind();
        String kindLabel = "";
        if ((!opposite)) {
          String _diffKindText = this.getDiffKindText(diff);
          kindLabel = _diffKindText;
        } else {
          boolean _equals = Objects.equal(kind, DifferenceKind.ADD);
          if (_equals) {
            kindLabel = "DELETED from ";
            final EReference reference = ((ReferenceChange)diff).getReference();
            boolean _isContainment = reference.isContainment();
            boolean _not = (!_isContainment);
            if (_not) {
              kindLabel = "REMOVED from ";
            }
          } else {
            boolean _equals_1 = Objects.equal(kind, DifferenceKind.DELETE);
            if (_equals_1) {
              kindLabel = "ADDED to ";
            } else {
              String _plus = (kind + "D ");
              kindLabel = _plus;
            }
          }
        }
        EObject _xifexpression = null;
        if ((!opposite)) {
          Match _match = ((ReferenceChange)diff).getMatch();
          _xifexpression = _match.getLeft();
        } else {
          Match _match_1 = ((ReferenceChange)diff).getMatch();
          _xifexpression = _match_1.getRight();
        }
        final EObject matchValue = _xifexpression;
        StringBuffer _append = label.append(" [");
        StringBuffer _append_1 = _append.append(kindLabel);
        String _name = this.getName(matchValue);
        String _plus_1 = (_name + ".");
        EReference _reference = ((ReferenceChange)diff).getReference();
        String _name_1 = null;
        if (_reference!=null) {
          _name_1=_reference.getName();
        }
        String _plus_2 = (_plus_1 + _name_1);
        StringBuffer _append_2 = _append_1.append(_plus_2);
        return _append_2.append("]");
      }
      _xblockexpression = label;
    }
    return _xblockexpression;
  }
  
  public void writeFile(final IFile targetFile, final CharSequence content) {
    try {
      final NullProgressMonitor monitor = new NullProgressMonitor();
      boolean _exists = targetFile.exists();
      if (_exists) {
        targetFile.delete(true, monitor);
      }
      String _string = content.toString();
      byte[] _bytes = _string.getBytes();
      ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
      targetFile.create(_byteArrayInputStream, true, monitor);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void createFolder(final IFolder folder) {
    try {
      final NullProgressMonitor monitor = new NullProgressMonitor();
      boolean _exists = folder.exists();
      boolean _not = (!_exists);
      if (_not) {
        folder.create(true, false, monitor);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void postComparison(final Comparison comparison, final Monitor monitor) {
  }
  
  public void postConflicts(final Comparison comparison, final Monitor monitor) {
  }
  
  public void postDiff(final Comparison comparison, final Monitor monitor) {
  }
  
  public void postEquivalences(final Comparison comparison, final Monitor monitor) {
  }
  
  public void postMatch(final Comparison comparison, final Monitor monitor) {
  }
  
  public void postRequirements(final Comparison comparison, final Monitor monitor) {
  }
}
